/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.Version;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.zip.ZipCommand;
import org.tizen.common.util.IOUtil;
import org.tizen.nativecommon.build.NativeSigner;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.buildnative.BuildInfo;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeOption;
import org.tizen.ncli.subcommands.packages.NativeProject;
import org.tizen.ncli.subcommands.packages.PackageData;
import org.tizen.ncli.subcommands.packages.PackageNativeCLICommandData;
import org.tizen.ncli.subcommands.packages.PackageProject;
import org.tizen.ncli.subcommands.sign.SignCLICommand;
import org.tizen.ncli.util.TempDirUtil;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapManager;
import org.tizen.sbilib.for_cli.sbiplugin.SBIToolchainData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIToolchainManager;
import org.tizen.ssilib.SSIData;
import org.tizen.ssilib.SSIMacro;
import org.tizen.ssilib.SSIProcess;
import org.tizen.ssilib.SSITargetType;
import org.tizen.tpklib.TPK;
import org.tizen.tpklib.core.sign.ISigner;
import org.tizen.tpklib.exception.TPKException;
import org.w3c.dom.Document;

public class PackageNativeCLICommand
extends AbstractSubCommand<PackageNativeCLICommandData> {
    private PackageNativeCLICommandData data = new PackageNativeCLICommandData();
    private Configuration config = new Configuration();
    private String profilesPath;
    private String profileName;
    private String projectPath;
    private String outputPath;
    private String buildConfiguration;
    private String tpkPath = null;
    private String tepPath = null;
    private boolean isStrip = false;
    private List<String> refPaths = null;

    @Override
    protected PackageNativeCLICommandData call() {
        if (this.data == null) {
            return null;
        }
        String projDir = this.data.getProjectDir();
        PackageData ssiData = PackageNativeCLICommand.getEnv(this.workingDir.toString(), projDir, this.log);
        if (ssiData == null) {
            this.log.debug("Cannot get the ssiData to package " + projDir);
            throw new UnexpectedException(2, "Cannot get the project informations to package " + projDir);
        }
        String stripper = null;
        if (this.isStrip) {
            SBIToolchainData.ToolData tool;
            String sdkPath = InstallPathConfig.getSDKPath();
            String sbiHomePath = null;
            if (sdkPath == null) {
                this.log.debug("Cannot get SDKPath");
                throw new UnexpectedException(2, "Cannot get SDKPath.");
            }
            sbiHomePath = sdkPath + File.separator + BuildNativeOption.SBI_HOME_PATH;
            this.isStrip = false;
            String toolchainName = ssiData.getToolchain();
            if (toolchainName == null) {
                this.log.debug("Cannot get the toolchain name.");
                throw new UnexpectedException(2, "Cannot get the toolchain name.");
            }
            String projType = ssiData.getProjType();
            List toolchainList = SBIToolchainManager.getToolchainDataList((String)sbiHomePath);
            SBIToolchainData toolchain = SBIToolchainManager.getToolchain((List)toolchainList, (String)toolchainName, (String)ssiData.getArchitecture(), (String)new String("org.tizen.nativecore.buildArtefactType." + projType));
            if (toolchain != null && (tool = toolchain.getTool("strip")) != null && (stripper = tool.pathOrg) != null && !stripper.isEmpty()) {
                if (toolchainName.startsWith("LLVM")) {
                    SBIToolchainData toolchain2;
                    SBIRootstrapData.ToolchainData defToolchainData;
                    String profileName = ssiData.getSbiProfile();
                    String profileVer = ssiData.getProfileVersion();
                    String arch = ssiData.getArchitecture();
                    List rootstapList = SBIRootstrapManager.getRootstrapDataList((String)sbiHomePath);
                    SBIRootstrapData rootstrap = SBIRootstrapManager.getRootstrap((List)rootstapList, (String)(profileName + " " + profileVer), (String)arch);
                    if (rootstrap != null && (defToolchainData = rootstrap.getDefaultToolchain("gcc")) != null && (toolchain2 = SBIToolchainManager.getToolchain((List)toolchainList, (String)(defToolchainData.name + "-" + defToolchainData.version), (String)arch, (String)new String("org.tizen.nativecore.buildArtefactType." + projType))) != null) {
                        String defGccPath = toolchain2.getPath();
                        stripper = stripper.replace("#{PLATFORM_DEFAULT_GCC_PATH}", defGccPath);
                    }
                }
                if (new File(stripper = stripper.replace("#{SBI_HOME}", sbiHomePath)).exists()) {
                    this.isStrip = true;
                } else {
                    this.progressLog.info(String.format("Cannot found strip tool in '%s'.", stripper));
                }
            }
            if (!this.isStrip) {
                this.progressLog.info(String.format("Not supported strip option with '%s' build configuration", this.buildConfiguration));
            }
        }
        List<String> exclude = this.data.getResExclude();
        Map<String, String> include = this.data.getResInclude();
        String arch = ssiData.getArchitecture();
        if (arch == null) {
            this.log.debug("Cannot get the target architecture.");
            throw new UnexpectedException(2, "Cannot get the target architecture.");
        }
        if (arch.equals("i386")) {
            ssiData.setArchitecture("x86");
        } else if (arch.equals("armel")) {
            ssiData.setArchitecture("arm");
        }
        boolean result = this.doPackage(this.outputPath, ssiData.getPackageName(), ssiData.getPackageVersion(), ssiData.getArchitecture(), ssiData.getArtifactName(), include, exclude, stripper, this.profileName, ssiData.getProfileVersion());
        if (result) {
            this.data.tpkPath = this.genTpkPath(ssiData.getPackageName(), ssiData.getPackageVersion(), ssiData.getArchitecture());
            this.log.debug("Package path: {}", (Object)this.data.tpkPath);
            return this.data;
        }
        return null;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    public void setReferencePaths(List<String> refPaths) {
        this.refPaths = refPaths;
    }

    public List<String> getReferencePaths() {
        return this.refPaths;
    }

    private boolean setProfilesPath() {
        this.profilesPath = this.config.getValue("profiles.path");
        if (this.profilesPath == null) {
            this.profilesPath = this.config.getValue("default.profiles.path");
        }
        return this.profilesPath != null && !this.profilesPath.isEmpty();
    }

    public void setIsStrip(boolean isStrip) {
        this.isStrip = isStrip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackageData getEnv(String workingDir, String projDir, Logger log) {
        PackageData data = new PackageData();
        try {
            block15: {
                String projectType;
                Properties prop;
                block17: {
                    File projectDefFile;
                    block16: {
                        block14: {
                            data.setWorkingDir(workingDir);
                            File parentFile = projDir == null || projDir.isEmpty() ? new File(workingDir).getParentFile() : new File(projDir);
                            if (parentFile == null || !parentFile.exists()) break block14;
                            String projectPath = parentFile.getCanonicalPath();
                            log.debug("Base project directory: {}", (Object)projectPath);
                            data.setProjectPath(projectPath);
                            String projectFilePath = projectPath + File.separatorChar + ".project";
                            data.setProjectFilePath(projectFilePath);
                            String manifestPath = projectPath + File.separatorChar + "tizen-manifest.xml";
                            data.setManifestFilePath(manifestPath);
                            projectDefFile = new File(projectPath, "project_def.prop");
                            if (!projectDefFile.exists()) break block15;
                            break block16;
                        }
                        log.error("Specify proper build configuration path");
                        return null;
                    }
                    FileInputStream is = null;
                    prop = new Properties();
                    try {
                        is = new FileInputStream(projectDefFile);
                        prop.load(is);
                    }
                    catch (IOException e) {
                        PackageData packageData;
                        try {
                            e.printStackTrace();
                            packageData = null;
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{is});
                            throw throwable;
                        }
                        IOUtil.tryClose((Object[])new Object[]{is});
                        return packageData;
                    }
                    IOUtil.tryClose((Object[])new Object[]{is});
                    projectType = prop.getProperty("type");
                    if (projectType != null) break block17;
                    log.error("Cannot get project type");
                    throw new UnexpectedException(2, "Cannot get project type");
                }
                data.setProjType(projectType);
                String appId = prop.getProperty("APPNAME");
                data.setAppId(appId);
            }
            Document projectDoc = null;
            Document manifestDoc = null;
            try {
                projectDoc = data.getProjectFilePath() != null ? NativeProject.getDocument(data.getProjectFilePath()) : null;
                manifestDoc = data.getManifestFilePath() != null ? NativeProject.getDocument(data.getManifestFilePath()) : null;
            }
            catch (Exception e) {
                log.error("Error occured during getting project file", (Object)e.getMessage());
                return null;
            }
            BuildInfo buildInfo = PackageProject.getBuildInfo(workingDir, log);
            if (buildInfo == null) {
                log.error("Packaging error : Cannot find build information. \"build.info\" file does not exist.");
            }
            if (buildInfo != null) {
                String arch = buildInfo.getArchitecture();
                data.setArchitecture(arch);
                String profileName = buildInfo.getProfileName();
                data.setSbiProfile(profileName);
                String profileVer = buildInfo.getProfileVersion();
                data.setProfileVersion(profileVer);
                String toolchain = buildInfo.getToolchain();
                data.setToolchain(toolchain);
            }
            String packageName = NativeProject.getPackageName(manifestDoc);
            data.setPackageName(packageName);
            String packageVersion = NativeProject.getVersion(manifestDoc);
            data.setPackageVersion(packageVersion);
            String projectName = NativeProject.getProjectName(projectDoc);
            String artifactName = NativeProject.getArtifactName(manifestDoc);
            if (artifactName != null) {
                artifactName = artifactName.toLowerCase();
            } else {
                if (projectName == null) {
                    log.error("Cannot get the artifact name.");
                    throw new UnexpectedException(2, "Cannot get the artifact name.");
                }
                artifactName = projectName.toLowerCase();
            }
            if (data.getProjType() != null && data.getProjType().equalsIgnoreCase("sharedLib")) {
                artifactName = "lib" + artifactName + ".so";
            }
            data.setArtifactName(artifactName);
            return data;
        }
        catch (IOException e) {
            log.error("Error occurred during setting working directory", (Object)e.getMessage());
            return null;
        }
    }

    private String genTpkPath(String packageName, String packageVersion, String architecture) {
        String pkgArch = this.getPkgArchitecture(architecture);
        this.tpkPath = pkgArch == null || pkgArch.isEmpty() ? this.outputPath + File.separatorChar + packageName + "-" + packageVersion + ".tpk" : this.outputPath + File.separatorChar + packageName + "-" + packageVersion + "-" + pkgArch + ".tpk";
        return this.tpkPath;
    }

    private String genTepPath(String packageName, String packageHash) {
        if (this.tepPath == null) {
            this.tepPath = this.outputPath + File.separatorChar + packageName + "-" + packageHash + ".tep";
        }
        return this.tepPath;
    }

    private String getPkgArchitecture(String architecture) {
        for (String arch : BuildNativeOption.ARCHGROUP_ARM) {
            if (!arch.equals(architecture)) continue;
            return BuildNativeOption.ARCHGROUP_ARM[0];
        }
        return architecture;
    }

    public void setProjectPath(String projDir) {
        this.data.setProjectDir(projDir);
    }

    public void setResExclude(List<String> resExclude) {
        this.data.setResExclude(resExclude);
    }

    public void setResInclude(Map<String, String> resInclude) {
        this.data.setResInclude(resInclude);
    }

    public boolean doPackage(String workingProjectConfigurationPath, String packageName, String packageVersion, String arch, String artifactName, Map<String, String> include, List<String> exclude, String stripper, String profileName, String profileVer) {
        TPK tpk = TPK.getInstance();
        tpk.setOutputStream((OutputStream)System.out);
        tpk.setErrorStream((OutputStream)System.out);
        try {
            Version version;
            NativeSigner signer = new NativeSigner(null);
            boolean isSign = false;
            if (profileName != null && !profileName.isEmpty() && !(isSign = this.setProfilesPath())) {
                this.log.error(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
                this.progressLog.error(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
                return false;
            }
            boolean needEmptyDirectory = true;
            if (profileVer != null && (version = new Version(profileVer)).isSameOrBiggerThanVersion3()) {
                needEmptyDirectory = false;
            }
            tpk.packaging(workingProjectConfigurationPath, packageName, packageVersion, arch, artifactName, include, exclude, stripper, isSign, (ISigner)signer, this.profilesPath, profileName, needEmptyDirectory);
        }
        catch (TPKException e) {
            this.progressLog.error(e.getMessage());
            return false;
        }
        return true;
    }

    private String getTEPHashCode(String tepPath) {
        if (tepPath == null || tepPath.isEmpty()) {
            return null;
        }
        File tepFile = new File(tepPath);
        if (tepFile == null || !tepFile.exists()) {
            return null;
        }
        StringBuffer lastModified = new StringBuffer(Long.toString(tepFile.lastModified()));
        if (lastModified.length() < 10) {
            for (int i = 0; i < 10 - lastModified.length(); ++i) {
                lastModified.append(0);
            }
        }
        return lastModified.substring(0, 10);
    }

    public void processSSI(String stripper, boolean needEmptyDirectory) {
        File outFile;
        String sdkPath = InstallPathConfig.getSDKPath();
        SSIProcess ssi = new SSIProcess(sdkPath);
        if (stripper != null && !stripper.isEmpty()) {
            ssi.getGlobalMacros().put("__PARAM1__", stripper);
        }
        ssi.getGlobalMacros().put("__PARAM2__", needEmptyDirectory ? "mandatory" : "strip");
        PackageData data2 = PackageNativeCLICommand.getEnv(this.workingDir.toString(), this.data.getProjectDir(), this.log);
        if (data2 == null) {
            this.log.error("Cannot get the project information.");
            throw new UnexpectedException(2, "Cannot get the project information.");
        }
        SSIData ssiData = new SSIData();
        ssiData.putProperty("sdk.path", (Object)sdkPath);
        ssiData.putProperty("project.path", (Object)this.projectPath);
        ssiData.putProperty("app.id", (Object)data2.getAppId());
        ssiData.putProperty("app.type", (Object)data2.getProjType());
        ssiData.putProperty("build.config", (Object)data2.getSbiConfig());
        ssiData.putProperty("build.arch", (Object)data2.getArchitecture());
        ssiData.putProperty("project.output.path", (Object)this.workingDir.toString());
        boolean result = false;
        File ssiConfFile = new File(this.projectPath, "Build/SSI.xml");
        if (ssiConfFile.exists() && (result = ssi.analisysPackageScript(ssiConfFile, ssiData, "1.0"))) {
            ssi.setHomePath(this.projectPath + "/Build");
        }
        if (!result && (ssiConfFile = new File(sdkPath, "tools/ide/resources/common/Build/SSI.xml")).exists() && (result = ssi.analisysPackageScript(ssiConfFile, ssiData))) {
            ssi.setHomePath(sdkPath + "/tools/ide/resources/common/Build");
        }
        File tempFile = null;
        File tempFile2 = null;
        try {
            tempFile = TempDirUtil.createTempDirectory();
            tempFile2 = TempDirUtil.createTempDirectory();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (this.refPaths == null || this.refPaths.isEmpty()) {
            ssi.procStructuring("tpk", new SSITargetType[]{new SSITargetType("project", "native", this.data.getProjectDir(), this.workingDir.toString(), (SSIMacro.Runner)new PackageProject.MacroRunner(data2))}, tempFile.toString(), this.log);
            ssi.procStructuring("tep", new SSITargetType[]{new SSITargetType("project", "native", this.data.getProjectDir(), this.workingDir.toString(), (SSIMacro.Runner)new PackageProject.MacroRunner(data2))}, tempFile2.toString(), this.log);
        } else {
            ArrayList<SSITargetType> targets = new ArrayList<SSITargetType>();
            targets.add(new SSITargetType("project", "native", data2.getProjectPath(), this.workingDir.toString(), (SSIMacro.Runner)new PackageProject.MacroRunner(data2)));
            for (String target : this.refPaths) {
                PackageData data3 = PackageNativeCLICommand.getEnv(target, null, this.log);
                if (data3 == null) continue;
                SSIData ssiData2 = new SSIData();
                ssiData2.putProperty("sdk.path", (Object)sdkPath);
                ssiData2.putProperty("project.path", (Object)target);
                ssiData2.putProperty("app.id", (Object)data3.getAppId());
                ssiData2.putProperty("app.type", (Object)data3.getProjType());
                ssiData2.putProperty("build.config", (Object)data3.getSbiConfig());
                ssiData2.putProperty("build.arch", (Object)data3.getArchitecture());
                ssiData2.putProperty("project.output.path", (Object)this.workingDir.toString());
                targets.add(new SSITargetType("project", "native", this.projectPath, this.workingDir.toString(), (SSIMacro.Runner)new PackageProject.MacroRunner(data3)));
            }
            targets.add(new SSITargetType("package", "", null, null, null));
            ssi.procStructuring("multi_pack", targets.toArray(new SSITargetType[targets.size()]), tempFile.toString(), this.log);
            ssi.procStructuring("tep", targets.toArray(new SSITargetType[targets.size()]), tempFile2.toString(), this.log);
        }
        if (this.profileName != null && !this.profileName.isEmpty()) {
            File tmp = new File(tempFile, ".manifest.tmp");
            if (tmp.exists()) {
                tmp.delete();
            }
            SignCLICommand signCmd = new SignCLICommand();
            signCmd.setWorkingDir(tempFile);
            signCmd.setProfileName(this.profileName);
            signCmd.runCommand();
            if (tmp.exists()) {
                tmp.delete();
            }
        }
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        File packOutFile = new File(this.outputPath);
        if (this.tpkPath == null) {
            this.tpkPath = this.genTpkPath(data2.getPackageName(), data2.getPackageVersion(), data2.getArchitecture());
        }
        if ((outFile = new File(this.tpkPath)).exists()) {
            outFile.delete();
        }
        ZipCommand zipCmd = new ZipCommand(tempFile.toString(), this.tpkPath);
        zipCmd.setExcludes(new String[]{".manifest.tmp"});
        executor.execute(new Command[]{zipCmd});
        TempDirUtil.deleteDirectory(tempFile);
        String[] tepList = packOutFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".tep");
            }
        });
        if (tempFile2.list() != null && tempFile2.list().length > 0) {
            String lastModified = this.getTEPHashCode(tempFile2.toString());
            if (this.tepPath == null) {
                this.tepPath = this.genTepPath(data2.getPackageName(), lastModified);
            }
            outFile = new File(this.tepPath);
            boolean nobuild = false;
            for (String tepName : tepList) {
                File tepFile = new File(packOutFile, tepName);
                if (tepFile.equals(outFile)) {
                    nobuild = true;
                    continue;
                }
                tepFile.delete();
            }
            if (!nobuild) {
                if (outFile.exists()) {
                    outFile.delete();
                }
                zipCmd = new ZipCommand(tempFile2.toString(), this.tepPath);
                executor.execute(new Command[]{zipCmd});
            }
        } else {
            for (String tepName : tepList) {
                File tepFile = new File(packOutFile, tepName);
                tepFile.delete();
            }
        }
        TempDirUtil.deleteDirectory(tempFile2);
    }
}

