/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.osgi.util.NLS;
import org.kohsuke.args4j.Option;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.shell.AbstractSecurityProfileCLI;

@TizenSubCommand(name="list", usage="Show the security profiles.")
public class SecurityProfileListCLI
extends AbstractSecurityProfileCLI {
    @Option(name="-n", aliases={"--name"}, usage="Specify the name of the security profile to list. If you skip this option, a set of the security profile names in the profiles.xml file is displayed.")
    private String name;

    @Override
    public int execute() {
        int result = 0;
        this.log.trace("Begin SecurityProfileListCLI...");
        File directory = this.getProfileXMLFile();
        if (directory == null) {
            this.progressLog.error("No exist the default path of security profiles.");
            return 2;
        }
        SigningProfileContainer container = null;
        try {
            container = this.readXML(directory);
            this.log.trace("Read XML: {} profile found.", (Object)container.getProfiles().size());
            if (this.name == null) {
                this.printProfileList(container);
            } else {
                this.printProfileInformation(container);
            }
        }
        catch (FileNotFoundException e) {
            this.progressLog.error("Not found a file of security profiles. Please check specified path.");
            return 2;
        }
        catch (UnexpectedException e) {
            throw e;
        }
        this.log.trace("Finish SecurityProfileListCLI...");
        return result;
    }

    private void printProfileList(SigningProfileContainer container) {
        this.progressLog.info("========================================");
        this.progressLog.info("Name");
        this.progressLog.info("========================================");
        for (SigningProfile profile : container.getProfiles()) {
            this.progressLog.info("{}", (Object)profile.getProfileName());
        }
    }

    private void printProfileInformation(SigningProfileContainer container) {
        SigningProfile profile = container.getProfileByName(this.name);
        if (profile == null) {
            this.progressLog.error("There is no '{}' profile in security profiles. Please check the profile list by 'tizen security-profiles list' command.", (Object)this.name);
            throw new UnexpectedException(2, NLS.bind((String)"There is no '{}' profile in security profiles. Please check the profile list by 'tizen security-profiles list' command.", (Object)this.name));
        }
        this.progressLog.info("========================================");
        this.progressLog.info("'{}' profile information", (Object)this.name);
        this.progressLog.info("========================================");
        this.progressLog.info(this.buildInformation(profile));
    }
}

