/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.log.Level;
import org.tizen.common.util.log.Messages;

public class FileAppender
extends AppenderSkeleton {
    private int bufferSize;
    private static final LoggingEvent dummy = new LoggingEvent(null, (Category)Logger.getLogger((String)"FileAppender"), (Priority)Level.OFF, (Object)"", null);
    OutputStream FILE_OUTPUT_STREAM;
    private FileAppenderScheduler SCHEDULER;
    private static final Timer TIMER = new Timer("File appender timer", true);
    protected String logPath;
    protected final OutputStream NOOP_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };
    protected final FileAppenderScheduler NOOP_SCHEDULER = new FileAppenderScheduler(this){

        @Override
        public void run() {
        }

        @Override
        public boolean cancel() {
            return true;
        }
    };

    public FileAppender(String logPath) {
        this(logPath, (Layout)new EnhancedPatternLayout("[%d{yyyy.MM.dd HH:mm:ss}][%-5p] %F(%L) - %m%n"), 5000);
    }

    public FileAppender(String logPath, Layout layout) {
        this(logPath, layout, 5000);
    }

    public FileAppender(String logPath, Layout layout, int bufferSize) {
        this.setName("TIZEN_FILE_APPENDER");
        this.logPath = new EnhancedPatternLayout(logPath).format(dummy);
        this.bufferSize = bufferSize;
        this.setLayout(layout);
        this.initializeAppender();
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public synchronized String setFilePath(String path) {
        IOUtil.tryFlush(this.FILE_OUTPUT_STREAM);
        IOUtil.tryClose(this.FILE_OUTPUT_STREAM);
        EnhancedPatternLayout layout = new EnhancedPatternLayout(path);
        this.logPath = layout.format(dummy);
        return this.initializeAppender();
    }

    public synchronized void setBufferSize(int bufferSize) {
        IOUtil.tryFlush(this.FILE_OUTPUT_STREAM);
        IOUtil.tryClose(this.FILE_OUTPUT_STREAM);
        this.bufferSize = bufferSize;
        this.initializeAppender();
    }

    protected synchronized void append(LoggingEvent arg0) {
        try {
            try {
                String[] tss;
                this.FILE_OUTPUT_STREAM.write(this.layout.format(arg0).getBytes());
                if (this.getLayout().ignoresThrowable() && (tss = arg0.getThrowableStrRep()) != null) {
                    String[] stringArray = tss;
                    int n = tss.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ts = stringArray[n2];
                        this.FILE_OUTPUT_STREAM.write((String.valueOf(ts) + "\n").getBytes());
                        ++n2;
                    }
                }
            }
            catch (IOException e) {
                LogLog.error((String)Messages.FileAppender_EXCEPTION_WRITING_LOG, (Throwable)e);
            }
            this.SCHEDULER.cancel();
            this.SCHEDULER = new FileAppenderScheduler();
            TIMER.scheduleAtFixedRate((TimerTask)this.SCHEDULER, 3000L, 3000L);
        }
        catch (Throwable t) {
            LogLog.error((String)MessageFormat.format("Exception occurred while logging message: {0}", arg0.getMessage()), (Throwable)t);
        }
    }

    private synchronized String initializeAppender() {
        this.createLogFile(this.logPath);
        File logFile = new File(this.logPath);
        String message = "";
        if (!logFile.exists()) {
            File parent = logFile.getAbsoluteFile().getParentFile();
            if (parent != null) {
                parent.mkdirs();
                try {
                    logFile.createNewFile();
                }
                catch (IOException e) {
                    this.FILE_OUTPUT_STREAM = this.NOOP_OUTPUT_STREAM;
                    this.SCHEDULER = this.NOOP_SCHEDULER;
                    message = NLS.bind((String)Messages.FileAppender_EXCEPTION_CREATING_LOGFILE, (Object)this.logPath);
                    LogLog.error((String)NLS.bind((String)Messages.FileAppender_EXCEPTION_CREATING_LOGFILE, (Object)this.logPath), (Throwable)e);
                    return message;
                }
            }
        } else if (logFile.isDirectory()) {
            this.FILE_OUTPUT_STREAM = this.NOOP_OUTPUT_STREAM;
            this.SCHEDULER = this.NOOP_SCHEDULER;
            message = NLS.bind((String)Messages.FileAppender_EXCEPTION_DIRECTORY_EXISTING, (Object)this.logPath);
            LogLog.error((String)NLS.bind((String)Messages.FileAppender_EXCEPTION_DIRECTORY_EXISTING, (Object)this.logPath));
            return message;
        }
        IOUtil.tryFlush(this.FILE_OUTPUT_STREAM);
        IOUtil.tryClose(this.FILE_OUTPUT_STREAM);
        try {
            this.FILE_OUTPUT_STREAM = new BufferedOutputStream(new FileOutputStream(this.logPath, true), this.bufferSize);
        }
        catch (IOException e) {
            this.FILE_OUTPUT_STREAM = this.NOOP_OUTPUT_STREAM;
            this.SCHEDULER = this.NOOP_SCHEDULER;
            message = Messages.FileAppender_EXCEPTION_CREATING_BUFFER;
            LogLog.error((String)Messages.FileAppender_EXCEPTION_CREATING_BUFFER, (Throwable)e);
            return message;
        }
        this.SCHEDULER = new FileAppenderScheduler();
        TIMER.scheduleAtFixedRate((TimerTask)this.SCHEDULER, 3000L, 3000L);
        return message;
    }

    private void createLogFile(String logPath2) {
    }

    public class FileAppenderScheduler
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileAppender fileAppender = FileAppender.this;
            synchronized (fileAppender) {
                try {
                    FileAppender.this.FILE_OUTPUT_STREAM.flush();
                }
                catch (IOException e) {
                    LogLog.error((String)Messages.FileAppender_EXCEPTION_FLUSHING_BUFFER, (Throwable)e);
                }
            }
        }
    }
}

