/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.signer;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.tizen.common.file.FileHandler;
import org.tizen.common.sign.model.Delta;
import org.tizen.common.sign.model.DeltaState;
import org.tizen.common.sign.signer.AbstractResourceParser;
import org.tizen.common.util.Assert;
import org.tizen.common.util.StringUtil;

public class DeltaListResourceParser
extends AbstractResourceParser {
    public static final String FILENAME = ".delta.lst";
    private final String regExp = "^(.+)([C|D])__DEL__(.+)$";
    protected final List<Delta> deltas = new ArrayList<Delta>();
    protected FileHandler srcFileHandler;

    public DeltaListResourceParser(FileHandler fileHandler) {
        this(fileHandler, null);
    }

    public DeltaListResourceParser(FileHandler fileHandler, FileHandler srcFileHandler) {
        super(fileHandler);
        this.srcFileHandler = srcFileHandler;
    }

    public Delta[] getDeltas() {
        return this.deltas.toArray(new Delta[0]);
    }

    @Override
    public void read(InputStreamReader isr) throws IOException {
        Assert.notNull((Object)isr);
        BufferedReader deltaReader = new BufferedReader(isr);
        ArrayList<Delta> list = new ArrayList<Delta>();
        String line = null;
        while ((line = deltaReader.readLine()) != null) {
            Delta parsedDelta = this.parseDelta(line);
            if (!this.validateDelta(parsedDelta, line)) continue;
            list.add(parsedDelta);
        }
        this.deltas.clear();
        this.deltas.addAll(list);
        this.read = true;
    }

    protected Delta parseDelta(String line) {
        Matcher matcher = this.getMatcher(line);
        if (matcher.matches()) {
            String realPath = matcher.group(1);
            String stateCharacter = matcher.group(2);
            DeltaState state = DeltaState.getValue(stateCharacter);
            String uri = matcher.group(3);
            return new Delta(realPath, state, uri);
        }
        return null;
    }

    protected boolean validateDelta(Delta delta, String line) throws IOException {
        if (delta == null) {
            throw new IOException("Failed to parse a delta list resource: " + line);
        }
        String realPath = delta.getRealPath();
        String uri = delta.getUri();
        if (StringUtil.isEmpty((CharSequence)realPath)) {
            throw new FileNotFoundException("Couldn't find a resource: " + line);
        }
        if (this.srcFileHandler != null && !this.srcFileHandler.is(realPath, FileHandler.Attribute.EXISTS)) {
            throw new FileNotFoundException("Couldn't find a resource: " + line);
        }
        if (StringUtil.isEmpty((CharSequence)uri)) {
            this.logger.warn("Skip to parse a broken delta: {}", (Object)line);
            return false;
        }
        return true;
    }

    @Override
    public String getResourceName() {
        return FILENAME;
    }

    @Override
    public void write(OutputStreamWriter osw) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getRegExp() {
        return "^(.+)([C|D])__DEL__(.+)$";
    }
}

