/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.builder;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.RemoteLogger;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.IBuildListener;
import org.tizen.common.builder.IBuildProcess;
import org.tizen.common.builder.IBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ProjectUtil;

public class BuildProcess
implements IBuildProcess {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<IBuilder> builders = new ArrayList<IBuilder>();
    private Collection<IBuildListener> listeners = new ArrayList<IBuildListener>();

    @Override
    public void addBuilders(IBuilder ... builders) {
        Assert.notNull((Object)builders);
        IBuilder[] iBuilderArray = builders;
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IBuilder builder = iBuilderArray[n2];
            if (builder == null) {
                this.logger.debug("builder is null");
            } else {
                this.builders.add(builder);
                this.logger.debug("{} builder was added.", (Object)builder.getClass().getName());
            }
            ++n2;
        }
    }

    @Override
    public void removeBuilders(IBuilder ... builders) {
        Assert.notNull((Object)builders);
        this.builders.removeAll(Arrays.asList(builders));
        IBuilder[] iBuilderArray = builders;
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IBuilder builder = iBuilderArray[n2];
            this.logger.debug("{} builder was removed.", (Object)builder.getClass().getName());
            ++n2;
        }
    }

    private IProject findProject(org.tizen.common.file.IResource resource) {
        if (resource == null) {
            return null;
        }
        String relativePath = resource.getPath();
        if (relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IResource[] allProjects;
            IResource[] iResourceArray = allProjects = root.members();
            int n = allProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                IResource possibleMatch;
                IResource res = iResourceArray[n2];
                if (res instanceof IProject && (possibleMatch = (project = (IProject)res).findMember((IPath)new Path(relativePath))) != null && possibleMatch.exists()) {
                    return project;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to find project", (Throwable)e);
        }
        return null;
    }

    @Override
    public void build(org.tizen.common.file.IResource ... resources) throws BuildException {
        org.tizen.common.file.IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            org.tizen.common.file.IResource resource = iResourceArray[n2];
            this.preBuild(resource);
            this.build(0, resource);
            ++n2;
        }
        IProject project = this.findProject(resources[0]);
        String profile = "";
        String appversion = "";
        String apptype = "";
        if (project != null) {
            ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
            TizenProjectDescription desc = tizenProject.getDescription();
            ProfileInfo profileInfo = desc.getProfileInfo();
            profile = profileInfo.getProfile();
            appversion = desc.getVersion();
            apptype = "Web";
            File file = project.getLocation().toFile();
            java.nio.file.Path prjFile = Paths.get(file.getAbsolutePath(), ".cproject");
            if (Files.exists(prjFile, new LinkOption[0])) {
                apptype = "Native";
            }
            RemoteLogger.logAccess((String)"TizenStudio", (String)"build_project_web", (String)profile, (String)apptype, (String)appversion);
        }
    }

    /*
     * Exception decompiling
     */
    private void build(int startIdxOfBuilder, org.tizen.common.file.IResource ... resources) throws BuildException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void firePostBuildListener(org.tizen.common.file.IResource resource) {
        for (IBuildListener listener : this.listeners) {
            listener.postBuild(resource);
        }
    }

    private void firePreBuildListener(org.tizen.common.file.IResource resource) {
        for (IBuildListener listener : this.listeners) {
            listener.preBuild(resource);
        }
    }

    private void fireResultListener(BuildResult result, org.tizen.common.file.IResource resource) {
        if (BuildResult.Status.SUCCESS.equals((Object)result.getResult())) {
            this.fireSuccess(result);
        } else if (BuildResult.Status.WARNING.equals((Object)result.getResult())) {
            this.fireWarning(result);
        } else if (BuildResult.Status.ERROR.equals((Object)result.getResult())) {
            this.fireError(result);
        }
    }

    private void fireWarning(BuildResult result) {
        for (IBuildListener listener : this.listeners) {
            listener.buildWarning(result);
        }
    }

    private void fireError(BuildResult result) {
        for (IBuildListener listener : this.listeners) {
            listener.buildError(result);
        }
    }

    private void fireSuccess(BuildResult result) {
        for (IBuildListener listener : this.listeners) {
            listener.buildSuccess(result);
        }
    }

    public void addListener(IBuildListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IBuildListener listener) {
        this.listeners.remove(listener);
    }

    public IBuilder getLastBuilder() {
        if (this.builders == null || this.builders.isEmpty()) {
            return null;
        }
        return this.builders.get(this.builders.size() - 1);
    }

    public IBuilder getBuilder(Class<? extends IBuilder> clazz) {
        if (this.builders == null || this.builders.isEmpty()) {
            return null;
        }
        for (IBuilder builder : this.builders) {
            if (!builder.getClass().equals(clazz)) continue;
            return builder;
        }
        return null;
    }

    @Override
    public void preBuild(org.tizen.common.file.IResource resource) {
    }
}

