/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.policy;

import java.util.HashMap;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.policy.AbstractPolicy;
import org.tizen.common.util.StringUtil;

public class PolicyRegistry {
    protected Policy noOp = new AbstractPolicy(""){

        @Override
        public <T> T adapt(Class<T> clazz) {
            return null;
        }
    };
    protected Node root = new Node();

    public PolicyRegistry(Policy ... policies) {
        if (policies == null) {
            return;
        }
        this.register(policies);
    }

    public void register(Policy ... policies) {
        Policy[] policyArray = policies;
        int n = policies.length;
        int n2 = 0;
        while (n2 < n) {
            Policy policy = policyArray[n2];
            String name = policy.getName();
            Node node = this.createNode(name);
            if (node.getPolicy() != null) {
                throw new IllegalArgumentException("Policy is duplicated");
            }
            node.setPolicy(policy);
            ++n2;
        }
    }

    public Node createNode(String path) {
        String[] fragments = StringUtil.split(path, ".");
        Node iter = this.root;
        int i = 0;
        int n = fragments.length;
        while (i < n) {
            Node child = iter.getChild(fragments[i]);
            if (child == null) {
                child = new Node();
                iter.addChild(fragments[i], child);
            }
            iter = child;
            ++i;
        }
        return iter;
    }

    public Policy getPolicy(String path) {
        if (StringUtil.isEmpty(path)) {
            return this.noOp;
        }
        String[] fragments = StringUtil.split(path, ".");
        Node iter = this.root;
        Policy policy = null;
        int i = 0;
        int n = fragments.length;
        while (i < n) {
            Node child;
            if (iter.getPolicy() != null) {
                policy = iter.getPolicy();
            }
            if ((child = iter.getChild(fragments[i])) == null) {
                return policy;
            }
            iter = child;
            ++i;
        }
        if (iter.getPolicy() == null) {
            return policy;
        }
        return iter.getPolicy();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()).substring(0, 4);
    }

    static class Node {
        protected Policy policy;
        protected final HashMap<String, Node> name2child = new HashMap();

        public Node() {
        }

        public Node(Policy policy) {
            this.policy = policy;
        }

        public Policy getPolicy() {
            return this.policy;
        }

        public void setPolicy(Policy policy) {
            this.policy = policy;
        }

        public Node getChild(String name) {
            return this.name2child.get(name);
        }

        public void addChild(String name, Node node) {
            this.name2child.put(name, node);
        }
    }
}

