/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerEdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GraphMLExporter<V, E> {
    private VertexNameProvider<V> vertexIDProvider;
    private VertexNameProvider<V> vertexLabelProvider;
    private EdgeNameProvider<E> edgeIDProvider;
    private EdgeNameProvider<E> edgeLabelProvider;

    public GraphMLExporter() {
        this(new IntegerNameProvider(), null, new IntegerEdgeNameProvider(), null);
    }

    public GraphMLExporter(VertexNameProvider<V> vertexNameProvider, VertexNameProvider<V> vertexNameProvider2, EdgeNameProvider<E> edgeNameProvider, EdgeNameProvider<E> edgeNameProvider2) {
        this.vertexIDProvider = vertexNameProvider;
        this.vertexLabelProvider = vertexNameProvider2;
        this.edgeIDProvider = edgeNameProvider;
        this.edgeLabelProvider = edgeNameProvider2;
    }

    public void export(Writer writer, Graph<V, E> graph) throws SAXException, TransformerConfigurationException {
        String string;
        PrintWriter printWriter = new PrintWriter(writer);
        StreamResult streamResult = new StreamResult(printWriter);
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
        Transformer transformer = transformerHandler.getTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformerHandler.setResult(streamResult);
        transformerHandler.startDocument();
        AttributesImpl attributesImpl = new AttributesImpl();
        transformerHandler.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        attributesImpl.addAttribute("", "", "xsi:schemaLocation", "CDATA", "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
        transformerHandler.startElement("http://graphml.graphdrawing.org/xmlns", "", "graphml", attributesImpl);
        transformerHandler.endPrefixMapping("xsi");
        if (this.vertexLabelProvider != null) {
            attributesImpl.clear();
            attributesImpl.addAttribute("", "", "id", "CDATA", "vertex_label");
            attributesImpl.addAttribute("", "", "for", "CDATA", "node");
            attributesImpl.addAttribute("", "", "attr.name", "CDATA", "Vertex Label");
            attributesImpl.addAttribute("", "", "attr.type", "CDATA", "string");
            transformerHandler.startElement("", "", "key", attributesImpl);
            transformerHandler.endElement("", "", "key");
        }
        if (this.edgeLabelProvider != null) {
            attributesImpl.clear();
            attributesImpl.addAttribute("", "", "id", "CDATA", "edge_label");
            attributesImpl.addAttribute("", "", "for", "CDATA", "edge");
            attributesImpl.addAttribute("", "", "attr.name", "CDATA", "Edge Label");
            attributesImpl.addAttribute("", "", "attr.type", "CDATA", "string");
            transformerHandler.startElement("", "", "key", attributesImpl);
            transformerHandler.endElement("", "", "key");
        }
        attributesImpl.clear();
        attributesImpl.addAttribute("", "", "edgedefault", "CDATA", graph instanceof DirectedGraph ? "directed" : "undirected");
        transformerHandler.startElement("", "", "graph", attributesImpl);
        for (Object object : graph.vertexSet()) {
            attributesImpl.clear();
            attributesImpl.addAttribute("", "", "id", "CDATA", this.vertexIDProvider.getVertexName(object));
            transformerHandler.startElement("", "", "node", attributesImpl);
            if (this.vertexLabelProvider != null) {
                attributesImpl.clear();
                attributesImpl.addAttribute("", "", "key", "CDATA", "vertex_label");
                transformerHandler.startElement("", "", "data", attributesImpl);
                string = this.vertexLabelProvider.getVertexName(object);
                transformerHandler.characters(string.toCharArray(), 0, string.length());
                transformerHandler.endElement("", "", "data");
            }
            transformerHandler.endElement("", "", "node");
        }
        for (Object object : graph.edgeSet()) {
            attributesImpl.clear();
            attributesImpl.addAttribute("", "", "id", "CDATA", this.edgeIDProvider.getEdgeName(object));
            attributesImpl.addAttribute("", "", "source", "CDATA", this.vertexIDProvider.getVertexName(graph.getEdgeSource(object)));
            attributesImpl.addAttribute("", "", "target", "CDATA", this.vertexIDProvider.getVertexName(graph.getEdgeTarget(object)));
            transformerHandler.startElement("", "", "edge", attributesImpl);
            if (this.edgeLabelProvider != null) {
                attributesImpl.clear();
                attributesImpl.addAttribute("", "", "key", "CDATA", "edge_label");
                transformerHandler.startElement("", "", "data", attributesImpl);
                string = this.edgeLabelProvider.getEdgeName(object);
                transformerHandler.characters(string.toCharArray(), 0, string.length());
                transformerHandler.endElement("", "", "data");
            }
            transformerHandler.endElement("", "", "edge");
        }
        transformerHandler.endElement("", "", "graph");
        transformerHandler.endElement("", "", "graphml");
        transformerHandler.endDocument();
        printWriter.flush();
    }
}

