/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.autocomplete;

import java.util.ArrayList;

public class TizenAutoComplete {
    public static String commands = "cli-config certificate security-profiles list create build-native build-web clean package install run uninstall version";
    public static String[][] subCommands = new String[][]{{"list", "web-project native-project"}, {"security-profiles", "list add remove"}, {"create", "web-project native-project"}};
    public static String[][] options = new String[][]{{"certificate", "-a --alias -p --password -c --country -s --state -ct --city -o --organization -u --unit -n --name -e --email -f --filename"}, {"cli-config", "-l --list -g --global -d --delete"}, {"build-native", "-a --arch -c --compiler -C --configuration"}, {"build-web", "-out --output -opt --optimize -euf --exclude-uifw -e --exclude"}, {"package", "-t --type -s --sign -S --strip"}, {"install", "-t --target -n --name"}, {"uninstall", "-t --target -p --pkgid"}, {"run", "-t --target -p --pkgid"}};
    public static String[][] optionsForSub = new String[][]{{"web-project", "-t --template -n --name -p --profile"}, {"native-project", "-t --template -n --name -p --profile"}, {"list", "-n --name"}, {"add", "-n --name -a --author -p --password -c --ca -r --rootca -d --dist -dp --dist-password -dc --dist-ca -dr --dist-rootca"}, {"remove", "-n --name"}, {"target", "--detail"}, {"app", "--target"}};
    public static String[] mainCommandsHaveDuplicatedOptions = new String[]{"create", "build-web", "package"};
    public static String[][] duplicatedOptions = new String[][]{{"-opt", "--optimize"}, {"-euf", "--exclude-uifw"}, {"-eufm", "--exclude-uifw-min"}, {"-e", "--exclude"}, {"-n", "--name"}, {"-ref", "--ref-project"}};

    public static void main(String[] args) {
        String[] inputs = args;
        String mainCmd = null;
        String subCmd = null;
        boolean needSubCmd = false;
        int count = inputs.length;
        if (count > 1 && (needSubCmd = TizenAutoComplete.hasSub(mainCmd = inputs[1])) && count > 2) {
            subCmd = inputs[2];
        }
        if (count > 2) {
            boolean needSuggestion = false;
            OptionSuggestion input = null;
            for (OptionSuggestion optionFortSuggestion : OptionSuggestion.values()) {
                if (!optionFortSuggestion.getOption().equals(inputs[count - 1]) || optionFortSuggestion.getMainCmd() != null && !optionFortSuggestion.getMainCmd().equals(mainCmd) || optionFortSuggestion.getSubCmd() != null && !optionFortSuggestion.getSubCmd().equals(subCmd)) continue;
                needSuggestion = true;
                input = optionFortSuggestion;
                break;
            }
            if (needSuggestion) {
                System.out.println(TizenAutoComplete.makeInputSuggestion(input));
                return;
            }
        }
        System.out.println(TizenAutoComplete.getNext(inputs, count, needSubCmd, mainCmd, subCmd));
    }

    private static boolean hasSub(String mainCmd) {
        for (int i = 0; i < subCommands.length; ++i) {
            if (!subCommands[i][0].equals(mainCmd)) continue;
            return true;
        }
        return false;
    }

    private static String getNext(String[] args, int count, boolean needSubCmd, String mainCmd, String subCmd) {
        String result = null;
        if (count == 1) {
            return TizenAutoComplete.getCommand();
        }
        String[][] commands = null;
        String criteria = mainCmd;
        if (needSubCmd) {
            if (count == 2) {
                commands = subCommands;
                return TizenAutoComplete.getCommands(commands, criteria);
            }
            commands = optionsForSub;
            criteria = subCmd;
        } else {
            commands = options;
        }
        result = TizenAutoComplete.getCommands(commands, criteria);
        return TizenAutoComplete.removeExistedOptions(result, args, mainCmd, needSubCmd);
    }

    private static String getCommand() {
        return commands;
    }

    private static String getCommands(String[][] commands, String criteria) {
        String result = null;
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i][0].equals(criteria)) continue;
            result = commands[i][1];
            break;
        }
        return result;
    }

    private static String removeExistedOptions(String candidateString, String[] existedCommands, String mainCmd, boolean hasSubCmd) {
        if (candidateString == null) {
            return "";
        }
        boolean needDuplicatedCheck = false;
        for (String mainCommand : mainCommandsHaveDuplicatedOptions) {
            if (!mainCommand.equals(mainCmd)) continue;
            needDuplicatedCheck = true;
            break;
        }
        ArrayList<String> duplicatedOptionList = new ArrayList<String>();
        String[] candidates = candidateString.split(" ");
        String candidate = null;
        block1: for (int i = 2; i < existedCommands.length; ++i) {
            for (int J = 0; J < candidates.length; ++J) {
                String duplicatedOption;
                candidate = candidates[J];
                if ('-' != existedCommands[i].charAt(0) || "".equals(candidate) || !existedCommands[i].equals(candidate)) continue;
                if (needDuplicatedCheck && (duplicatedOption = TizenAutoComplete.findDuplicatedOption(candidate)) != null) {
                    duplicatedOptionList.add(duplicatedOption);
                }
                candidates[J] = "";
                continue block1;
            }
        }
        boolean isFind = false;
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < candidates.length; ++i) {
            candidate = candidates[i];
            isFind = false;
            for (String duplicatedOption : duplicatedOptionList) {
                if (!"".equals(candidate) && !candidate.equals(duplicatedOption)) continue;
                isFind = true;
                break;
            }
            if (isFind) continue;
            strBuilder.append(" " + candidate);
        }
        return strBuilder.toString().trim();
    }

    private static String findDuplicatedOption(String option) {
        String duplicatedOption = null;
        int j = 0;
        if ('-' == option.charAt(1)) {
            j = 1;
        }
        for (int i = 0; i < duplicatedOptions.length; ++i) {
            if (!duplicatedOptions[i][j].equals(option)) continue;
            duplicatedOption = duplicatedOptions[i][1 ^ j];
            break;
        }
        return duplicatedOption;
    }

    private static String makeInputSuggestion(OptionSuggestion optionFortSuggestion) {
        String suggestion = "";
        switch (optionFortSuggestion) {
            case architecture: 
            case compiler: 
            case configuration: 
            case type: 
            case strip: {
                suggestion = optionFortSuggestion.getSuggestion();
            }
        }
        return suggestion;
    }

    public static enum OptionSuggestion {
        architecture(options[1][0], "--arch", "x86 x86_64 arm aarch64 riscv64"),
        compiler(options[1][0], "--compiler", "llvm gcc llvm-[version] gcc-[version]"),
        configuration(options[1][0], "--configuration", "Debug Release"),
        type(options[3][0], "--type", "wgt tpk"),
        strip(options[3][0], "--strip", "on off");

        private String mainCmd;
        private String subCmd;
        private String option;
        private String suggestion;

        private OptionSuggestion(String option) {
            this.option = option;
        }

        private OptionSuggestion(String mainCmd, String option, String suggestion) {
            this.mainCmd = mainCmd;
            this.option = option;
            this.suggestion = suggestion;
        }

        private OptionSuggestion(String mainCmd, String subCmd, String option, String suggestion) {
            this.mainCmd = mainCmd;
            this.subCmd = subCmd;
            this.option = option;
            this.suggestion = suggestion;
        }

        public String getMainCmd() {
            return this.mainCmd;
        }

        public String getSubCmd() {
            return this.subCmd;
        }

        public String getSuggestion() {
            return this.suggestion;
        }

        public String getOption() {
            return this.option;
        }
    }
}

