/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ThreadLocalMap;

public class UserLogger {
    protected static ThreadLocalMap<String, Long> id2perform = new ThreadLocalMap();
    private static final String FQCN = UserLogger.class.getName();
    private static final SimpleDateFormat logDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static Logger logger = LogManager.getLogger((String)"UserLogger");

    public static void page(String category) {
        UserLogger.page(category, null);
    }

    public static void page(String category, Throwable t) {
        new Page(category);
    }

    public static void event(String category) {
        UserLogger.event(category, "", null);
    }

    public static void event(String category, String action) {
        UserLogger.event(category, action, null);
    }

    public static void event(String category, String action, Throwable t) {
        new Event(category, action);
    }

    public static void start(String category) {
        UserLogger.start(category, "");
    }

    public static void start(String category, String variableName) {
        long start = System.currentTimeMillis();
        id2perform.put(String.valueOf(category) + variableName, start);
        new PerformanceInfo(category, start, 0L, variableName);
    }

    public static void end(String category) {
        UserLogger.end(category, "");
    }

    public static void end(String category, String variableName) {
        long end = System.currentTimeMillis();
        Long start = id2perform.remove(String.valueOf(category) + variableName);
        if (start == null) {
            return;
        }
        new PerformanceInfo(category, start, end, variableName);
    }

    public static class Event {
        private final String category;
        private final String action;
        private final String message;

        public Event(String category) {
            this(category, null);
        }

        public Event(String category, String action) {
            this.category = category;
            this.action = action;
            this.message = StringUtil.isEmpty(action) ? String.format("[Category: %s]", category) : String.format("[Category: %s\tAction: %s]", category, action);
        }

        public String getCategory() {
            return this.category;
        }

        public String getAction() {
            return this.action;
        }

        public String toString() {
            return this.message;
        }
    }

    public static class Page {
        private final String category;
        private final String message;

        public Page(String category) {
            this.category = category;
            this.message = String.format("[Category: %s]", this.category);
        }

        public String getCategory() {
            return this.category;
        }

        public String toString() {
            return this.message;
        }
    }

    public static class PerformanceInfo {
        private final String category;
        private final long start;
        private final long end;
        private final String variableName;
        private final String message;

        public PerformanceInfo(String category, long start, long end) {
            this(category, start, end, null);
        }

        public PerformanceInfo(String category, long start, long end, String variableName) {
            this.category = category;
            this.start = start;
            this.end = end;
            this.variableName = variableName;
            this.message = end == 0L ? (StringUtil.isEmpty(variableName) ? String.format("[Category: %s] at %s", category, logDateFormat.format(new Date(start))) : String.format("[Category: %s\tVariable: %s] at %s", category, variableName, logDateFormat.format(new Date(start)))) : (StringUtil.isEmpty(variableName) ? String.format("[Category: %s] at %s \t [%s(ms)]", category, logDateFormat.format(new Date(end)), this.getPerformanceString()) : String.format("[Category: %s\tVariable: %s] at %s \t [%s(ms)]", category, variableName, logDateFormat.format(new Date(end)), this.getPerformanceString()));
        }

        public String toString() {
            return this.message;
        }

        public String getCategory() {
            return this.category;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public String getPerformanceString() {
            return String.format("%d", this.end - this.start);
        }
    }
}

