/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.clean.CleanCSProjectCommand;
import org.tizen.ncli.subcommands.clean.CleanNativeProjectCommand;
import org.tizen.ncli.subcommands.clean.CleanWebProjectCommand;

@TizenSubCommand(name="clean", usage="Clean the build output directory.")
public class CleanCLI
extends AbstractCLI {
    @Argument(index=0, required=false, metaVar="<command>")
    String commandName;
    @Option(name="--script-file", aliases={"-f"}, metaVar="ABS Script file path", usage="Specifies the path of ABS script file.", hidden=true)
    private String scriptPath;

    @Override
    public int execute() {
        int clean_count = 0;
        this.log.trace("Execute Clean...");
        CleanNativeProjectCommand nativecommand = new CleanNativeProjectCommand();
        nativecommand.setWorkingDir(this.getRealWorkingPath());
        CleanNativeProjectCommand nativedata = (CleanNativeProjectCommand)nativecommand.runCommand();
        clean_count += nativedata.clean_count;
        CleanWebProjectCommand webcommand = new CleanWebProjectCommand();
        webcommand.setWorkingDir(this.getRealWorkingPath());
        CleanWebProjectCommand webdata = (CleanWebProjectCommand)webcommand.runCommand();
        clean_count += webdata.clean_count;
        CleanCSProjectCommand cscommand = new CleanCSProjectCommand();
        cscommand.setWorkingDir(this.getRealWorkingPath());
        CleanCSProjectCommand csdata = (CleanCSProjectCommand)cscommand.runCommand();
        if ((clean_count += csdata.clean_count) == 0) {
            this.progressLog.info("There is no directory to clean.");
        }
        return 0;
    }
}

