/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildnative;

import java.util.List;
import org.tizen.ncli.subcommands.build.BuildMethodData;

public class BuildNativeMethodData {
    protected String appName;
    protected String appId;
    protected String appType;
    protected String projectPath;
    protected String projType;
    protected String outputPath;
    protected String appExecName;
    protected String profileName;
    protected String profileVersion;
    protected String architecture;
    protected String rootstrapName;
    protected String buildConfig;
    protected String toolchain;
    protected List<String> predefineOptions;
    protected int jobs;
    protected String buildScriptPath;
    protected String extraOpts;

    public BuildNativeMethodData() {
    }

    public BuildNativeMethodData(String profileName, String profileVersion, String architecture, String rootstrapName, String buildConfig, String toolchain, List<String> predefineOptions, int jobs, String buildScriptPath, String opts) {
        this.profileName = profileName;
        this.profileVersion = profileVersion;
        this.architecture = architecture;
        this.rootstrapName = rootstrapName;
        this.toolchain = toolchain;
        this.predefineOptions = predefineOptions;
        this.jobs = jobs;
        this.buildScriptPath = buildScriptPath;
        this.extraOpts = opts;
        this.buildConfig = buildConfig;
    }

    public BuildNativeMethodData(BuildMethodData baseMethod) {
        if (baseMethod != null) {
            this.profileName = baseMethod.getProfileName();
            this.profileVersion = baseMethod.getProfileVersion();
            this.architecture = baseMethod.getArchitecture();
            this.rootstrapName = baseMethod.getRootstrapName();
            this.toolchain = baseMethod.getToolchain();
            this.predefineOptions = baseMethod.getPredefineOptions();
            this.extraOpts = baseMethod.getExtraOpts();
            this.buildConfig = baseMethod.getBuildConfig();
            this.jobs = 0;
            this.buildScriptPath = null;
        }
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getRootstrapName() {
        return this.rootstrapName;
    }

    public void setRootstrapName(String rootstrapName) {
        this.rootstrapName = rootstrapName;
    }

    public String getBuildConfig() {
        return this.buildConfig;
    }

    public void setBuildConfig(String buildConfig) {
        this.buildConfig = buildConfig;
    }

    public String getToolchain() {
        return this.toolchain;
    }

    public void setToolchain(String toolchain) {
        this.toolchain = toolchain;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileVersion() {
        return this.profileVersion;
    }

    public void setProfileVersion(String profileVersion) {
        this.profileVersion = profileVersion;
    }

    public void setProfileFullName(String profileFullName) {
        if (profileFullName == null || profileFullName.isEmpty()) {
            this.profileName = null;
            this.profileVersion = null;
            return;
        }
        String[] s = profileFullName.split("-");
        if (s.length > 0) {
            if (s.length >= 1) {
                this.profileName = s[0];
            }
            if (s.length >= 2) {
                this.profileVersion = s[1];
            }
        }
    }

    public List<String> getPredefineOptions() {
        return this.predefineOptions;
    }

    public void setPredefineOptions(List<String> predefineOptions) {
        this.predefineOptions = predefineOptions;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public String getAppExecName() {
        return this.appExecName;
    }

    public void setAppExecName(String appExecName) {
        this.appExecName = appExecName;
    }

    public String getProjectType() {
        return this.projType;
    }

    public void setProjectType(String projType) {
        this.projType = projType;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public int getJobs() {
        return this.jobs;
    }

    public void setJobs(int jobs) {
        this.jobs = jobs;
    }

    public String getBuildScriptPath() {
        return this.buildScriptPath;
    }

    public String getExtraOptions() {
        return this.extraOpts;
    }

    public void setExtraOptions(String opts) {
        this.extraOpts = opts;
    }

    public void setBuildScriptPath(String buildScriptPath) {
        this.buildScriptPath = buildScriptPath;
    }
}

