/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.migrate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MigrationData {
    private Map<String, String> dependencies = null;
    private List<String> targetFrameworks = null;
    private List<String> packageTargetFallbacks = null;

    public void addPackage(String pkgname, String pkgversion) {
        if (this.dependencies == null) {
            this.dependencies = new LinkedHashMap<String, String>();
        }
        this.dependencies.put(pkgname, pkgversion);
    }

    public Map<String, String> getPackages() {
        if (this.dependencies != null) {
            return Collections.unmodifiableMap(this.dependencies);
        }
        return null;
    }

    public void addTargerFramework(String framework) {
        if (this.targetFrameworks == null) {
            this.targetFrameworks = new ArrayList<String>();
        }
        if (!this.targetFrameworks.contains(framework)) {
            this.targetFrameworks.add(framework);
        }
    }

    public void addPackageTargetFallback(String fallback) {
        if (this.packageTargetFallbacks == null) {
            this.packageTargetFallbacks = new ArrayList<String>();
        }
        if (!this.packageTargetFallbacks.contains(fallback)) {
            this.packageTargetFallbacks.add(fallback);
        }
    }

    public String getTargetFrameworkString() {
        return MigrationData.getConcatString(this.targetFrameworks);
    }

    public String getPackageTargetFallbackString() {
        return MigrationData.getConcatString(this.packageTargetFallbacks);
    }

    private static String getConcatString(List<String> list) {
        if (list == null) {
            return null;
        }
        String target = null;
        for (String key : list) {
            if (target != null) {
                target = target + ";" + key;
                continue;
            }
            target = key;
        }
        return target;
    }

    public String getPackageVersion(String pkgname) {
        if (this.dependencies == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.dependencies.entrySet()) {
            if (entry.getKey().compareToIgnoreCase(pkgname) != 0) continue;
            return entry.getValue();
        }
        return null;
    }
}

