/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.subcommands.build.buildnative.BuildInfo;
import org.tizen.ncli.subcommands.packages.PackageData;
import org.tizen.ssilib.SSIMacro;
import org.tizen.tpklib.lib.PathUtil;
import org.w3c.dom.Document;

public class PackageProject {
    public static BuildInfo getBuildInfo(String path, Logger log) {
        BuildInfo buildInfo = new BuildInfo();
        boolean r = buildInfo.readBuildInfo(PathUtil.addPath((String[])new String[]{path, "build.info"}), log);
        return r ? buildInfo : null;
    }

    public static PackageData getWebSSIData(String workingDir, String projectPath, Logger log) {
        PackageData data = new PackageData();
        try {
            String[] profiles;
            data.setWorkingDir(workingDir);
            if (projectPath != null) {
                if (!new File(projectPath).exists()) {
                    projectPath = null;
                }
            } else {
                File parentFile = new File(workingDir).getParentFile();
                if (parentFile != null && parentFile.exists()) {
                    projectPath = parentFile.getCanonicalPath();
                } else {
                    log.error("Specify proper build configuration path");
                    return null;
                }
            }
            log.debug("Base project directory: {}", (Object)projectPath);
            data.setProjectPath(projectPath);
            String tprojectFilePath = projectPath + File.separatorChar + ".tproject";
            String manifestPath = projectPath + File.separatorChar + "config.xml";
            if (new File(workingDir, "config.xml").exists()) {
                manifestPath = workingDir + File.separatorChar + "config.xml";
            }
            data.setManifestFilePath(manifestPath);
            Document tprojectDoc = null;
            try {
                tprojectDoc = XMLUtil.readXML((File)new File(tprojectFilePath));
            }
            catch (Exception e) {
                log.error("Error occurred during getting project file", (Object)e.getMessage());
                return null;
            }
            String fullProfile = XMLUtil.getDOMValueNS((Document)tprojectDoc, (String)"/:tproject/:platforms/:platform/:name/text()", (String)"http://www.tizen.org/tproject");
            if (fullProfile != null && (profiles = fullProfile.split("-")).length >= 2) {
                data.setProfileVersion(profiles[1]);
            }
            return data;
        }
        catch (IOException e) {
            log.error("Error occurred during setting working directory", (Object)e.getMessage());
            return null;
        }
    }

    public static class MacroRunner
    implements SSIMacro.Runner {
        private PackageData data;

        public MacroRunner(PackageData data) {
            this.data = data;
        }

        public String getVariable(String var) {
            String value = null;
            if (var != null) {
                if (var.equals("app.id")) {
                    value = this.data.getAppId();
                } else if (var.equals("project.path")) {
                    value = this.data.getProjectPath();
                } else if (var.equals("project.output.path")) {
                    value = this.data.getWorkingDir();
                } else if (var.equals("build.config")) {
                    value = this.data.getSbiConfig();
                }
            }
            return value;
        }
    }
}

