/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.util;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.util.CommandUtil;

public class DirectoryUtil {
    public static final String REPOSITORY = "cli";
    protected static Logger log = LoggerFactory.getLogger(CommandUtil.class);

    public static boolean deleteDirectory(File path, boolean deleteDir) {
        if (!path.exists()) {
            return false;
        }
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    DirectoryUtil.deleteDirectory(file, true);
                    continue;
                }
                try {
                    file.delete();
                }
                catch (Exception e) {
                    log.error("Unable to delete file");
                }
            }
        }
        if (deleteDir) {
            return path.delete();
        }
        return true;
    }

    public static boolean deleteDirectory(File path) {
        return DirectoryUtil.deleteDirectory(path, true);
    }

    public static boolean createMissingDirectory(String path) {
        boolean isCreated;
        File outputFile = new File(path);
        if (!outputFile.exists() && !(isCreated = outputFile.mkdirs())) {
            log.error("Unable to create output directory: %s", (Object)outputFile.getPath());
            return false;
        }
        return true;
    }

    public static File createTempDirectory() throws IOException {
        String sysTempDir = System.getProperty("java.io.tmpdir");
        File tempPath = new File(sysTempDir, "tizen_temp_" + Long.toString(System.nanoTime()));
        if (!tempPath.mkdirs()) {
            throw new IOException("Could not create temp directory: " + tempPath.getAbsolutePath());
        }
        return tempPath;
    }

    public static File getAbsolutePath(String filePath) {
        File currentWorkspacePath = null;
        File workingDir = new File(filePath);
        if (currentWorkspacePath == null) {
            currentWorkspacePath = new File(".").getAbsoluteFile();
        }
        try {
            System.setProperty("user.dir", currentWorkspacePath.getCanonicalPath());
        }
        catch (IOException e1) {
            return null;
        }
        if (OSChecker.isWindows() && currentWorkspacePath != null && currentWorkspacePath.getPath().endsWith("\"")) {
            currentWorkspacePath = new File(currentWorkspacePath.toString().replace("\"", "\\"));
        }
        File retFile = null;
        if (null != workingDir.getPath() && workingDir.getPath().startsWith(".")) {
            retFile = new File(currentWorkspacePath, workingDir.getPath());
        } else if (!OSChecker.isWindows() && null != workingDir.getPath() && workingDir.getPath().startsWith("~")) {
            String tempPath = workingDir.getPath().replaceFirst("~", System.getProperty("user.home"));
            retFile = new File(tempPath);
        } else {
            retFile = workingDir;
        }
        try {
            retFile = retFile.getCanonicalFile();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new UnexpectedException(2, "Specify location of the file.");
        }
        return retFile;
    }
}

