/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IScrollLockStateProvider;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;

public class IOConsoleViewer
extends TextConsoleViewer {
    private boolean fAutoScroll = true;
    private boolean fWordWrap = false;
    private IDocumentListener fDocumentListener;

    public IOConsoleViewer(Composite parent, TextConsole console) {
        super(parent, console);
    }

    public IOConsoleViewer(Composite parent, TextConsole console, IScrollLockStateProvider scrollLockStateProvider) {
        super(parent, console, scrollLockStateProvider);
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public boolean isWordWrap() {
        return this.fWordWrap;
    }

    public void setWordWrap(boolean wordwrap) {
        this.fWordWrap = wordwrap;
        this.getTextWidget().setWordWrap(wordwrap);
    }

    protected void handleVerifyEvent(VerifyEvent e) {
        block11: {
            IDocument doc = this.getDocument();
            String[] legalLineDelimiters = doc.getLegalLineDelimiters();
            String eventString = e.text;
            try {
                int length;
                IConsoleDocumentPartitioner partitioner = (IConsoleDocumentPartitioner)doc.getDocumentPartitioner();
                if (!partitioner.isReadOnly(e.start)) {
                    boolean isCarriageReturn = false;
                    int i = 0;
                    while (i < legalLineDelimiters.length) {
                        if (e.text.equals(legalLineDelimiters[i])) {
                            isCarriageReturn = true;
                            break;
                        }
                        ++i;
                    }
                    if (!isCarriageReturn) {
                        super.handleVerifyEvent(e);
                        return;
                    }
                }
                if (e.start == (length = doc.getLength())) {
                    super.handleVerifyEvent(e);
                    break block11;
                }
                try {
                    doc.replace(length, 0, eventString);
                    this.updateWidgetCaretLocation(length);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                e.doit = false;
            }
            finally {
                StyledText text = (StyledText)e.widget;
                text.setCaretOffset(text.getCharCount());
            }
        }
    }

    private void updateWidgetCaretLocation(int documentCaret) {
        IRegion region;
        int widgetCaret = this.modelOffset2WidgetOffset(documentCaret);
        if (widgetCaret == -1 && (region = this.getModelCoverage()) != null) {
            if (documentCaret <= region.getOffset()) {
                widgetCaret = 0;
            } else if (documentCaret >= region.getOffset() + region.getLength()) {
                widgetCaret = this.getVisibleRegion().getLength();
            }
        }
        if (widgetCaret != -1) {
            this.getTextWidget().setCaretOffset(widgetCaret);
            this.getTextWidget().showSelection();
        }
    }

    public void setReadOnly() {
        ConsolePlugin.getStandardDisplay().asyncExec(() -> {
            StyledText text = this.getTextWidget();
            if (text != null && !text.isDisposed()) {
                text.setEditable(false);
            }
        });
    }

    public boolean isReadOnly() {
        return !this.getTextWidget().getEditable();
    }

    public void setDocument(IDocument document) {
        IDocument oldDocument = this.getDocument();
        super.setDocument(document);
        if (oldDocument != null) {
            oldDocument.removeDocumentListener(this.getDocumentListener());
        }
        if (document != null) {
            document.addDocumentListener(this.getDocumentListener());
        }
    }

    private IDocumentListener getDocumentListener() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (IOConsoleViewer.this.fAutoScroll) {
                        IOConsoleViewer.this.revealEndOfDocument();
                    }
                }
            };
        }
        return this.fDocumentListener;
    }
}

