/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildnative;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.BuildMethodData;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeCommand;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeData;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeOption;
import org.tizen.sbilib.for_cli.SBIProcess;
import org.tizen.sbilib.for_cli.sbiplugin.SBIPluginManager;

public class BuildNativeCLICommand
extends AbstractSubCommand<BuildNativeData> {
    private Configuration config = new Configuration();
    private BuildNativeData data = new BuildNativeData();
    private String rootstrapName;
    List<String> frameworkList;

    private void convertOptionForSbi(BuildNativeData data) {
        BuildNativeOption.BuildNativeRequiredOption[] options = BuildNativeOption.BuildNativeRequiredOption.values();
        for (int i = 0; i < options.length; ++i) {
            BuildNativeOption.BuildNativeRequiredOption option = options[i];
            if (option.name().equalsIgnoreCase("architecture")) {
                if (option.getValue().equals("arm")) {
                    data.setSbiArchitecture("armel");
                } else if (option.getValue().equals("x86")) {
                    data.setSbiArchitecture("i386");
                } else if (option.getValue().equals("x86_64")) {
                    data.setSbiArchitecture("x86_64");
                } else if (option.getValue().equals("aarch64")) {
                    data.setSbiArchitecture("aarch64");
                } else {
                    this.log.debug("invalid architecture option : " + option.name());
                }
                this.log.debug("architecture : " + data.getSbiArchitecture());
                continue;
            }
            if (option.name().equalsIgnoreCase("compiler")) {
                if (option.getValue().equals("gcc")) {
                    data.setSbiToolchain(option.getValue());
                } else if (option.getValue().equals("llvm")) {
                    data.setSbiToolchain(option.getValue());
                } else {
                    data.setSbiToolchain(option.getValue().toUpperCase());
                }
                this.log.debug("compiler : " + data.getSbiToolchain());
                continue;
            }
            if (option.name().equalsIgnoreCase("configuration")) {
                data.setSbiConfig(option.getValue());
                this.log.debug("configuration : " + data.getSbiConfig());
                continue;
            }
            this.log.debug("invalid option : " + option.name());
        }
    }

    private boolean validateRequiredOptions() {
        boolean result = true;
        BuildNativeOption.BuildNativeRequiredOption[] options = BuildNativeOption.BuildNativeRequiredOption.values();
        for (int i = 0; i < options.length; ++i) {
            String[] candidates;
            BuildNativeOption.BuildNativeRequiredOption option;
            boolean isValid;
            block5: {
                String value;
                block3: {
                    block4: {
                        isValid = false;
                        option = options[i];
                        value = option.getValue();
                        candidates = option.getCandidates();
                        if (!option.getName().equals("compiler")) break block3;
                        if (!value.equals("gcc") && !value.startsWith("gcc-")) break block4;
                        isValid = true;
                        break block5;
                    }
                    if (!value.equals("llvm") && !value.startsWith("llvm-")) break block5;
                    isValid = true;
                    break block5;
                }
                for (int j = 0; j < candidates.length; ++j) {
                    if (!value.equals(candidates[j])) continue;
                    isValid = true;
                    break;
                }
            }
            if (isValid) continue;
            StringBuilder strBuilder = new StringBuilder();
            for (int j = 0; j < candidates.length; ++j) {
                strBuilder.append(" \"" + candidates[j] + "\"");
            }
            result = false;
            this.progressLog.info(NLS.bind((String)TizenCLIMessages.INVALID_ARG, (Object)((Object)option), (Object)strBuilder.toString().trim()));
            break;
        }
        return result;
    }

    @Override
    protected BuildNativeData call() {
        if (!this.data.hasRequiredOptions) {
            this.progressLog.info(TizenCLIMessages.CANNOT_GET_OPTIONS);
            throw new UnexpectedException(2, TizenCLIMessages.CANNOT_GET_OPTIONS);
        }
        if (!this.validateRequiredOptions()) {
            this.log.trace(TizenCLIMessages.INVALID_ARGS);
            throw new UnexpectedException(2, TizenCLIMessages.INVALID_ARGS);
        }
        String sdkPath = InstallPathConfig.getSDKPath();
        String projPath = this.workingDir.toString();
        String sbiHomePath = sdkPath + File.separator + BuildNativeOption.SBI_HOME_PATH;
        if (!BuildNativeCommand.validateProject(projPath)) {
            this.log.trace(TizenCLIMessages.INVALID_ARGS);
            throw new UnexpectedException(2, TizenCLIMessages.INVALID_ARGS);
        }
        this.data.setWorkingDir(projPath);
        this.convertOptionForSbi(this.data);
        SBIPluginManager sbiPlugins = new SBIPluginManager(sbiHomePath);
        SBIProcess sbi2 = BuildNativeCommand.genSBIProcess(sbiPlugins, this.data.buildScriptPath, projPath);
        if (sbi2 == null) {
            sbi2 = BuildNativeCommand.genDefSBIProcess(sbiPlugins, sdkPath);
        }
        if (sbi2 == null) {
            this.log.error("genSBIProcess failed.");
            throw new UnexpectedException(2, TizenCLIMessages.INVALID_ARGS);
        }
        sbi2.setFrameworkList(this.frameworkList);
        BuildMethodData method = new BuildMethodData();
        method.setBuildConfig(this.data.getSbiConfig());
        method.setArchitecture(this.data.getSbiArchitecture());
        method.setProfileName(this.data.getSbiProfile());
        method.setProfileVersion(this.data.getSbiProfileVersion());
        method.setRootstrapName(this.rootstrapName);
        method.setToolchain(this.data.getSbiToolchain());
        method.setPredefineOptions(this.data.getPredefineOptions());
        BuildNativeCommand.setExtraOption(this.data.getExtraOption());
        this.data = BuildNativeCommand.build(sbi2, method, projPath, true, this.data.getOutputPath(), this.data.getBuildScriptPath(), this.data.getMultiTaskingJobs(), this.workingDir.getParent(), this.progressLog);
        if (this.data != null) {
            BuildNativeCommand.writeBuildInfo(projPath, this.data.getOutputPath(), this.data);
        }
        return this.data;
    }

    public void setRootstrap(String rootstrap) {
        this.rootstrapName = rootstrap;
    }

    public void setRequiredOptions(String[] input) {
        BuildNativeOption.BuildNativeRequiredOption[] requiredOptions = BuildNativeOption.BuildNativeRequiredOption.values();
        for (int i = 0; i < requiredOptions.length; ++i) {
            BuildNativeOption.BuildNativeRequiredOption requiredOption = requiredOptions[i];
            String str = input[i];
            if (str == null) {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.BN_NO_BUILD_INPUT, (Object)requiredOption.getName()));
                str = this.config.getValue(requiredOption.getKey());
            }
            if (str == null) {
                this.progressLog.info(requiredOption.getErrorMessage());
                this.data.hasRequiredOptions = false;
                continue;
            }
            requiredOption.setValue(str);
        }
    }

    public void setPredefineOption(String[] predefineOption) {
        this.data.setPredefineOptions(predefineOption);
    }

    public void setJobsForParallelBuild(int jobs) {
        this.data.setMultiTaskingJobs(jobs);
    }

    public void setOutputPath(String output) {
        this.data.setOutputPath(output);
    }

    public void setBuildScriptPath(String buildscriptPath) {
        this.data.setBuildScriptPath(buildscriptPath);
    }

    public void setExtraOption(String extraOption) {
        this.data.setExtraOption(extraOption);
    }

    public void setFrameworkList(String framework) {
        if (framework == null) {
            return;
        }
        this.frameworkList = Arrays.asList(framework.split(","));
    }
}

