#!/bin/bash
CURRENT_WORKSPACE_PATH=`pwd`
HOME_PATH=`test -h "$0" && dirname $(readlink "$0") || dirname "$0"`

#Run CLI in tizen script directory for dealing with a change of sdk path
# @Added by Hyunjin Lee
# 2015.07.02
cd "$HOME_PATH"

LIB_PATH=../lib-ncli

CONFIG_PATH=../conf-ncli
LOG_CONF_FILE=log4j-progress.xml
LOG_OPT="-Dlog4j.configuration=${LOG_CONF_FILE}"

LIBS=`find $LIB_PATH -maxdepth 1`
LIB=""
for LIB in $LIBS; do
	CLASS_PATH=$CLASS_PATH:$LIB
done

#SDBLIB_PATH=../../sdblib
#SDBLIBS=`find $SDBLIB_PATH -maxdepth 1`
#SDBLIB=""
#for SDBLIB in $SDBLIBS; do
#	CLASS_PATH=$CLASS_PATH:$SDBLIB
#done

CLASS_PATH=$CONFIG_PATH:$CLASS_PATH

escapeSpace() {
	echo $(printf "'%s'" "$ARG" )
}

for ARG in "$@" ; do
	ARGS="$ARGS $(escapeSpace $ARG)"
done

#Check if sub-command is entered - first argument MUST be sub-command!
#If there is no sub-command , do not set --current-workspace-path option.
# @Added by Harry Hyeongseok Heo
# 2013.11.14
#Cover with a single quotation mark, because CURRENT_WORKSPACE_PATH may have white spaces
# @Added by Hyunjin Lee
# 2015.07.02
if [ ${#ARGS} -gt 0 ]
then ARGS="$ARGS --current-workspace-path '$CURRENT_WORKSPACE_PATH'"
else ARGS=""
fi

### find location of script file ###
pushd . > /dev/null
SCRIPT_PATH="${BASH_SOURCE[0]}";
    while([ -h "${SCRIPT_PATH}" ]) do
        cd "`dirname "${SCRIPT_PATH}"`"
        SCRIPT_PATH="$(readlink "`basename "${SCRIPT_PATH}"`")";
    done
cd "`dirname "${SCRIPT_PATH}"`" > /dev/null
SCRIPT_PATH="`pwd`";
popd > /dev/null
#echo "script=[${SCRIPT_PATH}]"
###

MAIN=org.tizen.ncli.ide.shell.Main

#echo $CLASS_PATH
EXEC="java -XX:+IgnoreUnrecognizedVMOptions --module-path=\"$SCRIPT_PATH/../../../library/jaxb-ri/\" --add-modules=ALL-MODULE-PATH --add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=java.xml/com.sun.org.apache.xerces.internal.impl.dv.util=ALL-UNNAMED $LOG_OPT -Djava.library.path=$LIB_PATH/spawner -cp $CLASS_PATH $MAIN $ARGS"
eval "$EXEC"

# save exit code
EXITCODE=$?

#Go back to previous directory
# @Added by Hyunjin Lee
# 2015.07.02
cd "$CURRENT_WORKSPACE_PATH"
exit $EXITCODE
