/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.ncli.core.CommandInfo;
import org.tizen.ncli.core.CommandLineParser;
import org.tizen.ncli.core.SubCommandData;
import org.tizen.ncli.exceptions.UnexpectedException;

public abstract class AbstractCLI {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Logger progressLog = LoggerFactory.getLogger((String)"NCLI_PROGRESS");
    @Option(name="--", metaVar="<working directory>", usage="Specify where the base directory is for the command")
    public File workingDir;
    @Option(hidden=true, name="--current-workspace-path", metaVar="current workspace path", usage="Specify where is the root path for the command as a default")
    public File currentWorkspacePath;
    @Option(name="-h", aliases={"--help"}, help=true, usage="Show the detailed description of a given command.")
    protected boolean help;
    protected PrintWriter output = new PrintWriter(System.out);
    private StopWatch stopWatch = new StopWatch();
    protected boolean isLoggingStartFinish = true;

    public abstract int execute();

    public int execute(CommandLineParser cmdParser) throws Exception {
        if (this.currentWorkspacePath == null) {
            this.currentWorkspacePath = new File(".").getAbsoluteFile();
        }
        System.setProperty("user.dir", this.currentWorkspacePath.getCanonicalPath());
        this.printStarted();
        this.stopWatch.start();
        int result = -1;
        try {
            result = this.execute();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.stopWatch.stop();
            this.printFinished();
        }
        return result;
    }

    private void printStarted() {
        if (!this.isLoggingStartFinish) {
            return;
        }
    }

    private void printFinished() {
        if (!this.isLoggingStartFinish) {
            return;
        }
    }

    private String getCurrCmdName() {
        CommandInfo currentCmdInfo = SubCommandData.get("CURRENT_CMD");
        String commandName = "Tizen Command";
        if (null != currentCmdInfo && null != currentCmdInfo.getSubCmdImpl() && null != currentCmdInfo.getCommandName()) {
            commandName = currentCmdInfo.getCommandName();
        }
        return commandName;
    }

    protected void printElapsedTime() {
        long elapsedTime = this.stopWatch.getTime();
        String duration = DurationFormatUtils.formatDuration((long)elapsedTime, (String)"HH:mm:ss.S");
        this.progressLog.info("Total time: {}", (Object)duration);
    }

    public boolean needPrintTime() {
        return false;
    }

    protected File getRealWorkingPath() {
        if (OSChecker.isWindows() && this.currentWorkspacePath != null && this.currentWorkspacePath.getPath().endsWith("\"")) {
            this.currentWorkspacePath = new File(this.currentWorkspacePath.toString().replace("\"", "\\"));
        }
        if (null == this.workingDir) {
            if (this.currentWorkspacePath == null) {
                String curDir = System.getProperty("user.dir");
                return new File(curDir);
            }
            return this.currentWorkspacePath;
        }
        File retFile = null;
        if (null != this.workingDir.getPath() && this.workingDir.getPath().startsWith(".")) {
            retFile = new File(this.currentWorkspacePath, this.workingDir.getPath());
        } else if (!OSChecker.isWindows() && null != this.workingDir.getPath() && this.workingDir.getPath().startsWith("~")) {
            String tempPath = this.workingDir.getPath().replaceFirst("~", System.getProperty("user.home"));
            retFile = new File(tempPath);
        } else {
            retFile = this.workingDir;
        }
        try {
            retFile = retFile.getCanonicalFile();
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            throw new UnexpectedException(2, "Specify location of the working directory.");
        }
        return retFile;
    }

    protected void printUsage() {
        CommandInfo currentCmdInfo = SubCommandData.get("CURRENT_CMD");
        if (null != currentCmdInfo) {
            currentCmdInfo.getCmdLineParser().printUsage(this.output, null);
        }
    }
}

