/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createweb;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.common.AppIdGenerator;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.util.FileUtil;
import org.tizen.ncli.subcommands.createweb.WebProjectInfo;
import org.tizen.web.model.TizenAppTemplate;
import org.tizen.web.model.TizenModelFactory;

public class CreateWebProjectCommandData {
    private static final String WEB_PROJECT_PATH = "samples" + File.separator + "Template" + File.separator + "Web";
    private static final String TIZEN_WEB_APP_TEMPLATE_FILE = "tizen-app-template.xml";
    private static final String TIZEN_PROJECT_DESCRIPTION_FILE = ".tproject";
    private static final String TIZEN_PROJECT_FOLDER = "project";
    private static final String IGNORE_PROJECT = "Tizen Web UI Builder";
    public static final String DEFAULT_TEMPLATE_NAME = "BasicBasicApplication";
    public static final String DEFAULT_PROJECT_NAME = "basicApp";
    public static final String DEFAULT_PROFILE_NAME = "mobile-2.3";
    public static final String DEFAULT_MOBILE_BASE_PROFILE_NAME = "mobile";
    public static final String DEFAULT_WEARABLE_BASE_PROFILE_NAME = "wearable";
    public static final String DEFAULT_MOBILE_BASE_PROFILE_VER = "2.3";
    public static final String DEFAULT_WEARABLE_BASE_PROFILE_VER = "2.3";
    private String templateName = "BasicBasicApplication";
    private String projectName = "basicApp";
    private String profileName = "mobile-2.3";
    private String baseProfileName = "mobile";
    private String baseProfileVer = "2.3";
    private String outputName = "";
    private static TizenAppTemplate tizenAppTemplate;
    private String APPID = AppIdGenerator.getInstance().create();
    public static List<String> fileNameArray;
    public static Map<WebProjectInfo, String> webProjects;

    CreateWebProjectCommandData() {
        CreateWebProjectCommandData.getTemplateListFromAllProfile();
    }

    public Map<WebProjectInfo, String> getTemplateList() {
        return webProjects;
    }

    public static Map<WebProjectInfo, String> getTemplateListFromAllProfile() {
        webProjects.clear();
        List pis = InstallPathConfig.getProfileInfos();
        for (ProfileInfo pi : pis) {
            CreateWebProjectCommandData.getTemplateList(pi);
        }
        return webProjects;
    }

    public static Map<WebProjectInfo, String> getTemplateList(ProfileInfo profile) {
        for (String version : profile.getVersions()) {
            String platformPath = profile.getPlatformPath(version);
            String platformName = profile.getPlatformName(version);
            CreateWebProjectCommandData.appendWebProject(platformPath, platformName);
        }
        return webProjects;
    }

    private static void appendWebProject(String platformPath, String platformName) {
        List fileArray = null;
        File root = new File(platformPath + File.separator + WEB_PROJECT_PATH);
        try {
            fileArray = FileUtil.findFiles((File)root, (String)TIZEN_WEB_APP_TEMPLATE_FILE, (boolean)true);
            for (File f : fileArray) {
                File templatePrefix;
                File projectDir = f.getParentFile();
                if (projectDir == null || projectDir.getName().equalsIgnoreCase(IGNORE_PROJECT)) continue;
                tizenAppTemplate = TizenModelFactory.unmarshalAppTemplate((File)f);
                if (tizenAppTemplate == null) {
                    System.out.println("failed to unmarshal app teamplate file : " + f.getAbsolutePath());
                    continue;
                }
                String templateName = tizenAppTemplate.getTemplateName();
                if (templateName == null) {
                    templateName = projectDir.getName();
                }
                if ((templatePrefix = projectDir.getParentFile()) == null) continue;
                templateName = templatePrefix.getName() + templateName;
                templateName = templateName.replace(" ", "");
                webProjects.put(new WebProjectInfo(templateName, platformName), projectDir.getAbsolutePath());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getAppID() {
        return this.APPID;
    }

    public void setAppID(String aPPID) {
        this.APPID = aPPID;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
        if (profileName == null || profileName.isEmpty()) {
            this.baseProfileName = "";
            this.baseProfileVer = "";
        } else {
            String[] profiles = profileName.split("-");
            if (profiles.length >= 2) {
                this.baseProfileName = profiles[0];
                this.baseProfileVer = profiles[1];
            } else {
                this.baseProfileName = profileName;
                this.baseProfileVer = "";
            }
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getBaseProfileName() {
        return this.baseProfileName;
    }

    public String getBaseProfileVer() {
        return this.baseProfileVer;
    }

    public String getTizenWebTemplateRootPath(WebProjectInfo webProject) {
        return webProjects.get(webProject);
    }

    public String getTizenWebProjectRootPath(WebProjectInfo webProject) {
        return this.getTizenWebTemplateRootPath(webProject) + File.separator + TIZEN_PROJECT_FOLDER;
    }

    public String getTizenWebTemplateConfigFile(WebProjectInfo webProject) {
        return this.getTizenWebTemplateRootPath(webProject) + File.separator + TIZEN_WEB_APP_TEMPLATE_FILE;
    }

    public String getTizenWebProjectConfigFile(WebProjectInfo webProject) {
        return this.getTizenWebTemplateRootPath(webProject) + File.separator + "config.xml";
    }

    public String getDestTizenWebProjectConfigFile() {
        return this.outputName + File.separator + "config.xml";
    }

    public String getDestTizenProjectDescriptionFile() {
        return this.outputName + File.separator + TIZEN_PROJECT_DESCRIPTION_FILE;
    }

    static {
        fileNameArray = new ArrayList<String>();
        webProjects = new HashMap<WebProjectInfo, String>();
    }
}

