/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.appfw.resourcecutter;

import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import org.tizen.appfw.resourcecutter.InputData;
import org.tizen.appfw.resourcecutter.Utils;

class ResourceNode {
    private static final String FEATURE_LANGUAGE = "feature-language";
    private static final String ATTR_SCREEN_DPI = "screen-dpi";
    private static final String ATTR_SCREEN_DPI_RANGE = "screen-dpi-range";
    private static final String ATTR_LANGUAGE = "language";
    private static final int WEIGHT_SCREEN_DPI = 10000;
    private static final int WEIGHT_SCREEN_DPI_RANGE = 10000;
    private static final int WEIGHT_SCREEN_BPP = 1000;
    private static final int WEIGHT_SCREEN_WIDTH_RANGE = 100;
    private static final int WEIGHT_SCREEN_LARGE = 10;
    private static final int WEIGHT_PLATFORM_VERSION = 1000000;
    private static final int WEIGHT_LANGUAGE = 100000;
    static final int RES_TYPE_IMAGE = 0;
    static final int RES_TYPE_LAYOUT = 1;
    static final int RES_TYPE_SOUND = 2;
    static final int RES_TYPE_BIN = 3;
    private final String mFolder;
    private final int mType;
    final boolean mIsGroup;
    private Map<String, String> mAttributes;

    ResourceNode(String folder, int type) {
        this.mFolder = folder;
        this.mType = type;
        this.mIsGroup = true;
    }

    ResourceNode(String folder, int type, Map<String, String> attr) {
        this.mFolder = folder;
        this.mType = type;
        this.mIsGroup = false;
        this.mAttributes = attr;
    }

    int getType() {
        return this.mType;
    }

    String getLanguage() {
        if (this.mIsGroup) {
            return null;
        }
        return this.mAttributes.get(ATTR_LANGUAGE);
    }

    long getScore(Map<String, String> features) {
        String val = null;
        long score = 0L;
        if (this.mIsGroup) {
            return 0L;
        }
        val = this.mAttributes.get(ATTR_SCREEN_DPI);
        if (val != null) {
            int dpi2;
            int dpi = Integer.parseInt(val);
            String val2 = features.get("feature-dpi");
            if (val2 != null && dpi != (dpi2 = Integer.parseInt(val2))) {
                return -1L;
            }
            score += 10000L;
        } else {
            val = this.mAttributes.get(ATTR_SCREEN_DPI_RANGE);
            if (val != null) {
                int dpi;
                String[] strs = val.split(" ");
                int dpiFrom = Integer.parseInt(strs[1]);
                int dpiTo = Integer.parseInt(strs[3]);
                String val2 = features.get("feature-dpi");
                if (val2 != null && ((dpi = Integer.parseInt(val2)) < dpiFrom || dpi > dpiTo)) {
                    return -1L;
                }
                score += 10000L;
            }
        }
        val = this.mAttributes.get(ATTR_LANGUAGE);
        if (val != null) {
            String val2 = features.get(FEATURE_LANGUAGE);
            if (val2 != null && !val.equals(val2)) {
                return -1L;
            }
            score += 100000L;
        }
        return score;
    }

    void addIds(Map<String, InputData> map, String baseDir) {
        LinkedList<String> all = new LinkedList<String>();
        Utils.getFileList(all, new File(String.valueOf(baseDir) + this.mFolder));
        String group = String.valueOf(baseDir) + this.mFolder + File.separatorChar;
        for (String str : all) {
            String id = str.substring(group.length());
            map.put(id, new InputData(this.mType, id));
        }
    }

    boolean isExceptable(String filename, String baseDir) {
        String name = String.valueOf(new File(String.valueOf(baseDir) + this.mFolder).getAbsolutePath()) + File.separatorChar;
        return !filename.startsWith(name);
    }

    String getPath(String baseDir, String id) {
        return new File(String.valueOf(baseDir) + this.mFolder + File.separatorChar + id).getAbsolutePath();
    }

    int getDpi() {
        String val = null;
        int dpi = -1;
        if (this.mAttributes != null) {
            val = this.mAttributes.get(ATTR_SCREEN_DPI);
            if (val != null) {
                dpi = Integer.parseInt(val);
            } else {
                val = this.mAttributes.get(ATTR_SCREEN_DPI_RANGE);
                if (val != null) {
                    String[] strs = val.split(" ");
                    dpi = Integer.parseInt(strs[1]);
                }
            }
        }
        return dpi;
    }
}

