/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildcs;

import java.io.File;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.command.Command;
import org.tizen.common.sign.command.ReadSigningProfileFileCommand;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.util.CipherUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.buildcs.BuildCSCommand;
import org.tizen.ncli.subcommands.build.buildcs.BuildCSData;
import org.tizen.ncli.subcommands.build.buildcs.BuildCSOption;
import org.tizen.ncli.util.DotnetUtil;
import org.tizen.ncli.util.HostUtil;

public class BuildCSCLICommand
extends AbstractSubCommand<BuildCSData> {
    private Configuration config = new Configuration();
    private BuildCSData data = new BuildCSData();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected BuildCSData call() {
        String[] buildCommand;
        String toolchainPath;
        String toolchain = this.config.getValue("default.csharp.toolchain");
        if (!OSChecker.isWindows() && toolchain.equals("msbuild")) {
            this.progressLog.info("MSBuild is available on Windows only.");
            this.progressLog.info("Please use dotnet cli toolchain to build csharp project.");
            this.progressLog.info("Please run \"tizen cli-config default.csharp.toolchain=dotnet-cli\"");
            throw new UnexpectedException(2, TizenCLIMessages.NOT_YET_SUPPORTED);
        }
        String workingPath = this.workingDir.toString();
        this.data.setWorkingDir(workingPath);
        if (!this.data.hasRequiredOptions) {
            this.progressLog.info(TizenCLIMessages.CANNOT_GET_OPTIONS);
            throw new UnexpectedException(2, TizenCLIMessages.CANNOT_GET_OPTIONS);
        }
        if (!this.validateRequiredOptions()) {
            this.log.trace(TizenCLIMessages.INVALID_ARGS);
            throw new UnexpectedException(2, TizenCLIMessages.INVALID_ARGS);
        }
        this.convertOption(this.data);
        this.data.setType("dotnet");
        String buildTargetFilePath = DotnetUtil.getWorkingTarget(workingPath);
        if (buildTargetFilePath == null) {
            this.progressLog.error("Build failed : There is no such solution or project file.");
            throw new UnexpectedException(2, TizenCLIMessages.INVALID_ARG);
        }
        if (buildTargetFilePath.isEmpty()) {
            this.progressLog.error("Build failed : There is multiple solution or project files.");
            this.progressLog.error("Please specify which solution or project file to use.");
            throw new UnexpectedException(2, TizenCLIMessages.INVALID_ARG);
        }
        Set<String> csproj = DotnetUtil.getCSProjectsFromTarget(buildTargetFilePath);
        this.data.setCsProjects(csproj);
        BuildCSCommand.backupBeforeBuild(this.data);
        if (!this.nugetRestore(buildTargetFilePath)) {
            String errorMsg = "Failed to restore by nuget";
            this.progressLog.error(errorMsg);
            throw new UnexpectedException(2, errorMsg);
        }
        String configuration = this.data.getConfig();
        if (configuration == null) {
            configuration = DotnetUtil.getDefaultConfiguration();
        }
        String authorPathOption = null;
        String authorPassOption = null;
        String distributorPathOption = null;
        String distributorPassOption = null;
        String profileName = this.data.getProfileName();
        if (profileName != null) {
            CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
            SigningProfile profile = null;
            String profilesPath = this.config.getValue("profiles.path");
            if (profilesPath == null) {
                profilesPath = this.config.getValue("default.profiles.path");
            }
            if (!this.validateProfilesPath(profilesPath)) return null;
            ReadSigningProfileFileCommand readProfile = new ReadSigningProfileFileCommand(profilesPath, profileName);
            executor.execute(new Command[]{readProfile});
            this.log.info("Profiles file[{}] is read", (Object)profilesPath);
            profile = readProfile.getProfile();
            if (profile == null) {
                System.out.println(NLS.bind((String)TizenCLIMessages.SIGN_NO_PROFILES, (Object)profileName, (Object)profilesPath));
                return null;
            }
            String path = null;
            String authorPath = null;
            String distributorPath = null;
            String pass = null;
            String authorPass = null;
            String distributorPass = null;
            for (int ordinal = 0; ordinal < 2; ++ordinal) {
                SigningProfileItem item = profile.getProfileItem(ordinal);
                if (item == null) continue;
                path = item.getKeyLocation();
                pass = new String(item.getPassword());
                try {
                    pass = CipherUtil.getDecryptedString((String)pass);
                }
                catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                    this.log.error("Exception occurred while decrypting signing password", (Throwable)e);
                }
                if (ordinal == 0) {
                    authorPath = path;
                    authorPass = pass;
                    continue;
                }
                distributorPath = path;
                distributorPass = pass;
            }
            if (authorPath != null && authorPass != null) {
                authorPathOption = String.format("/p:\"AuthorPath=%s\"", authorPath);
                authorPassOption = String.format("/p:\"AuthorPass=%s\"", authorPass);
            }
            if (distributorPath != null && distributorPass != null) {
                distributorPathOption = String.format("/p:\"DistributorPath=%s\"", distributorPath);
                distributorPassOption = String.format("/p:\"DistributorPass=%s\"", distributorPass);
            }
        }
        if (toolchain.equals("dotnet-cli")) {
            toolchainPath = this.config.getValue("default.dotnet.tool.path");
            buildCommand = authorPathOption != null && authorPassOption != null && distributorPathOption != null && distributorPassOption != null ? new String[]{toolchainPath, "build", "-c", configuration, buildTargetFilePath, authorPathOption, authorPassOption, distributorPathOption, distributorPassOption} : new String[]{toolchainPath, "build", "-c", configuration, buildTargetFilePath};
        } else {
            toolchainPath = this.config.getValue("default.csharp.buildtool.path");
            buildCommand = authorPathOption != null && authorPassOption != null && distributorPathOption != null && distributorPassOption != null ? new String[]{toolchainPath, buildTargetFilePath, "/p:Configuration=" + configuration, authorPathOption, authorPassOption, distributorPathOption, distributorPassOption} : new String[]{toolchainPath, buildTargetFilePath, "/p:Configuration=" + configuration};
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        Map<String, String> env = pb.environment();
        new Configuration().getEnvValueFromCLIConfig(env);
        int exitCode = HostUtil.executeProcess(pb, buildCommand, this.progressLog);
        this.data.setExitCode(exitCode);
        BuildCSCommand.restoreAfterBuild(this.data, configuration);
        return this.data;
    }

    private boolean validateProfilesPath(String profilesPath) {
        boolean result = false;
        if (profilesPath != null) {
            File profiles = new File(profilesPath);
            if (profiles.exists()) {
                result = true;
            } else {
                System.out.println(NLS.bind((String)TizenCLIMessages.SIGN_NO_PROFILES, (Object)profilesPath));
            }
        } else {
            System.out.println(TizenCLIMessages.SIGN_NO_CONFIG_PROFILES);
        }
        return result;
    }

    private void convertOption(BuildCSData data) {
        BuildCSOption.BuildCSRequiredOption[] options = BuildCSOption.BuildCSRequiredOption.values();
        for (int i = 0; i < options.length; ++i) {
            BuildCSOption.BuildCSRequiredOption option = options[i];
            if (option.name().equalsIgnoreCase("configuration")) {
                data.setConfig(option.getValue());
                this.log.debug("configuration : " + data.getConfig());
                continue;
            }
            this.log.debug("invalid option : " + option.name());
        }
    }

    private boolean validateRequiredOptions() {
        boolean result = true;
        BuildCSOption.BuildCSRequiredOption[] options = BuildCSOption.BuildCSRequiredOption.values();
        for (int i = 0; i < options.length; ++i) {
            boolean isValid = false;
            BuildCSOption.BuildCSRequiredOption option = options[i];
            String value = option.getValue();
            String[] candidates = option.getCandidates();
            for (int j = 0; j < candidates.length; ++j) {
                if (!value.equals(candidates[j])) continue;
                isValid = true;
                break;
            }
            if (isValid) continue;
            StringBuilder strBuilder = new StringBuilder();
            for (int j = 0; j < candidates.length; ++j) {
                strBuilder.append(" \"" + candidates[j] + "\"");
            }
            result = false;
            this.progressLog.info(NLS.bind((String)TizenCLIMessages.INVALID_ARG, (Object)((Object)option), (Object)strBuilder.toString().trim()));
            break;
        }
        return result;
    }

    public void setRequiredOptions(String[] input) {
        BuildCSOption.BuildCSRequiredOption[] requiredOptions = BuildCSOption.BuildCSRequiredOption.values();
        for (int i = 0; i < requiredOptions.length; ++i) {
            BuildCSOption.BuildCSRequiredOption requiredOption = requiredOptions[i];
            String str = input[i];
            if (str == null) {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.BN_NO_BUILD_INPUT, (Object)requiredOption.getName()));
                str = this.config.getValue(requiredOption.getKey());
            }
            if (str == null) {
                this.progressLog.info(requiredOption.getErrorMessage());
                continue;
            }
            requiredOption.setValue(str);
        }
    }

    public void setOutputPath(String output) {
        this.data.setOutputPath(output);
    }

    private boolean nugetRestore(String targetFile) {
        String[] nugetCommand;
        String toolchain = this.config.getValue("default.csharp.toolchain");
        if (toolchain.equals("dotnet-cli")) {
            String dotnetPath = this.config.getValue("default.dotnet.tool.path");
            nugetCommand = new String[]{dotnetPath, "restore", targetFile};
        } else {
            String nugetPath = InstallPathConfig.getToolsPath() + File.separator + "nuget" + File.separator + "nuget.exe";
            nugetCommand = new String[]{nugetPath, "restore", targetFile};
        }
        return HostUtil.executeProcess(new ProcessBuilder(new String[0]), nugetCommand, this.progressLog) != -1;
    }

    public void setProfileName(String profile) {
        this.data.setProfile(profile);
    }
}

