/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.sign.GenerateCertificateCommandData;

public class GenerateCertificateCommand
extends AbstractSubCommand<GenerateCertificateCommandData> {
    private GenerateCertificateCommandData data;
    private static final String EXE_PATH = Paths.get(InstallPathConfig.getToolsPath(), "certificate-generator", "KeyCertGeneratorApi.jar").toString();
    private static final String JAVA = InstallPathConfig.getJava();
    private static final String FLAG = "-jar";
    private static final String SUCCESS_CONDITION = "Certificate generated successfully";
    private static final String COUNTRY = "--country";
    private static final String STATE = "--state";
    private static final String CITY = "--city";
    private static final String COMMONNAME = "--commonname";
    private static final String ORGANIZATION = "--organization";
    private static final String UNIT = "--unit";
    private static final String EMAIL = "--email";
    private static final String CERTGEN = "--certgen";
    private static final String PASSWORD = "--password";
    private static final String ALIAS = "--alias";
    private static final String KEYSTORE = "--keystore";

    public GenerateCertificateCommand(GenerateCertificateCommandData data) {
        Assert.notNull((Object)data);
        this.data = data;
    }

    private boolean checkValid(String attr) {
        return attr != null && !attr.isEmpty();
    }

    private ArrayList<String> makeCommandLineArgs(String countryName, String stateName, String cityName, String commonName, String organizationName, String orgUnitName, String emailId, String certGenDirPath, String password, String alias, String pkcsKeyStorePath) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(JAVA);
        cmdArgs.add(FLAG);
        cmdArgs.add(EXE_PATH);
        if (this.checkValid(countryName)) {
            cmdArgs.add(COUNTRY);
            cmdArgs.add(countryName.trim());
        }
        if (this.checkValid(stateName)) {
            cmdArgs.add(STATE);
            cmdArgs.add(stateName.trim());
        }
        if (this.checkValid(cityName)) {
            cmdArgs.add(CITY);
            cmdArgs.add(cityName.trim());
        }
        if (this.checkValid(commonName)) {
            cmdArgs.add(COMMONNAME);
            cmdArgs.add(commonName.trim());
        }
        if (this.checkValid(organizationName)) {
            cmdArgs.add(ORGANIZATION);
            cmdArgs.add(organizationName.trim());
        }
        if (this.checkValid(orgUnitName)) {
            cmdArgs.add(UNIT);
            cmdArgs.add(orgUnitName.trim());
        }
        if (this.checkValid(emailId)) {
            cmdArgs.add(EMAIL);
            cmdArgs.add(emailId.trim());
        }
        if (this.checkValid(certGenDirPath)) {
            cmdArgs.add(CERTGEN);
            cmdArgs.add(certGenDirPath.trim());
        }
        if (this.checkValid(password)) {
            cmdArgs.add(PASSWORD);
            cmdArgs.add(password.trim());
        }
        if (this.checkValid(alias)) {
            cmdArgs.add(ALIAS);
            cmdArgs.add(alias.trim());
        }
        if (this.checkValid(pkcsKeyStorePath)) {
            cmdArgs.add(KEYSTORE);
            cmdArgs.add(pkcsKeyStorePath.trim());
        }
        return cmdArgs;
    }

    private boolean generateSignedCertificate(String countryName, String stateName, String cityName, String commonName, String organizationName, String orgUnitName, String emailId, String certGenDirPath, String password, String alias, String pkcsKeyStorePath) throws Exception {
        ArrayList<String> command = this.makeCommandLineArgs(countryName, stateName, cityName, commonName, organizationName, orgUnitName, emailId, certGenDirPath, password, alias, pkcsKeyStorePath);
        String line = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            inputStream = process.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            line = bufferedReader.readLine();
        }
        catch (IOException ioe) {
            try {
                this.log.error("Failed to create author certificate", (Throwable)ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{bufferedReader});
                throw throwable;
            }
        }
        IOUtil.tryClose((Object[])new Object[]{bufferedReader});
        return line != null && line.startsWith(SUCCESS_CONDITION);
    }

    @Override
    protected GenerateCertificateCommandData call() {
        File file = this.data.getContainerFile(this.workingDir);
        this.progressLog.info("Generating a certificate with");
        this.progressLog.info(this.data.getInformation());
        try {
            if (!this.generateSignedCertificate(this.data.getCountry(), this.data.getState(), this.data.getCity(), this.data.getName(), this.data.getOrganization(), this.data.getUnit(), this.data.getEmail(), this.data.getCertificatesDirectory().getCanonicalPath(), this.data.getKeyPassword(), this.data.getAlias(), file.getCanonicalPath())) {
                this.log.error("Failed to create author certificate");
                throw new Exception("Failed to create author certificate");
            }
            String filename = this.data.getContainerFilename();
            this.progressLog.info("'{}' has been generated in '{}'.", (Object)filename, (Object)this.workingDir);
            return this.data;
        }
        catch (InvalidKeyException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (InvalidParameterException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (SignatureException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (KeyStoreException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (NoSuchProviderException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (CertificateException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (InvalidParameterSpecException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (BadPaddingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (SecurityException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
    }
}

