/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeCLICommand;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeCommand;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeData;

@TizenSubCommand(name="build-native", usage="Build a Tizen native project.")
public class BuildNativeCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-a", aliases={"--arch"}, metaVar="{x86|x86_64|arm|aarch64}", usage="Specify the architecture type. (x86 is default)")
    private String architecture;
    @Option(name="-c", aliases={"--compiler"}, metaVar="{gcc|llvm}", usage="Specify the compiler to build. (llvm is default)")
    private String compiler;
    @Option(name="-C", aliases={"--configuration"}, metaVar="{Debug|Release}", usage="Specify the build configuration. (Debug is default)")
    private String configuration;
    @Option(name="-d", aliases={"--predefine-option"}, metaVar="<symbol>", usage="Specify the predefined symbol.")
    private String[] predefineOption;
    @Option(name="-r", aliases={"--rootstrap"}, metaVar="<rootstrap name>", usage="Specify the rootstap name")
    private String rootstrap;
    @Option(name="-f", aliases={"--framework"}, metaVar="<framework name>", usage="Specify the framework name")
    private String frameworkList = null;
    @Option(name="-j", aliases={"--jobs"}, metaVar="<number of jobs>", usage="Specify the number of parallel builds for the native app.")
    private int jobs;
    @Option(name="-o", aliases={"--output"}, metaVar="<output path>", usage="Specify the output path of build result.", hidden=true)
    private String output;
    @Option(name="-b", aliases={"--buildscript"}, metaVar="<build script path>", usage="Specify the build script path.", hidden=true)
    private String buildscriptPath;
    @Option(name="-s", aliases={"--strip"}, metaVar="{on|off}", usage="Determine whether to strip the native binary.")
    private String strip;
    @Option(name="-e", aliases={"--extraoption"}, metaVar="<asan|lsan| or any option>", usage="Specify extra options for build.")
    private String extraOption;
    private static final String DA = "DA";
    private static final String DA_ORIGIN = "Dynamic Analyzer";

    @Override
    public int execute() {
        int result = -1;
        this.log.trace("Execute BuildNativeCLI...");
        BuildNativeCLICommand command = new BuildNativeCLICommand();
        command.setWorkingDir(this.getRealWorkingPath());
        command.setOutputPath(this.output);
        command.setBuildScriptPath(this.buildscriptPath);
        this.configuration = DA.equals(this.configuration) ? DA_ORIGIN : this.configuration;
        command.setRootstrap(this.rootstrap);
        command.setRequiredOptions(new String[]{this.architecture, this.compiler, this.configuration});
        command.setPredefineOption(this.predefineOption);
        command.setJobsForParallelBuild(this.jobs);
        command.setFrameworkList(this.frameworkList);
        command.setExtraOption(this.extraOption);
        BuildNativeCommand.setStripInfo(this.strip);
        BuildNativeData data = (BuildNativeData)command.runCommand();
        if (data != null) {
            this.progressLog.info("Output path : {} (binary:{})", (Object)data.getOutputPath(), (Object)data.getSbiExecName());
            result = 0;
        }
        return result;
    }

    @Override
    public boolean needPrintTime() {
        return true;
    }
}

