#!/bin/bash
CURRENT_WORKSPACE_PATH=`pwd`
HOME_PATH=`test -h "$0" && dirname $(readlink "$0") || dirname "$0"`

getEmbeddedJDKPath() {
    DONE=false
    until $DONE; do
    read line || DONE=true
    
    # reading each line
    if [[ $line == TIZEN_SDK_INSTALLED_PATH* ]]; then 
        sdkPath="$(cut -d'=' -f2 <<<$line)";
    fi
    if [[ $line == TIZEN_SDK_DATA_PATH* ]]; then 
        sdkDataPath="$(cut -d'=' -f2 <<<$line)"
    fi
    if [[ $line == JDK_PATH* ]]; then 
        sdkInfoJDKPath="$(cut -d'=' -f2 <<<$line)"
    fi
    
    done < "$1"
}

createlogFile(){
    date_time=$(date +"%Y%m%d%H%M%S")
    fileName="tizenCliLog_$date_time.txt"
    if [ ! -d "${sdkDataPath}/cli/logs" ]; then
        mkdir -p "${sdkDataPath}/cli/logs"  
    fi
    logFilePath="$sdkDataPath/cli/logs/$fileName"
    touch "$logFilePath"
    logFile="$logFilePath"
}

setJavaExecPath(){
    # extract the sdkPath, sdkDataPath, sdkInfoJDKPath
    getEmbeddedJDKPath $sdkInfoPath
    logMessage=""
    # update JAVA_EXEC if JDK_PATH specified(and exists) in sdk.info 
    if [ -d "$sdkInfoJDKPath" ]; then
        # jdk directory exixts
        JDK_PATH="$sdkInfoJDKPath"
        logMessage="${logMessage}Using Sdk.info java at ${JDK_PATH}"$'\n'
    elif [[ "$sdkInfoJDKPath" != "" ]]; then 
        logMessage="${logMessage}Jdk specified in sdk.info:${sdkInfoJDKPath} does not exist."$'\n'
    fi


    if [ ! -d "$JDK_PATH" ]; then 
        JAVA_EXEC="java"
        logMessage="${logMessage}Using System java"$'\n'
    else
        UNAME=$(uname)
        case "$UNAME" in
        Linux)
                JAVA_EXEC="$JDK_PATH/bin/java"
            ;;
        Darwin)
                JAVA_EXEC="$JDK_PATH/Contents/Home/bin/java"
            ;;
        esac
    fi

    if [[ ${logMessage} != ""  ]]; then 
        # make the log file
        createlogFile
        echo "${logMessage}">>${logFile}
    fi
}

#set JAVA_EXEC : relative path to embedded jdk
#read the contents of sdk.info to get the jdk path

SCRIPT_DIR="$(cd "$(dirname "$0")" ; pwd -P)"
JDK_PATH="$SCRIPT_DIR/../../../jdk"
sdkInfoPath="$SCRIPT_DIR/../../../sdk.info"

setJavaExecPath

#Run CLI in tizen script directory for dealing with a change of sdk path
# @Added by Hyunjin Lee
# 2015.07.02
cd "$HOME_PATH"

LIB_PATH=../lib-ncli

CONFIG_PATH=../conf-ncli
LOG_CONF_FILE=log4j-progress.xml
LOG_OPT="-Dlog4j.configuration=${LOG_CONF_FILE}"

LIBS=`find $LIB_PATH -maxdepth 1`
LIB=""
for LIB in $LIBS; do
    CLASS_PATH=$CLASS_PATH:$LIB
done

#SDBLIB_PATH=../../sdblib
#SDBLIBS=`find $SDBLIB_PATH -maxdepth 1`
#SDBLIB=""
#for SDBLIB in $SDBLIBS; do
#   CLASS_PATH=$CLASS_PATH:$SDBLIB
#done

CLASS_PATH=$CONFIG_PATH:$CLASS_PATH

escapeSpace() {
    echo $(printf "'%s'" "$ARG" )
}

for ARG in "$@" ; do
    ARGS="$ARGS $(escapeSpace $ARG)"
done

#Check if sub-command is entered - first argument MUST be sub-command!
#If there is no sub-command , do not set --current-workspace-path option.
# @Added by Harry Hyeongseok Heo
# 2013.11.14
#Cover with a single quotation mark, because CURRENT_WORKSPACE_PATH may have white spaces
# @Added by Hyunjin Lee
# 2015.07.02
if [ ${#ARGS} -gt 0 ]
then ARGS="$ARGS --current-workspace-path '$CURRENT_WORKSPACE_PATH'"
else ARGS=""
fi


MAIN=org.tizen.ncli.ide.shell.Main

#echo $CLASS_PATH
EXEC="\"$JAVA_EXEC\" $LOG_OPT -Djava.library.path=$LIB_PATH/spawner -cp $CLASS_PATH $MAIN $ARGS"
eval "$EXEC"

# save exit code
EXITCODE=$?

#Go back to previous directory
# @Added by Hyunjin Lee
# 2015.07.02
cd "$CURRENT_WORKSPACE_PATH"
exit $EXITCODE
