/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.target;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.ncli.core.CLIConstant;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.target.Install;
import org.tizen.ncli.subcommands.target.SdbAppCmdAPI;
import org.tizen.ncli.subcommands.tv.TVSdbCmdSelector;
import org.tizen.ncli.util.CommandUtil;
import org.tizen.ncli.util.ConfigXMLUtil;
import org.tizen.ncli.util.DirectoryUtil;
import org.tizen.ncli.util.TargetUtil;
import org.tizen.ncli.util.ZipUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

public class InstallCLICommand
extends AbstractSubCommand<Install> {
    private IDevice target = null;
    private String name = null;
    private String res = null;
    private String workDir = null;
    private String dirPKG = null;
    private String pkgPath = null;
    private String tepPath = null;
    private String ext = null;
    private String searchPkgCommand = null;
    private String installCommand = TizenPlatformConstants.PKG_TOOL_INSTALL_OLD_COMMAND;
    private String installTepCommand = TizenPlatformConstants.PKG_TOOL_TEP_INSTALL_OLD_COMMAND;
    private static final String SUCCESS = "ok";
    private final String PKGID = "pkgid[";
    private final String APPID = "app_id[";
    private String version = null;
    private String arch = null;
    private float sdbPluginVersion;
    String sdbPluginVer;
    public PlatformCapability platformCapabilityChecker = null;

    public InstallCLICommand() {
        this.searchPkgCommand = OSChecker.isWindows() ? "dir /b %s" : "ls %s";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Install call() {
        Install result;
        block17: {
            block16: {
                MultiLineReceiver mlReceiver;
                block15: {
                    Install install;
                    result = new Install();
                    try {
                        this.workDir = this.workingDir.getCanonicalPath();
                    }
                    catch (IOException e) {
                        this.log.error("Fail to get work directory canonical path");
                        return null;
                    }
                    if (this.target == null) {
                        this.progressLog.info(TizenCLIMessages.CANNOT_GET_TARGET);
                        return null;
                    }
                    if (!this.getPackage()) {
                        this.progressLog.info(TizenCLIMessages.INST_FAIL_INVALID_PACKAGE);
                        return null;
                    }
                    SdbAppCmdAPI acapi = new SdbAppCmdAPI(this.target);
                    if (!acapi.isAvailable()) break block16;
                    mlReceiver = new MultiLineReceiver(){

                        public void processNewLines(String[] lines) {
                            for (String line : lines) {
                                String returnStatus;
                                line = line.trim();
                                InstallCLICommand.this.log.info(line);
                                InstallCLICommand.this.progressLog.info(line);
                                int lastIndex = line.lastIndexOf(91);
                                if (lastIndex == -1 || !InstallCLICommand.SUCCESS.equals(returnStatus = line.substring(lastIndex + 1, lastIndex + 3))) continue;
                                String pkgid = InstallCLICommand.this.getPkgid(line);
                                if (pkgid == null) break;
                                InstallCLICommand.this.progressLog.info(NLS.bind((String)TizenCLIMessages.INST_INSTALLED, (Object)pkgid));
                                break;
                            }
                        }
                    };
                    try {
                        if (acapi.installPackage(this.pkgPath, this.tepPath, (IShellOutputReceiver)mlReceiver)) {
                            this.progressLog.info(TizenCLIMessages.INST_SUCCESS_PACKAGE);
                            break block15;
                        }
                        this.progressLog.info(TizenCLIMessages.INST_FAIL_PACKAGE);
                        install = null;
                    }
                    catch (IOException e) {
                        Install install2;
                        try {
                            this.progressLog.info(TizenCLIMessages.INST_FAIL_PACKAGE);
                            install2 = null;
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{mlReceiver});
                            throw throwable;
                        }
                        IOUtil.tryClose((Object[])new Object[]{mlReceiver});
                        return install2;
                    }
                    IOUtil.tryClose((Object[])new Object[]{mlReceiver});
                    return install;
                }
                IOUtil.tryClose((Object[])new Object[]{mlReceiver});
                break block17;
            }
            if (!this.tranferPackage(this.pkgPath, this.dirPKG)) {
                this.progressLog.info(TizenCLIMessages.INST_FAIL_TRANSFER_PACKAGE);
                return null;
            }
            if (this.tepPath != null) {
                if (this.tranferPackage(this.tepPath, this.dirPKG)) {
                    this.progressLog.info(TizenCLIMessages.INST_SUCCESS_PACKAGE);
                } else {
                    this.progressLog.info(TizenCLIMessages.INST_FAIL_TRANSFER_PACKAGE);
                    return null;
                }
            }
            if (this.installPackage(this.ext, this.pkgPath, this.tepPath, this.dirPKG)) {
                this.progressLog.info(TizenCLIMessages.INST_SUCCESS_PACKAGE);
            } else {
                this.progressLog.info(TizenCLIMessages.INST_FAIL_PACKAGE);
                return null;
            }
        }
        return result;
    }

    public void setTarget(String targetSerialId) {
        this.target = TargetUtil.getDefault().getTarget(targetSerialId);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetSerialId));
        if (this.target == null) {
            throw new UnexpectedException(2, "[target]: null");
        }
    }

    public void setTargetByName(String targetName) {
        this.target = TargetUtil.getDefault().getTargetByName(targetName);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetName));
        if (this.target == null) {
            throw new UnexpectedException(2, "[target]: null");
        }
    }

    public void setName(String name) {
        this.name = name;
        this.log.debug("[name]: " + (name == null ? "null" : name));
    }

    public void setResourceName(String res) {
        if (res != null) {
            this.res = res;
        }
        this.log.debug("[res]: " + (res == null ? "null" : res));
    }

    private boolean getPackage() {
        this.log.debug("=get package=");
        boolean result = false;
        this.dirPKG = TizenPlatformConstants.getAppTmpDirectory((IDevice)this.target);
        String srcFilePath = CommandUtil.resolvePath(this.workingDir, this.name);
        if (FileUtil.isExist((String)srcFilePath)) {
            result = true;
            this.pkgPath = srcFilePath;
            this.ext = FileUtil.getFileExtension((String)this.pkgPath);
            this.log.debug("ext: " + this.ext);
            this.log.debug("package: " + this.pkgPath);
            if (this.res != null) {
                this.tepPath = this.res.equals("*") ? this.getRelatedTepPath() : CommandUtil.resolvePath(this.workingDir, this.res);
            }
        } else {
            this.progressLog.info(NLS.bind((String)TizenCLIMessages.INST_NO_NAMED_PACKAGE, (Object)this.name));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tranferPackage(String pkgPath, String dirPKG) {
        this.log.trace("=transfer package=");
        this.progressLog.info(LaunchMessages.TRANSFER_PACKAGE);
        boolean result = false;
        SyncService sync = null;
        try {
            sync = this.target.getSyncService();
            SyncResult syncSuccess = sync.push(pkgPath, this.target.getFileEntry(dirPKG));
            if (syncSuccess.isOk()) {
                result = true;
                this.progressLog.info(NLS.bind((String)LaunchMessages.TRANSFERRED_PACKAGE, (Object)pkgPath, (Object)dirPKG));
            } else {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.INST_CANNOT_TRANSFER_PACKAGE, (Object)pkgPath));
                this.log.error(NLS.bind((String)TizenCLIMessages.INST_CANNOT_TRANSFER_PACKAGE, (Object)pkgPath));
            }
            if (sync == null) return result;
        }
        catch (IOException e) {
            try {
                this.log.error("[Fail] Fail to push package.");
                if (sync == null) return result;
            }
            catch (Throwable throwable) {
                if (sync == null) throw throwable;
                IOUtil.tryClose((Object[])new Object[]{sync});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{sync});
            return result;
        }
        IOUtil.tryClose((Object[])new Object[]{sync});
        return result;
    }

    private boolean installPackage(String ext, String srcPath, String tepPath, String dirPKG) {
        this.log.trace("=install package=");
        this.progressLog.info(LaunchMessages.INSTALL_PACKAGE);
        TVSdbCmdSelector tvSdbCmdSelector = new TVSdbCmdSelector(this.target);
        boolean result = false;
        String installCmd = null;
        String tempExt = ext;
        tempExt = tempExt.toLowerCase();
        String srcFile = FileUtil.getFileNameFromPath((String)srcPath);
        String tepFile = null;
        if (tepPath != null) {
            tepFile = FileUtil.getFileNameFromPath((String)tepPath);
        }
        if (this.target.isSecureProtocol()) {
            if ((tempExt.equals("wgt") || tempExt.equals("tpk")) && tvSdbCmdSelector.isSTV()) {
                installCmd = this.getTVInstallCmd(srcPath, srcFile, tempExt);
            } else {
                this.installCommand = "appinstall %s";
                installCmd = String.format(this.installCommand, dirPKG + "/" + srcFile);
            }
        } else if (tempExt.equals("wgt") && tvSdbCmdSelector.isSTV()) {
            installCmd = this.getTVInstallCmd(srcPath, srcFile, tempExt);
        } else {
            installCmd = tepFile == null ? String.format(this.installCommand, ext, dirPKG + "/" + srcFile) : String.format(this.installTepCommand, dirPKG + "/" + srcFile, dirPKG + "/" + tepFile);
            String appCmdProtocolVersion = this.target.getAppCmdProtocolVersion();
            if ("0.1".equals(appCmdProtocolVersion)) {
                installCmd = installCmd + " -G";
            }
        }
        this.log.debug("[Install Command]: " + installCmd);
        String returnResult = TargetUtil.getDefault().returnExecuteCommand(this.target, installCmd);
        if (returnResult == null) {
            this.log.debug("Install Command returned null result.");
            return false;
        }
        this.log.info(returnResult);
        this.progressLog.info("--------------------");
        this.progressLog.info("Platform log view");
        this.progressLog.info("--------------------");
        this.progressLog.info(returnResult);
        String[] lines = returnResult.split(HostUtil.LINE_SEPARATOR);
        if (tvSdbCmdSelector.isSTV()) {
            for (String line : lines) {
                if (!line.contains("install completed")) continue;
                result = true;
                String appid = this.getAppid(line);
                if (appid == null) break;
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.INST_INSTALLED, (Object)appid));
                break;
            }
        } else {
            for (String line : lines) {
                String returnStatus;
                int lastIndex = line.lastIndexOf(91);
                if (lastIndex == -1 || !SUCCESS.equals(returnStatus = line.substring(lastIndex + 1, lastIndex + 3))) continue;
                result = true;
                String pkgid = this.getPkgid(line);
                if (pkgid == null) break;
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.INST_INSTALLED, (Object)pkgid));
                break;
            }
        }
        return result;
    }

    private String getAppid(String line) {
        int startIndex = line.indexOf("app_id[");
        int endIndex = line.indexOf(93, startIndex);
        String appid = line.substring(startIndex + "app_id[".length(), endIndex);
        return appid;
    }

    private String getPkgid(String line) {
        int startIndex = line.indexOf("pkgid[");
        int endIndex = line.indexOf(93, startIndex);
        String pkgid = line.substring(startIndex + "pkgid[".length(), endIndex);
        return pkgid;
    }

    private String getTVInstallCmd(String filePath, String fileName, String tempExt) {
        String tvInstallCmd = "";
        TVSdbCmdSelector tvSdbCmdSelector = new TVSdbCmdSelector(this.target);
        String cmd = tvSdbCmdSelector.getCmd("TV_INSTALL_COMMAND", null);
        String appID = this.getAppID(filePath, tempExt);
        boolean validsdbPluginVersion = true;
        try {
            this.platformCapabilityChecker = this.target.getPlatformCapability();
        }
        catch (Exception e) {
            this.log.debug("getPlatformCapability failed");
            validsdbPluginVersion = false;
        }
        if (validsdbPluginVersion) {
            this.version = this.platformCapabilityChecker.getPlatformVersion();
            this.arch = this.platformCapabilityChecker.getCpuArch();
            this.sdbPluginVer = this.platformCapabilityChecker.getSdbdPluginVersion().substring(0, 3);
            if (!this.sdbPluginVer.equals("unknown".substring(0, 3))) {
                this.sdbPluginVersion = Float.valueOf(this.sdbPluginVer).floatValue();
            }
        }
        if (validsdbPluginVersion && !this.sdbPluginVer.equals("unknown".substring(0, 3)) && ((double)this.sdbPluginVersion < 3.4 || this.sdbPluginVer.contains("3.4")) && this.version.startsWith("4.0") && this.arch.contains("armv7")) {
            appID = tempExt;
        }
        tvInstallCmd = String.format(cmd, appID, this.dirPKG + "/" + fileName);
        return tvInstallCmd;
    }

    private String getAppID(String filePath, String tempExt) {
        String appID = "";
        File targetFile = new File(filePath);
        String targetDir = targetFile.getParent();
        if (targetDir == null) {
            return null;
        }
        String tempDecompressDirPath = targetDir + '/' + "_tempDecompress";
        File tempUncompressDir = new File(tempDecompressDirPath);
        try {
            tempUncompressDir.mkdirs();
            ZipUtil.unzip(targetFile, tempUncompressDir, false);
            ConfigXMLUtil configXmlUtil = null;
            if (tempExt.equals("wgt")) {
                configXmlUtil = new ConfigXMLUtil(tempDecompressDirPath + '/' + "config.xml");
            } else if (tempExt.equals("tpk")) {
                configXmlUtil = new ConfigXMLUtil(tempDecompressDirPath + '/' + "tizen-manifest.xml");
            }
            appID = configXmlUtil.getAppID(tempExt);
            DirectoryUtil.deleteDirectory(tempUncompressDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appID;
    }

    private String getRelatedTepPath() {
        String filename;
        int index;
        String pkgname;
        File[] files;
        File pkgFile = new File(this.pkgPath);
        File parentFile = pkgFile.getParentFile();
        if (parentFile != null && (files = parentFile.listFiles(new FilenameFilter(pkgname = (index = (filename = FileUtil.getFileNameFromPath((String)this.pkgPath)).indexOf(45)) != -1 ? filename.substring(0, index - 1) : filename){
            final /* synthetic */ String val$pkgname;
            {
                this.val$pkgname = string;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(CLIConstant.TEP_EXT) && name.startsWith(this.val$pkgname);
            }
        })) != null && files.length != 0) {
            try {
                return files[0].getCanonicalPath();
            }
            catch (IOException e) {
                this.log.error(e.getMessage());
                return null;
            }
        }
        return null;
    }
}

