/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.model;

import java.util.ArrayList;
import org.tizen.common.sign.model.AbstractSignatureXml;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.util.Assert;
import org.w3c.dom.Document;

public class DistributorSignatureXml
extends AbstractSignatureXml {
    private int ordinal;

    public DistributorSignatureXml(Document document, int ordinal) {
        super(document);
        this.setOrdinal(ordinal);
    }

    public void setOrdinal(int ordinal) {
        Assert.isTrue((ordinal > 0 ? 1 : 0) != 0, (String)"For distributor, ordinal is greater than 0.");
        this.ordinal = ordinal;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getFilename() {
        return "signature" + this.ordinal + ".xml";
    }

    public static boolean is(String filename) {
        return SignatureUtility.isDistributorSignatureFile(filename);
    }

    public static String[] getAvailableFilename() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("signature1.xml");
        list.add("signature2.xml");
        return list.toArray(new String[0]);
    }
}

