/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.packages;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import org.tizen.library.sdkutils.api.impl.SDKUtils;
import org.tizen.library.sdkutils.service.ExecutorService;
import org.tizen.library.sdkutils.util.PathUtil;
import org.tizen.library.sdkutils.util.PlatformUtil;
import org.tizen.library.sdkutils.util.SDKInfoUtil;
import org.tizen.library.sdkutils.util.SDKToolContents;

public class PackageManagerWrapper {
    private static final String SDK_UTILS_CACHE = "sdk-utils-cache";
    private static final String ALL_PKG_INFO_NAME = "all_packageinfo";

    public String getSDKPackageInfoPath(boolean useCache) {
        if (!useCache) {
            return this.getRecentPackageInfo();
        }
        return this.getLatesCache();
    }

    private String getLatesCache() {
        String retPath = null;
        File[] caches = this.getCacheFiles();
        retPath = caches != null && caches.length > 0 ? caches[caches.length - 1].getAbsolutePath() : this.getInstalledPackageInfo();
        return retPath;
    }

    private String getRecentPackageInfo() {
        return PackageManagerWrapper.executePackageManager(CommandType.CREATE_CACHE_FROM_REPO);
    }

    private String getInstalledPackageInfo() {
        return PackageManagerWrapper.executePackageManager(CommandType.CREATE_CACHE_FROM_INST);
    }

    private File[] getCacheFiles() {
        File confDir;
        File[] retCaches = null;
        String cacheDirPath = PathUtil.getPath(PathUtil.getUpdateManagerConfigHome(), SDK_UTILS_CACHE, SDKInfoUtil.getDigestFromSDKInstallPath(ExecutorService.class));
        if (cacheDirPath != null && !cacheDirPath.isEmpty() && (confDir = new File(cacheDirPath)).exists() && (retCaches = confDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().matches("all_packageinfo_[0-9]{8}-[0-9]{9}.json");
            }
        })) != null && retCaches.length > 0) {
            Arrays.sort(retCaches, new Comparator<File>(){

                @Override
                public int compare(File arg0, File arg1) {
                    return arg0.compareTo(arg1);
                }
            });
        }
        return retCaches;
    }

    private static String executePackageManager(CommandType cmd) {
        String sdkInstalledPath = SDKInfoUtil.findSDKInstallPath(ExecutorService.class);
        if (sdkInstalledPath == null || sdkInstalledPath.isEmpty()) {
            return null;
        }
        String result = null;
        ProcessBuilder pb = null;
        String packageManagerPath = PathUtil.getPath(SDKToolContents.PACKAGEMANAGER_EXECUTABLE_PATH, SDKToolContents.PACKAGEMANAGER_CLI_EXECUTABLE_NAME);
        String java = SDKUtils.getInstance().getJavaPath();
        pb = PlatformUtil.isWindows() ? new ProcessBuilder("cmd", "/c", java, "-jar", packageManagerPath, "-path", SDKToolContents.PACKAGEMANAGER_EXECUTABLE_PATH, cmd.getCommand(), cmd.getOption()) : new ProcessBuilder(java, "-jar", packageManagerPath, "-path", SDKToolContents.PACKAGEMANAGER_EXECUTABLE_PATH, cmd.getCommand(), cmd.getOption());
        try {
            Process process;
            int errCode;
            if (pb != null && (errCode = (process = pb.start()).waitFor()) == 0 && (result = PackageManagerWrapper.readReturnValue(process.getInputStream())) == "null") {
                result = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readReturnValue(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }

    private static enum CommandType {
        CREATE_CACHE_FROM_REPO("sdk-utils-save-cache", "--from-repository"),
        CREATE_CACHE_FROM_INST("sdk-utils-save-cache", "--from-installed");

        private final String command;
        private final String option;

        private CommandType(String command, String option) {
            this.command = command;
            this.option = option;
        }

        public String getCommand() {
            return this.command;
        }

        public String getOption() {
            return this.option;
        }
    }
}

