/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.file;

import java.io.ByteArrayInputStream;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.file.FileHandlingCommand;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ObjectUtil;

public class WriteFileCommand
extends FileHandlingCommand<Boolean> {
    protected final byte[] contents;

    public WriteFileCommand(String path, byte[] contents) {
        this.setPath(path);
        this.contents = contents;
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        byte[] safeBytes = (byte[])ObjectUtil.nvl(this.contents, new byte[0]);
        this.logger.trace("Trying write {} in {} bytes", (Object)this.path, (Object)safeBytes.length);
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(safeBytes);
            context.getFileHandler().write(this.path, is);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(is);
            throw throwable;
        }
        IOUtil.tryClose(is);
    }
}

