/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TiffImage;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.OptionArgument;
import com.lowagie.toolbox.arguments.filters.ImageFilter;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Tiff2Pdf
extends AbstractTool {
    public Tiff2Pdf() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to convert", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
        OptionArgument optionArgument = new OptionArgument(this, "pagesize", "Pagesize");
        optionArgument.addOption("A4", "A4");
        optionArgument.addOption("Letter", "LETTER");
        optionArgument.addOption("Original format", "ORIGINAL");
        this.arguments.add(optionArgument);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Tiff2Pdf", true, false, true);
        this.internalFrame.setSize(550, 250);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Tiff2Pdf OPENED ===");
    }

    public void execute() {
        try {
            Object object;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(file.getAbsolutePath());
            int n = TiffImage.getNumberOfPages(randomAccessFileOrArray);
            boolean bl = false;
            Document document = new Document(PageSize.A4);
            float f = PageSize.A4.getWidth() - 40.0f;
            float f2 = PageSize.A4.getHeight() - 120.0f;
            if ("ORIGINAL".equals(this.getValue("pagesize"))) {
                object = TiffImage.getTiffImage(randomAccessFileOrArray, 1);
                if (((Image)object).getDpiX() > 0 && ((Image)object).getDpiY() > 0) {
                    ((Image)object).scalePercent(7200.0f / (float)((Image)object).getDpiX(), 7200.0f / (float)((Image)object).getDpiY());
                }
                document.setPageSize(new Rectangle(((Image)object).getScaledWidth(), ((Image)object).getScaledHeight()));
                bl = true;
            } else if ("LETTER".equals(this.getValue("pagesize"))) {
                document.setPageSize(PageSize.LETTER);
                f = PageSize.LETTER.getWidth() - 40.0f;
                f2 = PageSize.LETTER.getHeight() - 120.0f;
            }
            object = PdfWriter.getInstance(document, new FileOutputStream(file2));
            document.open();
            PdfContentByte pdfContentByte = ((PdfWriter)object).getDirectContent();
            for (int i = 0; i < n; ++i) {
                Image image = TiffImage.getTiffImage(randomAccessFileOrArray, i + 1);
                if (image == null) continue;
                if (image.getDpiX() > 0 && image.getDpiY() > 0) {
                    image.scalePercent(7200.0f / (float)image.getDpiX(), 7200.0f / (float)image.getDpiY());
                }
                if (bl) {
                    document.setPageSize(new Rectangle(image.getScaledWidth(), image.getScaledHeight()));
                    document.newPage();
                    image.setAbsolutePosition(0.0f, 0.0f);
                } else {
                    if (image.getScaledWidth() > f || image.getScaledHeight() > f2) {
                        if (image.getDpiX() > 0 && image.getDpiY() > 0) {
                            float f3 = f / image.getScaledWidth();
                            float f4 = f2 / image.getScaledHeight();
                            float f5 = Math.min(f3, f4);
                            image.scalePercent(7200.0f / (float)image.getDpiX() * f5, 7200.0f / (float)image.getDpiY() * f5);
                        } else {
                            image.scaleToFit(f, f2);
                        }
                    }
                    image.setAbsolutePosition(20.0f, 20.0f);
                    document.newPage();
                    document.add(new Paragraph(file + " - page " + (i + 1)));
                }
                pdfContentByte.addImage(image);
                System.out.println("Finished page " + (i + 1));
            }
            randomAccessFileOrArray.close();
            document.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Tiff2Pdf tiff2Pdf = new Tiff2Pdf();
        if (stringArray.length < 2) {
            System.err.println(tiff2Pdf.getUsage());
        }
        tiff2Pdf.setMainArguments(stringArray);
        tiff2Pdf.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Tiff2Pdf.addVersion("$Id: Tiff2Pdf.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

