/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import keycertificategenerator.TizenKeyCertificateGenerator;
import org.tizen.common.util.Assert;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.sign.GenerateCertificateCommandData;

public class GenerateCertificateCommand
extends AbstractSubCommand<GenerateCertificateCommandData> {
    private GenerateCertificateCommandData data;

    public GenerateCertificateCommand(GenerateCertificateCommandData data) {
        Assert.notNull((Object)data);
        this.data = data;
    }

    @Override
    protected GenerateCertificateCommandData call() {
        File file = this.data.getContainerFile(this.workingDir);
        this.progressLog.info("Generating a certificate with");
        this.progressLog.info(this.data.getInformation());
        try {
            TizenKeyCertificateGenerator.KeyCertGeneratorFromIde((String)this.data.getCountry(), (String)this.data.getState(), (String)this.data.getCity(), (String)this.data.getName(), (String)this.data.getOrganization(), (String)this.data.getUnit(), (String)this.data.getEmail(), (String)this.data.getCertificatesDirectory().getCanonicalPath(), (String)this.data.getKeyPassword(), (String)this.data.getAlias(), (String)file.getCanonicalPath());
            String filename = this.data.getContainerFilename();
            this.progressLog.info("'{}' has been generated in '{}'.", (Object)filename, (Object)this.workingDir);
            return this.data;
        }
        catch (InvalidKeyException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (InvalidParameterException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (SignatureException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (KeyStoreException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (NoSuchProviderException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (CertificateException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (InvalidParameterSpecException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (BadPaddingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (SecurityException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
    }
}

