/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import java.util.Map;
import org.tizen.sdblib.util.MapUtil;
import org.tizen.sdblib.util.ObjectUtil;

public enum FileEntryType {
    RootDevice("Device"),
    RootEmulator("Emulator"),
    File("File"),
    Directory("Directory"),
    Link("Type Link"),
    DirectoryLink("Directory Link"),
    BlockDevice("Block"),
    CharacterDevice("Character"),
    Socket("Socket"),
    FIFO("Type Fifo"),
    Unknown("Unknown");

    private String name;
    private static final Map<Character, FileEntryType> SYMBOL2TYPE;

    static {
        SYMBOL2TYPE = MapUtil.asMap(new Object[][]{{Character.valueOf('-'), File}, {Character.valueOf('d'), Directory}, {Character.valueOf('l'), Link}, {Character.valueOf('b'), BlockDevice}, {Character.valueOf('c'), CharacterDevice}, {Character.valueOf('s'), Socket}, {Character.valueOf('p'), FIFO}});
    }

    private FileEntryType(String name) {
        this.name = name;
    }

    public static FileEntryType from(char flag) {
        return ObjectUtil.nvl(SYMBOL2TYPE.get(Character.valueOf(flag)), Unknown);
    }

    public boolean isRoot() {
        return this.equals((Object)RootDevice) || this.equals((Object)RootEmulator);
    }

    public boolean isDirectory() {
        return this.equals((Object)Directory) || this.equals((Object)DirectoryLink);
    }

    public boolean isLink() {
        return this.equals((Object)Link) || this.equals((Object)DirectoryLink);
    }

    public boolean canHaveChild() {
        return this.isDirectory() || this.isRoot();
    }

    public boolean isDevice() {
        return this.equals((Object)BlockDevice) || this.equals((Object)CharacterDevice);
    }

    public boolean isFIFO() {
        return this.equals((Object)FIFO);
    }

    public String toString() {
        return this.name;
    }
}

