/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.repack;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.repack.RePackageCLICommandData;
import org.tizen.ncli.util.DirectoryUtil;

public class RePackageMultiCLICommand
extends AbstractSubCommand<RePackageCLICommandData> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private File tempDir = null;

    private File getTempDir() {
        if (this.tempDir == null) {
            try {
                this.tempDir = DirectoryUtil.createTempDirectory();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.tempDir = null;
            }
        }
        return this.tempDir;
    }

    private void removeTempDir() {
        if (this.tempDir != null) {
            if (DirectoryUtil.deleteDirectory(this.tempDir)) {
                this.tempDir = null;
            } else {
                this.log.trace("Could not delete temp file: {}", (Object)this.tempDir);
            }
        }
    }

    protected void finalize() {
        this.removeTempDir();
    }

    @Override
    protected RePackageCLICommandData call() {
        return null;
    }
}

