/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ValidationUtil;
import org.tizen.ncli.exceptions.PackageNotInstalledException;
import org.tizen.ncli.util.ValidationResult;

public class GenerateCertificateCommandData {
    public static final String DEFAULT_FILENAME = "author";
    public static final String CONTAINER_FILE_EXTENSION = "p12";
    private String containerFilename;
    private String containerPassword;
    private String alias;
    private String keyPassword;
    private String country;
    private String state;
    private String city;
    private String name;
    private String organization;
    private String unit;
    private String email;
    private List<ValidationResult> validatedResult;
    private File certificatesDirectory;

    public GenerateCertificateCommandData(String containerFilename, String containerPassword, String alias, String keyPassword) {
        Assert.notNull((Object)containerFilename);
        Assert.notNull((Object)containerPassword);
        Assert.notNull((Object)alias);
        Assert.notNull((Object)keyPassword);
        this.containerFilename = containerFilename;
        this.containerPassword = containerPassword;
        this.alias = alias;
        this.keyPassword = keyPassword;
        this.validatedResult = null;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
        this.validatedResult = null;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
        this.validatedResult = null;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
        this.validatedResult = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.validatedResult = null;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
        this.validatedResult = null;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
        this.validatedResult = null;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        this.validatedResult = null;
    }

    public File getCertificatesDirectory() throws PackageNotInstalledException {
        if (this.certificatesDirectory == null) {
            String certGeneratorPath = SigningPathUtil.getCertificateGeneratorPath();
            File certGeneratorFile = new File(certGeneratorPath);
            if (!certGeneratorFile.exists()) {
                throw new PackageNotInstalledException("The 'certificate-generator' package is not installed.");
            }
            this.certificatesDirectory = certGeneratorFile;
        }
        return this.certificatesDirectory;
    }

    public static String appendContainerFileExtension(String filename) {
        Assert.notNull((Object)filename);
        return filename + "." + CONTAINER_FILE_EXTENSION;
    }

    public File getContainerFile(File parent) {
        Assert.notNull((Object)parent);
        return new File(parent, GenerateCertificateCommandData.appendContainerFileExtension(this.containerFilename));
    }

    public String getContainerFilename() {
        return this.containerFilename;
    }

    public String getContainerPassword() {
        return this.containerPassword;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public List<ValidationResult> getValidatedResult() {
        if (this.validatedResult == null) {
            return new ArrayList<ValidationResult>();
        }
        return Collections.unmodifiableList(this.validatedResult);
    }

    public boolean validate(File workingDir) {
        boolean bCheckEmail;
        if (this.validatedResult != null) {
            return true;
        }
        this.validatedResult = new ArrayList<ValidationResult>();
        try {
            this.getCertificatesDirectory();
        }
        catch (PackageNotInstalledException e) {
            this.validatedResult.add(new ValidationResult(ValidationResult.Status.ERROR, e.getMessage()));
            return false;
        }
        if (this.country != null) {
            boolean bCheckCountryLength;
            boolean bl = bCheckCountryLength = this.country.length() > 1;
            if (!bCheckCountryLength) {
                this.validatedResult.add(new ValidationResult(ValidationResult.Status.ERROR, "Country option must have at least two characters."));
                return false;
            }
        }
        String regexp = "[a-zA-Z ]*";
        if (this.country != null && !this.country.matches("[a-zA-Z ]*")) {
            this.validatedResult.add(new ValidationResult(ValidationResult.Status.ERROR, "Country option is allowed with alphabet and white-space characters."));
            return false;
        }
        if (this.state != null && !this.state.matches("[a-zA-Z ]*")) {
            this.validatedResult.add(new ValidationResult(ValidationResult.Status.ERROR, "State option is allowed with alphabet and white-space characters."));
            return false;
        }
        if (this.city != null && !this.city.matches("[a-zA-Z ]*")) {
            this.validatedResult.add(new ValidationResult(ValidationResult.Status.ERROR, "City option is allowed with alphabet and white-space characters."));
            return false;
        }
        String filename = this.getContainerFilename();
        File file = new File(workingDir, GenerateCertificateCommandData.appendContainerFileExtension(filename));
        if (file.exists()) {
            this.validatedResult.add(new ValidationResult(ValidationResult.Status.ERROR, "Already exist the specified filename."));
            return false;
        }
        if (this.email != null && !(bCheckEmail = ValidationUtil.checkForEmail((String)this.email))) {
            this.validatedResult.add(new ValidationResult(ValidationResult.Status.ERROR, "Email option is malformed."));
            return false;
        }
        return true;
    }

    public String getInformation() {
        String masked;
        String tab = "  ";
        StringBuilder builder = new StringBuilder();
        if (this.containerFilename != null) {
            builder.append("  ").append("File name = ").append(this.containerFilename).append('\n');
        }
        if (this.containerPassword != null) {
            masked = this.containerPassword.replaceAll(".", "*");
            builder.append("  ").append("Container Password = ").append(masked).append('\n');
        }
        if (this.alias != null) {
            builder.append("  ").append("Alias = ").append(this.alias).append('\n');
        }
        if (this.keyPassword != null) {
            masked = this.keyPassword.replaceAll(".", "*");
            builder.append("  ").append("Key Password = ").append(masked).append('\n');
        }
        if (this.country != null) {
            builder.append("  ").append("Country = ").append(this.country).append('\n');
        }
        if (this.state != null) {
            builder.append("  ").append("State = ").append(this.state).append('\n');
        }
        if (this.city != null) {
            builder.append("  ").append("City = ").append(this.city).append('\n');
        }
        if (this.name != null) {
            builder.append("  ").append("Name = ").append(this.name).append('\n');
        }
        if (this.organization != null) {
            builder.append("  ").append("Organization = ").append(this.organization).append('\n');
        }
        if (this.unit != null) {
            builder.append("  ").append("Organization Unit = ").append(this.unit).append('\n');
        }
        if (this.email != null) {
            builder.append("  ").append("E-mail = ").append(this.email).append('\n');
        }
        if (this.certificatesDirectory != null) {
            builder.append("  ").append("Internal Certificates Directory = ").append(this.certificatesDirectory);
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("File name = ").append(this.containerFilename).append('\n');
        builder.append("Container Password = ").append(this.containerPassword).append('\n');
        builder.append("Alias = ").append(this.alias).append('\n');
        builder.append("Key Password = ").append(this.keyPassword).append('\n');
        builder.append("Country = ").append(this.country).append('\n');
        builder.append("State = ").append(this.state).append('\n');
        builder.append("City = ").append(this.city).append('\n');
        builder.append("Name = ").append(this.name).append('\n');
        builder.append("Organization = ").append(this.organization).append('\n');
        builder.append("Organization Unit = ").append(this.unit).append('\n');
        builder.append("E-mail = ").append(this.email).append('\n');
        builder.append("Internal Certificates Directory = ").append(this.certificatesDirectory);
        return builder.toString();
    }
}

