/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.prompter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.UserField;
import org.tizen.common.core.command.prompter.Option;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.StringUtil;

public class EclipsePrompter
implements Prompter {
    protected static final String EP_ID = "org.tizen.common.prompter";
    protected static final String ATTR_SCOPE = "scope";
    protected static final String ATTR_CLASS = "class";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Prompter defaultPrompter;
    protected final HashMap<String, Prompter> name2prompter;

    public EclipsePrompter(Prompter defaultPrompter) {
        this.defaultPrompter = defaultPrompter;
        this.name2prompter = new HashMap();
    }

    protected Prompter getPrompter() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EP_ID);
        IExtension[] exts = ep.getExtensions();
        StackTraceElement[] stackTraceElementArray = stacks;
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stack = stackTraceElementArray[n2];
            String className = stack.getClassName();
            IExtension[] iExtensionArray = exts;
            int n3 = exts.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement[] configs;
                IExtension ext = iExtensionArray[n4];
                IConfigurationElement[] iConfigurationElementArray = configs = ext.getConfigurationElements();
                int n5 = configs.length;
                int n6 = 0;
                while (n6 < n5) {
                    IConfigurationElement config = iConfigurationElementArray[n6];
                    String scope = config.getAttribute(ATTR_SCOPE);
                    if (!StringUtil.isEmpty(scope) && ObjectUtil.equals(className, scope)) {
                        try {
                            return (Prompter)config.createExecutableExtension(ATTR_CLASS);
                        }
                        catch (CoreException coreException) {
                            this.logger.error("Can't create prompter :" + config.getAttribute(ATTR_CLASS));
                            return this.defaultPrompter;
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return this.defaultPrompter;
    }

    @Override
    public Option interact(String question, Option ... options) {
        Prompter prompter = this.getPrompter();
        return prompter.interact(question, options);
    }

    @Override
    public Object password(String message) {
        Prompter prompter = this.getPrompter();
        return prompter.password(message);
    }

    @Override
    public void error(String message) {
        Prompter prompter = this.getPrompter();
        prompter.error(message);
    }

    @Override
    public void notify(String message) {
        Prompter prompter = this.getPrompter();
        prompter.notify(message);
    }

    @Override
    public void cancel() {
        Prompter prompter = this.getPrompter();
        prompter.cancel();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()).substring(0, 4);
    }

    @Override
    public void batch(Collection<UserField> userFields, Map<String, Object> options) {
        Prompter prompter = this.getPrompter();
        prompter.batch(userFields, options);
    }
}

