/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.target.Uninstall;
import org.tizen.ncli.subcommands.target.UninstallCLICommand;

@TizenSubCommand(name="uninstall", usage="Uninstall the package from the target device.")
public class UninstallCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-t", aliases={"--target"}, metaVar="<target>", usage="Specify the target to uninstall the package.")
    private String target;
    @Option(name="-s", aliases={"--serial"}, metaVar="<serial>", usage="Specify the serial to uninstall the package.")
    private String serial;
    @Option(name="-p", aliases={"--pkgid"}, metaVar="<package id>", usage="Specify the Tizen package ID installed on the target.")
    private String pkgid;

    @Override
    public int execute() {
        int result = -1;
        this.log.trace("Execute UninstallCLI...");
        UninstallCLICommand command = new UninstallCLICommand();
        command.setWorkingDir(this.getRealWorkingPath());
        if (this.serial != null) {
            command.setTarget(this.serial);
        } else {
            command.setTargetByName(this.target);
        }
        command.setPkgid(this.pkgid);
        Uninstall data = (Uninstall)command.runCommand();
        if (data != null) {
            result = 0;
        }
        return result;
    }

    @Override
    public boolean needPrintTime() {
        return true;
    }
}

