/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.tizen.library.sdkutils.util.Log;

public class ContentEditUtil {
    public static boolean replaceContent(File file, String keyName, String keyValue) {
        return ContentEditUtil.replaceContent(file, keyName, keyValue, "=");
    }

    public static boolean replaceContent(File file, String keyName, String keyValue, String delimiter) {
        boolean result = false;
        File rfile = file;
        File wfile = new File(file.toString() + ".bak");
        if (!rfile.exists()) {
            return result;
        }
        if (wfile.exists()) {
            try {
                wfile.delete();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        try {
            wfile.createNewFile();
        }
        catch (IOException e1) {
            Log.catching(e1);
            Log.debug("A file cannot be create: " + wfile.toString());
        }
        FileLock fl = null;
        try (FileInputStream fis = new FileInputStream(rfile);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
             BufferedReader br = new BufferedReader(isr);
             FileOutputStream fos = new FileOutputStream(wfile);
             OutputStreamWriter osr = new OutputStreamWriter(fos);
             BufferedWriter wr = new BufferedWriter(osr);){
            String readLine;
            fl = fos.getChannel().tryLock();
            while ((readLine = br.readLine()) != null) {
                String writeLine;
                if (readLine.contains(keyName)) {
                    writeLine = readLine;
                    int startChar = readLine.indexOf(delimiter);
                    if (startChar == -1) break;
                    String str = readLine.substring(startChar + 1);
                    writeLine = writeLine.replace(str, keyValue);
                    wr.write(writeLine);
                    wr.newLine();
                    result = true;
                    continue;
                }
                writeLine = readLine;
                wr.write(writeLine);
                wr.newLine();
            }
            if (fl != null) {
                fl.release();
            }
        }
        catch (IOException ioe) {
            Log.catching(ioe);
            result = false;
        }
        catch (OverlappingFileLockException ofe) {
            Log.catching(ofe);
            result = false;
        }
        try {
            if (!rfile.delete()) {
                Log.error("Unable to delete file");
            }
            if (!wfile.renameTo(rfile)) {
                Log.error("Unable to rename file");
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean addContent(File file, String keyName, String keyValue) {
        return ContentEditUtil.addContent(file, keyName, keyValue, "=");
    }

    public static boolean addContent(File file, String keyName, String keyValue, String delimiter) {
        boolean result = false;
        File rfile = file;
        File wfile = new File(file.toString() + ".bak");
        if (!rfile.exists()) {
            return result;
        }
        if (wfile.exists()) {
            try {
                wfile.delete();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        try {
            wfile.createNewFile();
        }
        catch (IOException e1) {
            Log.catching(e1);
            Log.debug("A file cannot be create: " + wfile.toString());
        }
        FileLock fl = null;
        try (FileInputStream fis = new FileInputStream(rfile);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
             BufferedReader br = new BufferedReader(isr);
             FileOutputStream fos = new FileOutputStream(wfile);
             OutputStreamWriter osr = new OutputStreamWriter(fos);
             BufferedWriter wr = new BufferedWriter(osr);){
            String writeLine;
            String readLine;
            fl = fos.getChannel().tryLock();
            while ((readLine = br.readLine()) != null) {
                writeLine = readLine;
                wr.write(writeLine);
                wr.newLine();
            }
            writeLine = keyName + delimiter + keyValue;
            wr.write(writeLine);
            wr.newLine();
            if (fl != null) {
                fl.release();
            }
        }
        catch (IOException ioe) {
            Log.catching(ioe);
            result = false;
        }
        catch (OverlappingFileLockException ofe) {
            Log.catching(ofe);
            result = false;
        }
        try {
            if (!rfile.delete()) {
                Log.error("Unable to delete file");
            }
            if (!wfile.renameTo(rfile)) {
                Log.error("Unable to rename file");
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static String getContent(File file, String registryKey, String delimeter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getContent(File file, String registryKey) {
        return ContentEditUtil.getContent(file, registryKey, "=");
    }
}

