/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.target.Install;
import org.tizen.ncli.subcommands.target.InstallCLICommand;

@TizenSubCommand(name="install", usage="Install the application package to the target device.")
public class InstallCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-t", aliases={"--target"}, metaVar="<target>", usage="Specify the target where the Tizen package is installed.")
    private String target;
    @Option(name="-s", aliases={"--serial"}, metaVar="<serial>", usage="Specify the serial to install the package.")
    private String serial;
    @Option(name="-n", aliases={"--name"}, required=true, metaVar="<package file name>", usage="Specify the Tizen package file name (Required).")
    private String name;
    @Option(name="-r", aliases={"--resource"}, usage="Specify the resource file name to install.", hidden=true)
    private String res;

    @Override
    public int execute() {
        int result = -1;
        this.log.trace("Execute InstallCLI...");
        InstallCLICommand command = new InstallCLICommand();
        command.setWorkingDir(this.getRealWorkingPath());
        if (this.serial != null) {
            command.setTarget(this.serial);
        } else {
            command.setTargetByName(this.target);
        }
        command.setName(this.name);
        command.setResourceName(this.res);
        Install data = (Install)command.runCommand();
        if (data != null) {
            result = 0;
        }
        return result;
    }

    @Override
    public boolean needPrintTime() {
        return true;
    }
}

