/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createnative;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.tproject.ObjectFactory;
import org.tizen.common.core.application.tproject.Platform;
import org.tizen.common.core.application.tproject.Platforms;
import org.tizen.common.core.application.tproject.Tproject;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.file.DirectoryCopyHandlingCommand;
import org.tizen.common.core.command.prompter.FileHandlingOption;
import org.tizen.common.util.FileUtil;
import org.tizen.nativecommon.exception.TizenProcessFailureException;
import org.tizen.nativecommon.templateengine.TizenTemplateEngine;
import org.tizen.nativecommon.templateengine.build.AbstractProjectGenerator;
import org.tizen.nativecommon.templateengine.build.model.TargetModel;
import org.tizen.nativecommon.templateengine.model.TizenTemplate;
import org.tizen.nativecommon.templateengine.process.TizenProcessRunner;
import org.tizen.nativecommon.templateengine.util.TemplateUtil;
import org.tizen.nativecore.wizards.build.ExpressProjectGenerator;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.createnative.CreateNativeProjectCommandData;
import org.tizen.ncli.subcommands.createnative.NativeProjectInfo;
import org.tizen.ncli.subcommands.createweb.ProjectGenUtil;

public class CreateNativeProjectCommand
extends AbstractSubCommand<CreateNativeProjectCommandData> {
    public CreateNativeProjectCommandData data = new CreateNativeProjectCommandData();
    private static final String CREATE_NATIVE_PROJECT_TASK = "Create Native Project";
    private static final String FILENAME_PROJECT_DESCRIPTION = ".project";
    private static final String FILENAME_C_PROJECT_DESCRIPTION = ".cproject";

    public CreateNativeProjectCommandData getData() {
        return this.data;
    }

    @Override
    protected CreateNativeProjectCommandData call() {
        String exportMapFilePath;
        Map<NativeProjectInfo, String> nativeProjects = this.data.getTemplateList();
        if (nativeProjects == null || nativeProjects.size() == 0) {
            this.progressLog.error("No templates found");
            throw new UnexpectedException(2, "No templates found");
        }
        if (this.copyNativeProjectTemplate() == -1) {
            this.progressLog.error("Failed to create native project");
            throw new UnexpectedException(2, "Failed to create native project");
        }
        this.makeTizenDescription(this.data.getProfileName());
        String projectType = this.data.getProjectType();
        if (projectType != null && !projectType.equals("org.tizen.nativecore.buildArtefactType.sharedLib") && (exportMapFilePath = this.data.getDestTizenProjectExportMapFile()) != null && this.makeExportMapFile(exportMapFilePath) == -1) {
            this.progressLog.error("Failed to create export map file");
            throw new UnexpectedException(2, "Failed to create export map file");
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int makeExportMapFile(String exportMapFilePath) {
        int ret = 0;
        FileWriter fw = null;
        try {
            fw = new FileWriter(exportMapFilePath);
            fw.write("{\n");
            fw.write("\tglobal: main; _IO_*;\n");
            fw.write("\tlocal: *;\n");
            fw.write("};\n");
        }
        catch (IOException e) {
            ret = -1;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    ret = -1;
                }
            }
        }
        return ret;
    }

    private int copyNativeProjectTemplate() {
        String templateName = this.data.getTemplateName();
        String projectName = this.data.getProjectName();
        String profileName = this.data.getProfileName();
        String destDir = this.data.getOutputName();
        File destDirFile = new File(destDir);
        String templatePath = this.data.getTizenNativeTemplateRootPath(new NativeProjectInfo(templateName, null, profileName));
        if (templatePath == null) {
            this.progressLog.error(String.format("Cannot find '%s' template in '%s' profile", templateName, profileName));
            return -1;
        }
        File templatePathFile = new File(templatePath);
        if (templatePathFile == null || !templatePathFile.exists()) {
            this.progressLog.error(String.format("Cannot find '%s' template in '%s' profile", templateName, profileName));
            return -1;
        }
        if (!new File(templatePath + File.separator + "project" + File.separator + "project_def.prop").exists()) {
            this.progressLog.error(String.format("Cannot find '%s' file in '%s' template", "project_def.prop", templateName));
            return -1;
        }
        TizenTemplate template = new TizenTemplate(templatePathFile.getAbsolutePath(), projectName, destDirFile.getAbsolutePath());
        template.getValueStore().put("packageProfile", this.data.getBaseProfileName());
        template.getValueStore().put("profile", this.data.getBaseProfileName());
        template.getValueStore().put("platform", this.data.getProfileName());
        try {
            String[] profileNameSplit;
            if (!destDirFile.exists()) {
                try {
                    destDirFile.mkdir();
                }
                catch (Exception e) {
                    this.log.error("Unable to create directory" + destDirFile);
                }
            } else {
                this.progressLog.warn(String.format("'%s' already exists", destDir));
                return -1;
            }
            TizenTemplateEngine.createProject((TizenTemplate)template, (AbstractProjectGenerator)new NativeCLIProjectGenerator());
            String destBuildDir = destDir + File.separator + "Build";
            if (!new File(destBuildDir).exists() && (profileNameSplit = profileName.split("-")).length == 2) {
                String sdkPath;
                String buildpath;
                String path;
                ProfileInfo profileInfo;
                String profileBaseName = profileNameSplit[0];
                String profileVer = profileNameSplit[1];
                if (!profileBaseName.isEmpty() && !profileVer.isEmpty() && (profileInfo = InstallPathConfig.getProfileInfo((String)profileBaseName)) != null && (path = profileInfo.getPlatformPath(profileVer)) != null && !path.isEmpty() && new File(buildpath = (sdkPath = InstallPathConfig.getSDKPath()) + File.separator + CreateNativeProjectCommandData.TIZEN_NATIVE_RES_PROJECT_BUILD_PATH).exists()) {
                    CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
                    ArrayList<String> copySrcList = new ArrayList<String>();
                    ArrayList<String> copyDesList = new ArrayList<String>();
                    copySrcList.add(buildpath);
                    copyDesList.add(destBuildDir);
                    DirectoryCopyHandlingCommand dirCopyCmd = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
                    dirCopyCmd.setOverwriteOption(FileHandlingOption.OVERWRITE_ALL);
                    executor.execute(new Command[]{dirCopyCmd});
                }
            }
        }
        catch (TizenProcessFailureException e) {
            this.progressLog.error(String.format("Error occurred while creating '%s' template", templateName));
            this.log.error("Failed to create native project\n{}", (Object)e.getMessage());
            return -1;
        }
        return 0;
    }

    private void makeTizenDescription(String profileName) {
        ProfileInfo latestProfileInfo = InstallPathConfig.getLatestProfileInfo();
        ObjectFactory objFactory = new ObjectFactory();
        Tproject tProject = objFactory.createTproject();
        Platform platform = objFactory.createPlatform();
        Platforms platforms = objFactory.createPlatforms();
        if (latestProfileInfo != null) {
            platform.setName(profileName);
            platforms.getPlatform().add(platform);
            tProject.setPlatforms(platforms);
            File file = new File(this.data.getDestTizenProjectDescriptionFile());
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)tProject, file);
            }
            catch (JAXBException e) {
                this.progressLog.error("failed to create .tproject file");
                this.log.error("cannot marshal \n{}", (Object)e.getMessage());
            }
        }
    }

    class NativeCLIProjectGenerator
    extends ExpressProjectGenerator {
        public static final String PROJECTTYPE_APP = "org.tizen.nativecore.buildArtefactType.app";
        public static final String PROJECTTYPE_STATIC = "org.tizen.nativecore.buildArtefactType.staticLib";
        public static final String PROJECTTYPE_SHARED = "org.tizen.nativecore.buildArtefactType.sharedLib";
        private static final String PACKAGE_PREFIX_TEMPLATE_PROCESS = "org.tizen.nativecommon.templateengine.process";
        private static final String TEMPLATE_EMULATOR_TARGET = "\t\t\t\t\t\t\t\t\t<listOptionValue builtIn=\"false\" value=\"%s\"/>";
        private final String[] VALUESTORE_BUILD_APP = new String[]{"org.tizen.nativecore.config.sbi.gcc45.app.debug", "org.tizen.nativecore.config.sbi.gcc45.app.release"};
        private final String[] VALUESTORE_BUILD_SHARED = new String[]{"org.tizen.nativecore.config.sbi.gcc45.so.debug", "org.tizen.nativecore.config.sbi.gcc45.so.release"};
        private final String[] VALUESTORE_BUILD_STATIC = new String[]{"org.tizen.nativecore.config.sbi.gcc45.lib.debug", "org.tizen.nativecore.config.sbi.gcc45.lib.release"};
        private HashMap<String, String> BUILD_CONFIG_MAP = new HashMap();
        private final String[] FILENAME_BUILD_APP = new String[]{"app_debug", "release"};
        private final String[] FILENAME_SHARED_APP = new String[]{"shared_debug", "shared_release"};
        private final String[] FILENAME_STATIC_APP = new String[]{"static_debug", "static_release"};
        private final String DIR_APP = "Executables" + File.separator + "CoreApplicationTemplate";
        private final String DIR_SHARED = "Libraries" + File.separator + "CoreSimpleSharedLibraryTemplate";
        private final String DIR_STATIC = "Libraries" + File.separator + "CoreSimpleStaticLibraryTemplate";
        private final String CPROJECT_TEMPLATE_FILE = ".cproject";
        private final String PROJECT_TEMPLATE_FILE = ".project";
        private String cProjectTemplatePath = "";
        private String cProjectTemplateFilePath = "";
        private String projectTemplateFilePath = "";
        private ProjectGenUtil pg = new ProjectGenUtil();

        public void pressDefaultPostValueStore(Map<String, String> valueStore, TizenTemplate template) throws TizenProcessFailureException {
            TargetModel emulTarget = (TargetModel)template.getProperty("emulator_target");
            String emulTargetId = emulTarget.getId();
            valueStore.put("emulTarget", String.format(TEMPLATE_EMULATOR_TARGET, emulTargetId));
            valueStore.put("projectName", template.getProjectName());
            super.pressDefaultPostValueStore(valueStore, template);
        }

        public void createBuildFiles(Map<String, String> postValueStore, TizenTemplate template) {
            String projectType = (String)template.getProperty("project_type");
            CreateNativeProjectCommand.this.data.setProjectType(projectType);
            String projectPath = template.getProjectPath();
            this.setBuildConfigMap(projectType);
            String tempDescriptionPath = FileUtil.appendPath((String)projectPath, (String)".cprojecttemp");
            try {
                URL prjDesUrl;
                URL cPrjDesUrl = new File(this.cProjectTemplateFilePath).toURL();
                if (cPrjDesUrl != null) {
                    TemplateUtil.createReplaceableFile((URL)cPrjDesUrl, (String)tempDescriptionPath, this.BUILD_CONFIG_MAP);
                    TemplateUtil.createReplaceableFile((String)tempDescriptionPath, (String)FileUtil.appendPath((String)projectPath, (String)CreateNativeProjectCommand.FILENAME_C_PROJECT_DESCRIPTION), postValueStore);
                }
                if ((prjDesUrl = new File(this.projectTemplateFilePath).toURL()) != null) {
                    TemplateUtil.createReplaceableFile((URL)prjDesUrl, (String)FileUtil.appendPath((String)projectPath, (String)CreateNativeProjectCommand.FILENAME_PROJECT_DESCRIPTION), postValueStore);
                }
            }
            catch (IOException e) {
                CreateNativeProjectCommand.this.log.error("failed to crate build configuration files. \n{}", (Object)e.getMessage());
            }
            try {
                new File(tempDescriptionPath).delete();
            }
            catch (Exception e) {
                CreateNativeProjectCommand.this.log.error("Unable to delete file");
            }
        }

        private void setBuildConfigMap(String projectType) {
            String tempPath = this.pg.extractBuiltinJarFiles("templates" + File.separator + "Executables");
            if (tempPath == null) {
                CreateNativeProjectCommand.this.progressLog.error("No native template found !");
                return;
            }
            String temp = tempPath.substring(0, tempPath.lastIndexOf(File.separator));
            this.cProjectTemplatePath = temp.substring(0, temp.lastIndexOf(File.separator));
            if (projectType.equals(PROJECTTYPE_APP)) {
                this.readTemplateAndFillHashMap(this.VALUESTORE_BUILD_APP, this.FILENAME_BUILD_APP, this.cProjectTemplatePath + File.separator + this.DIR_APP);
                this.cProjectTemplateFilePath = this.cProjectTemplatePath + File.separator + this.DIR_APP + File.separator + CreateNativeProjectCommand.FILENAME_C_PROJECT_DESCRIPTION;
                this.projectTemplateFilePath = this.cProjectTemplatePath + File.separator + this.DIR_APP + File.separator + CreateNativeProjectCommand.FILENAME_PROJECT_DESCRIPTION;
            } else if (projectType.equals(PROJECTTYPE_SHARED)) {
                this.readTemplateAndFillHashMap(this.VALUESTORE_BUILD_SHARED, this.FILENAME_SHARED_APP, this.cProjectTemplatePath + File.separator + this.DIR_SHARED);
                this.cProjectTemplateFilePath = this.cProjectTemplatePath + File.separator + this.DIR_SHARED + File.separator + CreateNativeProjectCommand.FILENAME_C_PROJECT_DESCRIPTION;
                this.projectTemplateFilePath = this.cProjectTemplatePath + File.separator + this.DIR_SHARED + File.separator + CreateNativeProjectCommand.FILENAME_PROJECT_DESCRIPTION;
            } else if (projectType.equals(PROJECTTYPE_STATIC)) {
                this.readTemplateAndFillHashMap(this.VALUESTORE_BUILD_STATIC, this.FILENAME_STATIC_APP, this.cProjectTemplatePath + File.separator + this.DIR_STATIC);
                this.cProjectTemplateFilePath = this.cProjectTemplatePath + File.separator + this.DIR_STATIC + File.separator + CreateNativeProjectCommand.FILENAME_C_PROJECT_DESCRIPTION;
                this.projectTemplateFilePath = this.cProjectTemplatePath + File.separator + this.DIR_STATIC + File.separator + CreateNativeProjectCommand.FILENAME_PROJECT_DESCRIPTION;
            } else {
                CreateNativeProjectCommand.this.log.warn("unknwon project type : " + projectType);
            }
        }

        private void readTemplateAndFillHashMap(String[] valueStoreKey, String[] fileName, String parentPath) {
            String lastPath = null;
            try {
                for (int i = 0; i < valueStoreKey.length; ++i) {
                    lastPath = parentPath + File.separator + fileName[i];
                    File file = new File(lastPath);
                    String fileContent = FileUtil.readTextFile((File)file, (String)"UTF-8");
                    this.BUILD_CONFIG_MAP.put(valueStoreKey[i], fileContent);
                }
            }
            catch (Exception e) {
                CreateNativeProjectCommand.this.log.error("Error occurred during reading app/shared/static teamplate!\n{}", (Object)e.getMessage());
            }
        }

        public TizenProcessRunner getTemplateProcess(String templateId, TizenTemplate template) throws TizenProcessFailureException {
            String coreFrameworks = "SetDefaultCoreFrameworks";
            String processResolvedName = "";
            processResolvedName = "SetDefaultCoreFrameworks".equals(FileUtil.getFileExtension((String)templateId)) ? "org.tizen.nativecommon.templateengine.process.SetDefaultFrameworks" : "org.tizen.nativecommon.templateengine.process." + FileUtil.getFileExtension((String)templateId);
            ClassLoader cLoader = ClassLoader.getSystemClassLoader();
            TizenProcessRunner runner = null;
            try {
                Class<?> processClass = cLoader.loadClass(processResolvedName);
                runner = (TizenProcessRunner)processClass.newInstance();
            }
            catch (Exception e) {
                return null;
            }
            runner.setTemplate(template);
            return runner;
        }
    }
}

