/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createnative;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.util.FileUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.subcommands.createnative.NativeProjectInfo;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CreateNativeProjectCommandData {
    private static final String NATIVE_PROJECT_PATH = "samples" + File.separator + "Template" + File.separator + "Native";
    private static final String TIZEN_NATIVE_APP_TEMPLATE_FILE = "sample.xml";
    public static final String TIZEN_MANIFEST_FILE = "tizen-manifest.xml";
    public static final String TIZEN_PROJECT_DESCRIPTION_FILE = ".tproject";
    public static final String TIZEN_PROJECT_EXPORT_MAP_FILE = ".exportMap";
    public static final String TIZEN_PROJECT_FOLDER = "project";
    public static final String TIZEN_NATIVE_PROJECT_DEF_NAME = "project_def.prop";
    public static final String TIZEN_NATIVE_RES_PROJECT_BUILD_PATH = "tools" + File.separator + "ide" + File.separator + "resources" + File.separator + "native" + File.separator + "Build";
    public static final String DEFAULT_TEMPLATE_NAME = "basic_ui";
    public static final String DEFAULT_PROJECT_NAME = "basic_ui";
    public static final String DEFAULT_PROFILE_NAME = "mobile-3.0";
    public static final String DEFAULT_MOBILE_BASE_PROFILE_NAME = "mobile";
    public static final String DEFAULT_WEARABLE_BASE_PROFILE_NAME = "wearable";
    public static final String TAG_SLPPROPERTY = "slp-property";
    public static final String TAG_PROPERTYGROUP = "property-group";
    private String templateName = "basic_ui";
    private String projectName = "basic_ui";
    private String profileName = "mobile-3.0";
    private String baseProfileName = "mobile";
    private String outputName = "";
    private String projectType;
    public static List<String> fileNameArray = new ArrayList<String>();
    public static Map<NativeProjectInfo, String> nativeProjects = new HashMap<NativeProjectInfo, String>();

    CreateNativeProjectCommandData() {
        CreateNativeProjectCommandData.getTemplateListFromAllProfile();
    }

    public Map<NativeProjectInfo, String> getTemplateList() {
        return nativeProjects;
    }

    public static Map<NativeProjectInfo, String> getTemplateListFromAllProfile() {
        nativeProjects.clear();
        List pis = InstallPathConfig.getProfileInfos();
        for (ProfileInfo pi : pis) {
            CreateNativeProjectCommandData.getTemplateList(pi);
        }
        return nativeProjects;
    }

    public static Map<NativeProjectInfo, String> getTemplateList(ProfileInfo profile) {
        for (String version : profile.getVersions()) {
            String platformPath = profile.getPlatformPath(version);
            String platformName = profile.getPlatformName(version);
            CreateNativeProjectCommandData.appendNativeProject(platformPath, platformName);
        }
        return nativeProjects;
    }

    public static Element getElementFromTag(Element element, String tag) {
        NodeList subElements;
        if (element != null && (subElements = element.getElementsByTagName(tag)) != null && subElements.getLength() > 0) {
            return (Element)subElements.item(0);
        }
        return null;
    }

    public static void appendNativeProject(String platformPath, String platformName) {
        List fileArray = null;
        File root = new File(platformPath + File.separator + NATIVE_PROJECT_PATH);
        try {
            fileArray = FileUtil.findFiles((File)root, (String)TIZEN_NATIVE_APP_TEMPLATE_FILE, (boolean)true);
            for (File samplefile : fileArray) {
                String templateRootPath;
                String projectDefPath;
                File templateRootFile = samplefile.getParentFile();
                if (templateRootFile == null || !new File(projectDefPath = (templateRootPath = templateRootFile.getAbsolutePath()) + File.separatorChar + TIZEN_PROJECT_FOLDER + File.separatorChar + TIZEN_NATIVE_PROJECT_DEF_NAME).exists()) continue;
                Element elementRoot = XMLUtil.readXML((File)samplefile).getDocumentElement();
                Element slpPropertyElement = CreateNativeProjectCommandData.getElementFromTag(elementRoot, TAG_SLPPROPERTY);
                slpPropertyElement = CreateNativeProjectCommandData.getElementFromTag(slpPropertyElement, TAG_PROPERTYGROUP);
                String templateName = templateRootFile.getName();
                if (templateName == null) continue;
                nativeProjects.put(new NativeProjectInfo(templateName, null, platformName), templateRootFile.getAbsolutePath());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
        this.baseProfileName = profileName.contains(DEFAULT_MOBILE_BASE_PROFILE_NAME) ? DEFAULT_MOBILE_BASE_PROFILE_NAME : (profileName.contains(DEFAULT_WEARABLE_BASE_PROFILE_NAME) ? DEFAULT_WEARABLE_BASE_PROFILE_NAME : "");
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getBaseProfileName() {
        return this.baseProfileName;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getTizenNativeTemplateRootPath(NativeProjectInfo nativeProject) {
        return nativeProjects.get(nativeProject);
    }

    public String getTizenNativeProjectRootPath(NativeProjectInfo nativeProject) {
        return this.getTizenNativeTemplateRootPath(nativeProject) + File.separator + TIZEN_PROJECT_FOLDER;
    }

    public String getTizenNativeTemplateConfigFile(NativeProjectInfo nativeProject) {
        return this.getTizenNativeTemplateRootPath(nativeProject) + File.separator + TIZEN_NATIVE_APP_TEMPLATE_FILE;
    }

    public String getTizenNativeProjectConfigFile(NativeProjectInfo nativeProject) {
        return this.getTizenNativeTemplateRootPath(nativeProject) + File.separator + TIZEN_MANIFEST_FILE;
    }

    public String getDestTizenNativeProjectConfigFile() {
        return this.outputName + File.separator + TIZEN_MANIFEST_FILE;
    }

    public String getDestTizenProjectDescriptionFile() {
        return this.outputName + File.separator + TIZEN_PROJECT_DESCRIPTION_FILE;
    }

    public String getDestTizenProjectExportMapFile() {
        return this.outputName + File.separator + TIZEN_PROJECT_EXPORT_MAP_FILE;
    }
}

