/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createresource;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.subcommands.createresource.ResourceProjectInfo;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CreateResourceProjectCommandData {
    public static final String TIZEN_PROJECT_FOLDER = "project";
    public static final String TIZEN_RESOURCE_PROJECT_DEF_NAME = "project_def.prop";
    public static final String TIZEN_DESCRIPTION = "description.xml";
    public static final String IDE_PATH = "tools" + File.separator + "ide";
    public static final String TEMPLATE = "resources" + File.separator + "common" + File.separator + "template" + File.separator + "rpk_template";
    public static final String DEFAULT_TEMPLATE_NAME = "rpk_app";
    public static final String DEFAULT_PROJECT_NAME = "rpk_app";
    public static final String TAG_PLATFORM_LIST = "PlatformList";
    public static final String TAG_REQUIRED_VERSION = "RequiredVersion";
    private String templateName = "rpk_app";
    private String projectName = "rpk_app";
    private String outputName = "";
    private String projectType;
    public static List<String> fileNameArray = new ArrayList<String>();
    public static Map<ResourceProjectInfo, String> resourceProjects = new HashMap<ResourceProjectInfo, String>();

    CreateResourceProjectCommandData() {
        CreateResourceProjectCommandData.getTemplateListFromPackage();
    }

    public static File getTemplateDir() {
        String filePath = InstallPathConfig.getSDKPath();
        filePath = filePath + File.separator + IDE_PATH;
        File file = new File(filePath);
        File templateDir = new File(file, TEMPLATE);
        return templateDir;
    }

    public static boolean isValidVersion(String requiredVersion, String templateVersion) {
        if (requiredVersion == null || templateVersion == null) {
            return false;
        }
        String[] requiredVersionHelper = requiredVersion.split("[.]");
        if (requiredVersionHelper.length != 2) {
            return false;
        }
        int requiredVersionFirstPart = Integer.parseInt(requiredVersionHelper[0]);
        int requiredVersionSecondPart = Integer.parseInt(requiredVersionHelper[1]);
        String[] templateVersionHelper = templateVersion.split("[.]");
        if (templateVersionHelper.length != 2) {
            return false;
        }
        int templateVersionFirstPart = Integer.parseInt(templateVersionHelper[0]);
        int templateVersionSecondPart = Integer.parseInt(templateVersionHelper[1]);
        if (requiredVersionFirstPart > templateVersionFirstPart) {
            return false;
        }
        if (requiredVersionFirstPart < templateVersionFirstPart) {
            return true;
        }
        return requiredVersionSecondPart <= templateVersionSecondPart;
    }

    public static String getVersion(String version) {
        String[] versionHelper = version.split("-");
        if (versionHelper.length != 2) {
            return null;
        }
        return versionHelper[1];
    }

    public static String getRequiredVersion(String path) {
        File template = new File(path);
        if (!template.exists()) {
            return null;
        }
        File descriptionFile = new File(template, TIZEN_DESCRIPTION);
        if (!descriptionFile.exists()) {
            return null;
        }
        Element elementRoot = XMLUtil.readXML((File)descriptionFile).getDocumentElement();
        Element platformListElement = CreateResourceProjectCommandData.getElementFromTag(elementRoot, TAG_PLATFORM_LIST);
        String versionNumber = XMLUtil.getDOMValue((Element)platformListElement, (String)TAG_REQUIRED_VERSION);
        return versionNumber;
    }

    public static Map<ResourceProjectInfo, String> getTemplateListFromPackage() {
        File templateDir = CreateResourceProjectCommandData.getTemplateDir();
        if (templateDir == null) {
            return null;
        }
        File[] versions = templateDir.listFiles();
        if (versions == null) {
            return null;
        }
        for (File version : versions) {
            if (!version.isDirectory()) continue;
            String versionName = version.getName();
            String versionNumber = CreateResourceProjectCommandData.getVersion(versionName);
            File[] versionDirFileList = version.listFiles();
            if (versionDirFileList == null) {
                return null;
            }
            for (File versionDirFileListIndividual : versionDirFileList) {
                String requiredVersion;
                if (!versionDirFileListIndividual.isDirectory() || !CreateResourceProjectCommandData.isValidVersion(requiredVersion = CreateResourceProjectCommandData.getRequiredVersion(versionDirFileListIndividual.getAbsolutePath()), versionNumber)) continue;
                resourceProjects.put(new ResourceProjectInfo(versionDirFileListIndividual.getName(), null), versionDirFileListIndividual.getAbsolutePath());
            }
        }
        return resourceProjects;
    }

    public Map<ResourceProjectInfo, String> getTemplateList() {
        return resourceProjects;
    }

    public static Element getElementFromTag(Element element, String tag) {
        NodeList subElements;
        if (element != null && (subElements = element.getElementsByTagName(tag)) != null && subElements.getLength() > 0) {
            return (Element)subElements.item(0);
        }
        return null;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getTizenResourceTemplateRootPath(ResourceProjectInfo resourceProject) {
        if (resourceProjects.get(resourceProject) == null) {
            // empty if block
        }
        return resourceProjects.get(resourceProject);
    }

    public String getTizenResourceProjectRootPath(ResourceProjectInfo resourceProject) {
        return this.getTizenResourceTemplateRootPath(resourceProject) + File.separator + TIZEN_PROJECT_FOLDER;
    }
}

