/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.file.DirectoryCopyHandlingCommand;
import org.tizen.common.core.command.prompter.FileHandlingOption;
import org.tizen.common.core.command.zip.ZipCommand;
import org.tizen.common.core.command.zip.ZipExtrCommand;
import org.tizen.common.util.IOUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.build.buildnative.BuildInfo;
import org.tizen.ncli.subcommands.packages.NativeProject;
import org.tizen.ncli.subcommands.packages.PackageCLICommand;
import org.tizen.ncli.subcommands.packages.PackageCLICommandData;
import org.tizen.ncli.subcommands.packages.PackageNativeCLICommand;
import org.tizen.ncli.subcommands.packages.PackageNativeCLICommandData;
import org.tizen.ncli.subcommands.packages.PackageProject;
import org.tizen.ncli.subcommands.packages.ResourcePackageCLICommand;
import org.tizen.ncli.subcommands.packages.ResourcePackageCLICommandData;
import org.tizen.ncli.subcommands.packages.WebProject;
import org.tizen.ncli.subcommands.sign.SignCLICommand;
import org.tizen.ncli.util.DirectoryUtil;
import org.tizen.ncli.validate.ManifestSchemaValidator;
import org.tizen.tpklib.lib.zip.IZip;
import org.tizen.tpklib.lib.zip.ZipProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@TizenSubCommand(name="package", usage="Create an application package for Tizen.")
public class PackageCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MANIFEST_XSD_RPK = "manifest_rpk.xsd";
    private static final String EXCLUDE_LIB_PATH = "tools" + File.separator + "ide" + File.separator + "resources" + File.separator + "csharp" + File.separator + "exclude";
    @Option(name="-t", aliases={"--type"}, required=true, metaVar="{tpk|wgt|rpk}", usage="packaging type. (Required)")
    private String type;
    @Option(name="-s", aliases={"--sign"}, metaVar="<security profile>", usage="Specify the security profile name.")
    private String sign;
    @Option(name="-S", aliases={"--strip"}, metaVar="{on|off}", usage="Determine whether to strip the native binary.")
    private String strip;
    @Option(name="-o", aliases={"--output"}, metaVar="<output path>", usage="Specify the output file path.")
    private String outputPath;
    @Option(name="-r", aliases={"--reference"}, metaVar="<path>[;...]", usage="Reference prj paths (for HybridApp package).")
    private String[] referencePaths;
    @Option(name="-p", aliases={"--project"}, metaVar="<path>", usage="Project path.", hidden=true)
    private String projectPath;
    private File tempDir = null;

    private File getTempDir() {
        if (this.tempDir == null) {
            try {
                this.tempDir = DirectoryUtil.createTempDirectory();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.tempDir = null;
            }
        }
        return this.tempDir;
    }

    private void removeTempDir() {
        if (this.tempDir != null) {
            if (DirectoryUtil.deleteDirectory(this.tempDir)) {
                this.tempDir = null;
            } else {
                this.log.trace("Could not delete temp file: {}", (Object)this.tempDir);
            }
        }
    }

    protected void finalize() {
        this.removeTempDir();
    }

    private static boolean isHybridApp(File path) {
        if (!new File(path.toString() + "/tizen-manifest.xml").exists()) {
            return false;
        }
        return new File(path.toString() + "/config.xml").exists();
    }

    private static List<String> parseFilter(String src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ArrayList<String> filters = new ArrayList<String>();
        int len = src.length();
        char[] temp = new char[len];
        int idx = 0;
        boolean state = false;
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c == '\"') {
                if (!state) {
                    state = true;
                    continue;
                }
                state = false;
                continue;
            }
            if (!(state || c != ' ' && c != '\t' && c != '\r' && c != '\n')) {
                if (idx <= 0) continue;
                filters.add(new String(temp, 0, idx).trim());
                idx = 0;
                continue;
            }
            temp[idx++] = c;
        }
        if (idx > 0) {
            filters.add(new String(temp, 0, idx));
        }
        return filters.size() > 0 ? filters : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRepackageForWgt(File path, String outputPath, List<String> refPathList, String sign) {
        block65: {
            if (!path.getName().toLowerCase().endsWith(".wgt")) {
                this.log.trace("Invalid package file : {}", (Object)path);
                this.progressLog.info("Invalid package file : {}", (Object)path);
                return -1;
            }
            String ECONFNOTEXIST = "ERROR : config.xml File is not exist : ";
            String EHYBRIDMAINPKG = "ERROR : hybrid package only allow Web UI package as main package : ";
            String EHYBRIDREFPKG = "ERROR : hybrid package only allow native service/C# and widget package as reference package : ";
            String EHYBRIDREQNATIVE = "ERROR : hybrid package required native widget or native service package ";
            ArrayList<String> activeRefPathList = new ArrayList<String>();
            File tempDir = this.getTempDir();
            if (tempDir == null) {
                throw new UnexpectedException(2, "Cannot get temp directory.");
            }
            try {
                CommandLineExecutor executor;
                if (refPathList != null && !refPathList.isEmpty()) {
                    executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
                    int pkg_idx = 0;
                    for (String refPath : refPathList) {
                        File f = new File(refPath);
                        if (!f.exists()) {
                            this.log.trace(refPath.toString() + " is not exists");
                            this.log.trace("Current directory: " + this.currentWorkspacePath);
                            continue;
                        }
                        if (f.isDirectory()) {
                            this.progressLog.error("Not Supported.");
                            int n = 1;
                            return n;
                        }
                        if (!f.isFile()) continue;
                        String pktPath = tempDir.toString() + File.separator + f.getName() + "-" + ++pkg_idx;
                        if (!new File(pktPath).mkdir()) {
                            this.log.error("Unable to create directory");
                        }
                        activeRefPathList.add(pktPath);
                        ZipExtrCommand zipExtrCmd = new ZipExtrCommand(f.getAbsolutePath(), pktPath);
                        zipExtrCmd.setExcludes(new String[]{"signature*.xml", "author-signature*.xml"});
                        executor.execute(new Command[]{zipExtrCmd});
                    }
                }
                if (!activeRefPathList.isEmpty()) {
                    File outputFile;
                    executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
                    String rootPath = null;
                    String wgtPath = null;
                    rootPath = tempDir.toString() + "/.wgt";
                    wgtPath = rootPath + "/res/wgt";
                    File wgtFile = new File(wgtPath);
                    if (!wgtFile.exists() && !wgtFile.mkdirs()) {
                        this.log.error("Unable to create directory");
                    }
                    ZipExtrCommand zipExtrCmd = new ZipExtrCommand(path.getAbsolutePath(), wgtPath);
                    zipExtrCmd.setExcludes(new String[]{"signature*.xml", "author-signature*.xml", "res/wgt/signature*.xml", "res/wgt/author-signature*.xml"});
                    executor.execute(new Command[]{zipExtrCmd});
                    String configPath = wgtPath + File.separator + "config.xml";
                    File configFile = new File(configPath);
                    if (!configFile.exists()) {
                        this.progressLog.error(ECONFNOTEXIST + path.toString());
                        int n = 1;
                        return n;
                    }
                    Document configDoc = WebProject.getDocument(configPath);
                    String manifestPath = wgtPath + File.separator + "tizen-manifest.xml";
                    File manifestFile = new File(manifestPath);
                    if (manifestFile.exists() || !WebProject.isWebUIProject(configDoc) && !WebProject.isWebWidgetProject(configDoc)) {
                        this.progressLog.error(EHYBRIDMAINPKG + path.toString());
                        int n = 1;
                        return n;
                    }
                    ArrayList<File> tizenManifestList = new ArrayList<File>();
                    ArrayList<String> copySrcList = new ArrayList<String>();
                    ArrayList<String> copyDesList = new ArrayList<String>();
                    for (String refPath : activeRefPathList) {
                        File refDir = new File(refPath);
                        if (PackageCLI.isHybridApp(refDir)) {
                            this.progressLog.error(EHYBRIDREFPKG + refDir.getName());
                            int n = 1;
                            return n;
                        }
                        File tizenManifest = new File(refPath, "tizen-manifest.xml");
                        if (tizenManifest.exists()) {
                            Document tizenManifestDoc = XMLUtil.readXML((File)tizenManifest);
                            if (tizenManifestDoc == null || !NativeProject.isStandalone(tizenManifestDoc) || !NativeProject.isWidgetAppLication(tizenManifestDoc) && !NativeProject.isServiceAppLication(tizenManifestDoc) && !NativeProject.isDotnetApplication(tizenManifestDoc)) {
                                this.progressLog.error(EHYBRIDREFPKG + refDir.getName());
                                int n = 2;
                                return n;
                            }
                            copySrcList.add(refPath);
                            tizenManifestList.add(tizenManifest);
                            copyDesList.add(rootPath);
                            continue;
                        }
                        File config = new File(refPath, "config.xml");
                        if (!config.exists()) {
                            this.progressLog.error(EHYBRIDREFPKG + refDir.getName());
                            int n = 2;
                            return n;
                        }
                        Document cDoc = WebProject.getDocument(config.toString());
                        if (WebProject.isWebWidgetProject(cDoc)) {
                            copySrcList.add(refPath + File.separator + "widget");
                            WebProject.addWidgetToApp(configDoc, cDoc);
                            copyDesList.add(wgtPath + File.separator + "widget");
                            continue;
                        }
                        this.progressLog.error(EHYBRIDREFPKG + refDir.getName());
                        int n = 2;
                        return n;
                    }
                    if (tizenManifestList.isEmpty()) {
                        this.progressLog.error(EHYBRIDREQNATIVE);
                        int n = 2;
                        return n;
                    }
                    File trustAnchorDir = new File(wgtPath + File.separator + ".trust-anchor");
                    if (trustAnchorDir.exists() && trustAnchorDir.isDirectory()) {
                        copySrcList.add(wgtPath + File.separator + ".trust-anchor");
                        copyDesList.add(rootPath + File.separator + "res" + File.separator + ".trust-anchor");
                    }
                    Document manifestDoc = XMLUtil.mergeXML(tizenManifestList);
                    DirectoryCopyHandlingCommand dirCopyCmd = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
                    dirCopyCmd.setOverwriteOption(FileHandlingOption.OVERWRITE_ALL);
                    dirCopyCmd.setExcludes(new String[]{"tizen-manifest.xml", "res/wgt/config.xml"});
                    executor.execute(new Command[]{dirCopyCmd});
                    File configE = new File(rootPath + File.separator + "res" + File.separator + "wgt" + File.separator + "config.xml");
                    File manifestE = new File(rootPath, "tizen-manifest.xml");
                    if (configE.exists() && !configE.delete()) {
                        this.log.error("Unable to delete");
                    }
                    if (manifestE.exists() && !manifestE.delete()) {
                        this.log.error("Unable to delete");
                    }
                    String packageName = XMLUtil.getDOMValueNS((Document)configDoc, (String)"/:widget/tizen:application/@package");
                    String version = XMLUtil.getDOMValueNS((Document)configDoc, (String)"/:widget/@version");
                    XMLUtil.setDOMValueNS((Document)manifestDoc, (String)"/:manifest/@package", (String)packageName);
                    XMLUtil.setDOMValueNS((Document)manifestDoc, (String)"/:manifest/@version", (String)version);
                    NodeList serviceList = XMLUtil.getDOMNodesNS((Document)manifestDoc, (String)"/:manifest/:service-application");
                    for (int i = 0; i < serviceList.getLength(); ++i) {
                        Node node = serviceList.item(i);
                        if (!(node instanceof Element)) continue;
                        String appid = ((Element)node).getAttribute("exec");
                        ((Element)node).setAttribute("appid", packageName + "." + appid);
                    }
                    NodeList widgetList = XMLUtil.getDOMNodesNS((Document)manifestDoc, (String)"/:manifest/:widget-application");
                    for (int i = 0; i < widgetList.getLength(); ++i) {
                        Node node = widgetList.item(i);
                        if (!(node instanceof Element)) continue;
                        String appid = ((Element)node).getAttribute("exec");
                        ((Element)node).setAttribute("appid", packageName + "." + appid);
                    }
                    WebProject.genWidgetConfig(configDoc, wgtPath);
                    NodeList privilegeList = XMLUtil.getDOMNodesNS((Document)manifestDoc, (String)"/:manifest/:privileges/:privilege");
                    NodeList featureList = XMLUtil.getDOMNodesNS((Document)manifestDoc, (String)"/:manifest/:feature");
                    Node configRoot = XMLUtil.getDOMNodeNS((Document)configDoc, (String)"/:widget");
                    if (configRoot != null) {
                        NodeList configFeatures = XMLUtil.getDOMNodesNS((Document)configDoc, (String)"/:widget/:feature");
                        Node lastFeature = null;
                        if (configFeatures != null && configFeatures.getLength() > 0) {
                            lastFeature = configFeatures.item(configFeatures.getLength() - 1);
                        }
                        for (int i = 0; i < featureList.getLength(); ++i) {
                            Node node = featureList.item(i);
                            if (!(node instanceof Element)) continue;
                            String name = ((Element)node).getAttribute("name");
                            Element elm = configDoc.createElement("feature");
                            elm.setAttribute("name", name);
                            if (lastFeature == null) {
                                configRoot.appendChild(elm);
                                continue;
                            }
                            configRoot.insertBefore(elm, lastFeature);
                        }
                        NodeList configPrivileges = XMLUtil.getDOMNodesNS((Document)configDoc, (String)"/:widget/tizen:privilege");
                        Node lastPrivilege = null;
                        if (configPrivileges != null && configPrivileges.getLength() > 0) {
                            lastPrivilege = configPrivileges.item(configPrivileges.getLength() - 1);
                        }
                        for (int i = 0; i < privilegeList.getLength(); ++i) {
                            Node node = privilegeList.item(i);
                            if (!(node instanceof Element)) continue;
                            String priv = ((Element)node).getTextContent();
                            Element elm = configDoc.createElement("tizen:privilege");
                            elm.setAttribute("name", priv);
                            if (lastPrivilege == null) {
                                configRoot.appendChild(elm);
                                continue;
                            }
                            configRoot.insertBefore(elm, lastPrivilege);
                        }
                    }
                    int useSystemCerts = -1;
                    String systemCert = null;
                    Node configTrustAnchorNode = XMLUtil.getDOMNodeNS((Document)configDoc, (String)"/:widget/tizen:trust-anchor");
                    if (configTrustAnchorNode != null) {
                        systemCert = ((Element)configTrustAnchorNode).getAttribute("use-system-certs");
                        useSystemCerts = systemCert.equals("false") ? 0 : 1;
                        configTrustAnchorNode.getParentNode().removeChild(configTrustAnchorNode);
                    }
                    NodeList manifestTrustAnchorNodes = XMLUtil.getDOMNodesNS((Document)manifestDoc, (String)"/:manifest/:trust-anchor");
                    Node node = null;
                    for (int i = 0; i < manifestTrustAnchorNodes.getLength(); ++i) {
                        node = manifestTrustAnchorNodes.item(i);
                        systemCert = ((Element)node).getAttribute("use-system-certs");
                        if (systemCert.equals("false")) {
                            useSystemCerts = 0;
                        } else if (useSystemCerts == -1) {
                            useSystemCerts = 1;
                        }
                        node.getParentNode().removeChild(node);
                    }
                    if (useSystemCerts != -1) {
                        systemCert = useSystemCerts == 0 ? "false" : "true";
                        Element manifestTrustAnchor = manifestDoc.createElement("trust-anchor");
                        if (manifestTrustAnchor == null) {
                            this.progressLog.error("Merge config.xml failed: Cannot create hybrid package.");
                            this.log.error("Merge config.xml failed: Cannot create hybrid package.");
                            this.log.error("    creating merged trust-anchor element failed.");
                            int priv = 1;
                            return priv;
                        }
                        manifestTrustAnchor.setAttribute("use-system-certs", systemCert);
                        Node manifestNode = XMLUtil.getDOMNodeT((Document)manifestDoc, (String[])new String[]{"manifest"});
                        if (manifestNode == null) {
                            this.progressLog.error("Merge tizen-manifest.xml failed: Cannot create hybrid package.");
                            this.log.error("Merge tizen-manifest.xml failed: Cannot create hybrid package.");
                            this.log.error("    replacing trust-anchor element failed.");
                            int elm = 1;
                            return elm;
                        }
                        manifestNode.appendChild(manifestTrustAnchor);
                        Element configTrustAnchor = configDoc.createElement("tizen:trust-anchor");
                        if (configTrustAnchor == null) {
                            this.progressLog.error("Merge config.xml failed: Cannot create hybrid package.");
                            this.log.error("Merge config.xml failed: Cannot create hybrid package.");
                            this.log.error("    creating merged trust-anchor element failed.");
                            int n = 1;
                            return n;
                        }
                        configTrustAnchor.setAttribute("use-system-certs", systemCert);
                        Node configNode = XMLUtil.getDOMNodeT((Document)configDoc, (String[])new String[]{"widget"});
                        if (configNode == null) {
                            this.progressLog.error("Merge config.xml failed: Cannot create hybrid package.");
                            this.log.error("Merge config.xml failed: Cannot create hybrid package.");
                            this.log.error("    replacing trust-anchor element failed.");
                            int n = 1;
                            return n;
                        }
                        configNode.appendChild(configTrustAnchor);
                    }
                    XMLUtil.writeToFile((Document)manifestDoc, (String)(rootPath + "/tizen-manifest.xml"));
                    XMLUtil.writeToFile((Document)configDoc, (String)(rootPath + "/config.xml"));
                    SignCLICommand signCmd = new SignCLICommand();
                    File rootFile = new File(rootPath);
                    signCmd.setWorkingDir(rootFile);
                    if (sign != null && !sign.isEmpty()) {
                        signCmd.setProfileName(sign);
                    } else {
                        signCmd.setUseDefaultCertificate(true);
                    }
                    signCmd.runCommand();
                    File tempFile = new File(rootFile, ".manifest.tmp");
                    if (tempFile.exists()) {
                        tempFile.delete();
                    }
                    if ((outputFile = new File(outputPath)).isDirectory()) {
                        outputFile = new File(outputPath + File.separator + path.getName());
                    }
                    if (outputFile.exists()) {
                        outputFile.delete();
                    }
                    ZipCommand zipCmd = new ZipCommand(rootPath, outputFile.getAbsolutePath());
                    zipCmd.setExcludes(new String[]{".manifest.tmp", "res/wgt/.trust-anchor"});
                    executor.execute(new Command[]{zipCmd});
                    break block65;
                }
                this.log.trace("Re-packaging wgt file {}", (Object)path.toString());
                executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
                ZipExtrCommand zipExtrCmd = new ZipExtrCommand(path.getAbsolutePath(), tempDir.toString());
                executor.execute(new Command[]{zipExtrCmd});
                SignCLICommand signCmd = new SignCLICommand();
                signCmd.setWorkingDir(tempDir);
                if (sign != null && !sign.isEmpty()) {
                    signCmd.setProfileName(sign);
                } else {
                    signCmd.setUseDefaultCertificate(true);
                }
                signCmd.runCommand();
                File pkgPath = new File(outputPath + File.separator + path.getName());
                if (pkgPath.exists()) {
                    pkgPath.delete();
                }
                ZipCommand zipCmd = new ZipCommand(tempDir.toString(), pkgPath.getAbsolutePath());
                zipCmd.setExcludes(new String[]{".manifest.tmp"});
                executor.execute(new Command[]{zipCmd});
            }
            catch (Exception e) {
                this.log.trace("exception occured" + e.getMessage());
            }
            finally {
                this.removeTempDir();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRepackageForTpk(File path, String outputPath, List<String> refPathList, String sign) {
        block52: {
            if (!path.getName().toLowerCase().endsWith(".tpk")) {
                this.log.trace("Invalid package file : {}", (Object)path);
                this.progressLog.info("Invalid package file : {}", (Object)path);
                return -1;
            }
            File tempDir = this.getTempDir();
            if (tempDir == null) {
                throw new UnexpectedException(2, "Not Supported.");
            }
            try {
                CommandLineExecutor executor;
                ArrayList<AbstractMap.SimpleEntry<String, String>> activeRefPathList = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                if (refPathList != null && !refPathList.isEmpty()) {
                    executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
                    int pkg_idx = 0;
                    for (String refPath : refPathList) {
                        File f = new File(refPath);
                        if (!f.exists()) {
                            this.log.trace(refPath.toString() + " is not exists");
                            this.log.trace("Current directory: " + this.currentWorkspacePath);
                            continue;
                        }
                        String filename = f.getName();
                        if (filename.substring(filename.length() - 4).equalsIgnoreCase(".tpk") || filename.substring(filename.length() - 4).equalsIgnoreCase(".zip")) {
                            String string = tempDir.toString() + File.separator + f.getName() + "-" + ++pkg_idx;
                            if (!new File(string).mkdir()) {
                                this.log.error("Unable to create directory");
                            }
                            activeRefPathList.add(new AbstractMap.SimpleEntry<String, String>(string, ".tpk"));
                            ZipExtrCommand zipExtrCmd = new ZipExtrCommand(f.getAbsolutePath(), string);
                            zipExtrCmd.setExcludes(new String[]{"signature*.xml", "author-signature*.xml"});
                            executor.execute(new Command[]{zipExtrCmd});
                            continue;
                        }
                        if (!filename.substring(filename.length() - 3).equalsIgnoreCase(".so")) continue;
                        String string = tempDir.toString() + File.separator + f.getName();
                        if (!new File(string).mkdir()) {
                            this.log.error("Unable to create directory");
                        }
                        activeRefPathList.add(new AbstractMap.SimpleEntry<String, String>(string, ".tpk"));
                        ArrayList<String> copySrcList = new ArrayList<String>();
                        ArrayList<String> copyDesList = new ArrayList<String>();
                        copySrcList.add(f.toString());
                        copyDesList.add(string + "/lib/" + f.getName());
                        DirectoryCopyHandlingCommand directoryCopyHandlingCommand = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
                        directoryCopyHandlingCommand.setOverwriteOption(FileHandlingOption.OVERWRITE_ALL);
                        executor.execute(new Command[]{directoryCopyHandlingCommand});
                    }
                }
                if (!activeRefPathList.isEmpty()) {
                    File outputFile;
                    executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
                    String rootPath = null;
                    String pktPath = null;
                    if (path.isFile()) {
                        rootPath = tempDir.toString() + File.separator + ".tpk";
                        if (!new File(rootPath).mkdirs()) {
                            this.log.error("Unable to create directory");
                        }
                        if (!new File(pktPath = tempDir.toString() + File.separator + path.getName()).mkdir()) {
                            this.log.error("Unable to create directory");
                        }
                    } else {
                        if (path.isDirectory()) {
                            this.progressLog.error("Native multi-packaging with project directory is not Supported.");
                            int zipExtrCmd = 1;
                            return zipExtrCmd;
                        }
                        this.progressLog.error("Unexpected file.");
                        int zipExtrCmd = 1;
                        return zipExtrCmd;
                    }
                    ZipExtrCommand zipExtrCmd = new ZipExtrCommand(path.getAbsolutePath(), pktPath);
                    zipExtrCmd.setExcludes(new String[]{"signature*.xml", "author-signature*.xml", "res/wgt/signature*.xml", "res/wgt/author-signature*.xml"});
                    executor.execute(new Command[]{zipExtrCmd});
                    ArrayList<String> copySrcList = new ArrayList<String>();
                    ArrayList<String> copyDesList = new ArrayList<String>();
                    copySrcList.add(pktPath);
                    copyDesList.add(rootPath);
                    for (AbstractMap.SimpleEntry simpleEntry : activeRefPathList) {
                        copySrcList.add((String)simpleEntry.getKey());
                        copyDesList.add(tempDir.toString() + File.separator + (String)simpleEntry.getValue());
                    }
                    DirectoryCopyHandlingCommand dirCopyCmd = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
                    dirCopyCmd.setOverwriteOption(FileHandlingOption.OVERWRITE_ALL);
                    dirCopyCmd.setExcludes(new String[]{"tizen-manifest.xml"});
                    executor.execute(new Command[]{dirCopyCmd});
                    ArrayList<File> arrayList = new ArrayList<File>();
                    File f0 = new File(pktPath + "/tizen-manifest.xml");
                    if (f0.exists()) {
                        arrayList.add(f0);
                    }
                    for (AbstractMap.SimpleEntry simpleEntry : activeRefPathList) {
                        File f = new File((String)simpleEntry.getKey() + "/tizen-manifest.xml");
                        if (!f.exists()) continue;
                        arrayList.add(f);
                    }
                    Document manifestDoc = XMLUtil.mergeXML(arrayList);
                    NodeList nodeList = XMLUtil.getDOMNodesT((Document)manifestDoc, (String[])new String[]{"manifest", "trust-anchor"});
                    if (nodeList == null) {
                        this.progressLog.error("Merge tizen-manifest.xml failed: Cannot create native multi-package.");
                        this.log.error("Merge tizen-manifest.xml failed: Cannot create native multi-package.");
                        this.log.error("    getting trust-anchor element failed.");
                        int f = 1;
                        return f;
                    }
                    if (nodeList.getLength() != 0) {
                        Node node = null;
                        String systemCerts = null;
                        boolean useSystemCerts = true;
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            node = nodeList.item(i);
                            systemCerts = ((Element)node).getAttribute("use-system-certs");
                            if (systemCerts.equals("false")) {
                                useSystemCerts = false;
                            }
                            node.getParentNode().removeChild(node);
                        }
                        Element trustAnchor = manifestDoc.createElement("trust-anchor");
                        if (trustAnchor == null) {
                            this.progressLog.error("Merge tizen-manifest.xml failed: Cannot create native multi-package.");
                            this.log.error("Merge tizen-manifest.xml failed: Cannot create native multi-package.");
                            this.log.error("    creating merged trust-anchor element failed.");
                            int n = 1;
                            return n;
                        }
                        if (useSystemCerts) {
                            trustAnchor.setAttribute("use-system-certs", "true");
                        } else {
                            trustAnchor.setAttribute("use-system-certs", "false");
                        }
                        Node manifestNode = XMLUtil.getDOMNodeT((Document)manifestDoc, (String[])new String[]{"manifest"});
                        if (manifestNode == null) {
                            this.progressLog.error("Merge tizen-manifest.xml failed: Cannot create native multi-package.");
                            this.log.error("Merge tizen-manifest.xml failed: Cannot create native multi-package.");
                            this.log.error("    replacing trust-anchor element failed.");
                            int n = 1;
                            return n;
                        }
                        manifestNode.appendChild(trustAnchor);
                    }
                    XMLUtil.writeToFile((Document)manifestDoc, (String)(rootPath + "/tizen-manifest.xml"));
                    File rootFile = new File(rootPath);
                    SignCLICommand signCmd = new SignCLICommand();
                    signCmd.setWorkingDir(rootFile);
                    if (sign != null && !sign.isEmpty()) {
                        signCmd.setProfileName(sign);
                    } else {
                        signCmd.setUseDefaultCertificate(true);
                    }
                    signCmd.runCommand();
                    File tempFile = new File(rootFile, ".manifest.tmp");
                    if (tempFile.exists() && !tempFile.delete()) {
                        this.log.error("Unable to delete file");
                    }
                    if ((outputFile = new File(outputPath)).isDirectory()) {
                        outputFile = new File(outputPath + File.separator + path.getName());
                    }
                    if (outputFile.exists() && !outputFile.delete()) {
                        this.log.error("Unable to delete file");
                    }
                    File f = null;
                    try {
                        File[] paths;
                        f = new File(rootPath + "/bin");
                        if (f.exists() && (paths = f.listFiles()) != null) {
                            for (File fpath : paths) {
                                this.log.trace("set perm: " + fpath.toString());
                                fpath.setExecutable(true);
                            }
                        }
                        if ((f = new File(rootPath + "/lib")).exists() && (paths = f.listFiles()) != null) {
                            for (File fpath : paths) {
                                this.log.trace("set perm: " + fpath.toString());
                                fpath.setExecutable(true);
                            }
                        }
                        IZip zip = ZipProvider.getZipInstance();
                        zip.setOutputStream((OutputStream)System.out);
                        if (!zip.zipping(new File(rootPath), outputFile.getAbsolutePath(), 493)) {
                            this.log.trace("Zipping... Fail\n");
                            this.progressLog.info("Package( " + outputFile.getAbsolutePath() + " ) is not created.");
                            int n = 1;
                            return n;
                        }
                        this.log.trace("Zipping... OK\n");
                        this.progressLog.info("Package( " + outputFile.getAbsolutePath() + " ) is created successfully.");
                        break block52;
                    }
                    catch (Exception e) {
                        this.log.trace("Zipping... Fail\n");
                        this.progressLog.info("Package( " + outputFile.getAbsolutePath() + " ) is not created.");
                        int n = 1;
                        return n;
                    }
                }
                this.log.trace("Re-packaging file {}", (Object)path.toString());
                executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
                ZipExtrCommand zipExtrCmd = new ZipExtrCommand(path.getAbsolutePath(), tempDir.toString());
                executor.execute(new Command[]{zipExtrCmd});
                SignCLICommand signCmd = new SignCLICommand();
                signCmd.setWorkingDir(tempDir);
                if (sign != null && !sign.isEmpty()) {
                    signCmd.setProfileName(sign);
                } else {
                    signCmd.setUseDefaultCertificate(true);
                }
                signCmd.runCommand();
                File pkgPath = new File(outputPath + File.separator + path.getName());
                if (pkgPath.exists()) {
                    pkgPath.delete();
                }
                ZipCommand zipCmd = new ZipCommand(tempDir.toString(), pkgPath.getAbsolutePath());
                zipCmd.setExcludes(new String[]{".manifest.tmp"});
                executor.execute(new Command[]{zipCmd});
            }
            catch (Exception e) {
                this.log.trace("exception occured" + e.getMessage());
            }
            finally {
                this.removeTempDir();
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doPackageForWgt(File path, String projectPath, String outputPath, List<String> refPathList, String sign) {
        PackageCLICommandData data;
        if (path.isFile()) {
            return this.doRepackageForWgt(path, outputPath, refPathList, sign);
        }
        if (!path.isDirectory()) return 1;
        PackageCLICommand packageCommand = new PackageCLICommand();
        packageCommand.setWorkingDir(path);
        packageCommand.setProjectPath(projectPath);
        packageCommand.setProfileName(sign);
        packageCommand.setReferencePaths(refPathList);
        if (outputPath != null && !outputPath.isEmpty()) {
            packageCommand.setOutputPath(outputPath);
        }
        if (null != (data = (PackageCLICommandData)packageCommand.runCommand())) {
            String wgtOutPath = data.getWgtPath();
            if (null == wgtOutPath) return 0;
            this.progressLog.info("Package File Location: {}", (Object)wgtOutPath);
            return 0;
        } else {
            this.progressLog.info("error occured on packaging.");
            return 1;
        }
    }

    private int doPackageForCSharpTpk(File path, String projPath, String outputPath, List<String> refPathList, String sign, String buildConfig) {
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        String packagePath = path.getPath() + "/packaging";
        File packageDir = new File(packagePath);
        String packageBinDir = packagePath + "/bin";
        ArrayList<String> copySrcList = new ArrayList<String>();
        ArrayList<String> copyDesList = new ArrayList<String>();
        try {
            if (!packageDir.mkdir()) {
                this.log.error("Unable to make directory");
            }
            if (!new File(packageBinDir).mkdir()) {
                this.log.error("Unable to make directory");
            }
        }
        catch (Exception e) {
            throw new UnexpectedException(2, "mkdir failed");
        }
        Document tizenManifestDoc = null;
        try {
            tizenManifestDoc = XMLUtil.readXML((File)new File(projPath, "tizen-manifest.xml"));
        }
        catch (Exception e) {
            throw new UnexpectedException(2, "Cannot read the manifest file.");
        }
        String exeName = NativeProject.getArtifactName(tizenManifestDoc);
        if (exeName == null) {
            throw new UnexpectedException(2, "Cannot get the artifact name from manifest file.");
        }
        String pdbName = exeName.replace(".exe", ".pdb");
        String pkgName = exeName.replace(".exe", ".tpk");
        copySrcList.add(path + File.separator + exeName);
        copyDesList.add(packageBinDir + File.separator + exeName);
        if ("Debug".equals(buildConfig)) {
            copySrcList.add(path + File.separator + pdbName);
            copyDesList.add(packageBinDir + File.separator + pdbName);
        }
        copySrcList.add(projPath + "/res");
        copyDesList.add(packagePath + "/res");
        copySrcList.add(projPath + "/shared");
        copyDesList.add(packagePath + "/shared");
        copySrcList.add(projPath + "/lib");
        copyDesList.add(packagePath + "/lib");
        copySrcList.add(projPath + "/tizen-manifest.xml");
        copyDesList.add(packagePath + "/tizen-manifest.xml");
        ArrayList<String> excludeList = this.getExcludeLibLists();
        if (excludeList == null) {
            excludeList = new ArrayList();
        }
        excludeList.add(exeName);
        excludeList.add(pdbName);
        excludeList.add(pkgName);
        excludeList.add("build.info");
        excludeList.add("packaging");
        String[] libList = path.list();
        for (int i = 0; i < libList.length; ++i) {
            if (excludeList.contains(libList[i])) continue;
            copySrcList.add(path.getPath() + File.separator + libList[i]);
            copyDesList.add(packagePath + "/lib/" + libList[i]);
        }
        DirectoryCopyHandlingCommand dirCopyCmd = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
        dirCopyCmd.setOverwriteOption(FileHandlingOption.OVERWRITE_ALL);
        executor.execute(new Command[]{dirCopyCmd});
        SignCLICommand signCmd = new SignCLICommand();
        signCmd.setWorkingDir(packageDir);
        if (sign != null && !sign.isEmpty()) {
            signCmd.setProfileName(sign);
        } else {
            signCmd.setUseDefaultCertificate(true);
        }
        signCmd.runCommand();
        if (outputPath != null && !outputPath.isEmpty()) {
            String realoutputPath = outputPath.startsWith(".") ? projPath + File.separator + outputPath : outputPath;
            this.log.debug("Output Path: " + realoutputPath.toString());
            path = new File(realoutputPath);
        }
        File pkgPath = null;
        try {
            pkgPath = new File(path.getAbsolutePath() + File.separator + pkgName);
            if (pkgPath.exists() && !pkgPath.delete()) {
                this.log.error("Unable to delete");
            }
        }
        catch (Exception e) {
            throw new UnexpectedException(2, "mkdir failed");
        }
        ZipCommand zipCmd = new ZipCommand(packagePath, pkgPath.getAbsolutePath());
        zipCmd.setExcludes(new String[]{".manifest.tmp"});
        executor.execute(new Command[]{zipCmd});
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getExcludeLibLists() {
        ArrayList<String> excludeLibList = new ArrayList<String>();
        String sdkPath = InstallPathConfig.getSDKPath();
        if (sdkPath == null) {
            this.log.debug("Cannot get SDKPath for csharp packaging.");
            return null;
        }
        String excludePath = sdkPath + File.separator + EXCLUDE_LIB_PATH;
        File libListFiles = new File(excludePath);
        String[] files = libListFiles.list();
        if (files == null) {
            this.log.debug("Cannot find the exclude library list files.");
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            BufferedReader in = null;
            try {
                String s;
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(excludePath + File.separator + files[i]), "UTF-8");
                in = new BufferedReader(isr);
                while ((s = in.readLine()) != null) {
                    excludeLibList.add(s);
                }
                continue;
            }
            catch (IOException e) {
                this.log.debug("IOException while using input stream." + files[i]);
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.log.debug("IOException while closing input stream." + files[i]);
                    }
                }
            }
        }
        return excludeLibList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doPackageForTpk(File path, String projPath, String outputPath, List<String> refPathList, String sign) {
        PackageNativeCLICommandData nativeData;
        String exclude;
        List<String> temp;
        if (path.isFile()) {
            return this.doRepackageForTpk(path, outputPath, refPathList, sign);
        }
        if (!path.isDirectory()) return 1;
        BuildInfo buildInfo = PackageProject.getBuildInfo(path.getPath(), this.log);
        if (buildInfo == null || buildInfo.getProjectType() == null) {
            this.log.warn("Packaging error : Cannot find build information. \"build.info\" file does not exist.");
        } else if (buildInfo.getProjectType().equals("dotnet")) {
            return this.doPackageForCSharpTpk(path, buildInfo.getProjectPath(), outputPath, refPathList, sign, buildInfo.getBuildConfig());
        }
        List<String> resExclude = null;
        HashMap<String, String> resInclude = null;
        File projectManifestFile = new File(projPath, "tizen-manifest.xml");
        if (!projectManifestFile.exists()) {
            this.log.trace("tizen-manifest.xml does not exist");
            this.log.trace("The entered path : " + path.toString());
            this.progressLog.info("Cannot provide a package function to this project");
            return 1;
        }
        File projectDefFile = new File(projPath, "project_def.prop");
        if (!projectDefFile.exists()) {
            this.log.trace("project_def.prop does not exist");
            this.log.trace("The entered path : " + path.toString());
            return 0;
        }
        Properties prop = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(projectDefFile);
            prop.load(inputStream);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{inputStream});
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        String include = prop.getProperty("USER_RES_INCLUDE");
        if (include != null && !include.isEmpty() && (temp = PackageCLI.parseFilter(include)) != null) {
            resInclude = new HashMap<String, String>();
            for (String val : temp) {
                resInclude.put(val, val);
            }
        }
        if ((exclude = prop.getProperty("USER_RES_EXCLUDE")) != null && !exclude.isEmpty()) {
            resExclude = PackageCLI.parseFilter(exclude);
        }
        PackageNativeCLICommand nativePackageCommand = new PackageNativeCLICommand();
        nativePackageCommand.setWorkingDir(path);
        nativePackageCommand.setProjectPath(this.projectPath);
        nativePackageCommand.setProfileName(sign);
        nativePackageCommand.setResExclude(resExclude);
        nativePackageCommand.setResInclude(resInclude);
        nativePackageCommand.setReferencePaths(refPathList);
        if (outputPath != null && !outputPath.isEmpty()) {
            nativePackageCommand.setOutputPath(outputPath);
        }
        if ("on".equals(this.strip)) {
            nativePackageCommand.setIsStrip(true);
        }
        if (null != (nativeData = (PackageNativeCLICommandData)nativePackageCommand.runCommand())) {
            String tpkOutPath = nativeData.getTpkPath();
            if (null == tpkOutPath) return 0;
            this.progressLog.info("Package File Location: {}", (Object)tpkOutPath);
            return 0;
        }
        this.progressLog.info("error occured on packaging.");
        return 1;
    }

    private boolean isValidRPKManifest(File path, String projPath) {
        File projectManifestFile = new File(projPath, "tizen-manifest.xml");
        if (!projectManifestFile.exists()) {
            this.log.trace("tizen-manifest.xml does not exist");
            this.log.trace("The entered path : " + path.toString());
            this.progressLog.info("Cannot provide a package function to this project");
            return false;
        }
        ManifestSchemaValidator validator = new ManifestSchemaValidator();
        try {
            if (!validator.isValidDocument(projectManifestFile, MANIFEST_XSD_RPK)) {
                this.log.trace("Invalid Manifest File");
                this.progressLog.info("Cannot validate the manifest file of the project");
                return false;
            }
            return true;
        }
        catch (SAXParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doPackageForRpk(File path, String projPath, String outputPath, List<String> refPathList, String sign) {
        ResourcePackageCLICommandData rpkData;
        if (!path.isDirectory()) return 1;
        if (!this.isValidRPKManifest(path, projPath)) {
            return 1;
        }
        ResourcePackageCLICommand rpkPackageCommand = new ResourcePackageCLICommand();
        rpkPackageCommand.setWorkingDir(path);
        rpkPackageCommand.setProjectPath(projPath);
        rpkPackageCommand.setProfileName(sign);
        rpkPackageCommand.setReferencePaths(refPathList);
        if (outputPath != null && !outputPath.isEmpty()) {
            rpkPackageCommand.setOutputPath(outputPath);
        }
        if (null != (rpkData = (ResourcePackageCLICommandData)rpkPackageCommand.runCommand())) {
            String rpkOutPath = rpkData.getRpkPath();
            if (null == rpkOutPath) return 0;
            this.progressLog.info("Package File Location: {}", (Object)rpkOutPath);
            return 0;
        } else {
            this.progressLog.info("error occurred on packaging.");
            return 1;
        }
    }

    @Override
    public int execute() {
        int result = -1;
        this.log.trace("Execute PackageCLI...");
        File path = this.getRealWorkingPath();
        this.log.trace("getRealWorkingPath: {}", (Object)path.toString());
        ArrayList<String> refPathList = null;
        if (this.referencePaths != null && this.referencePaths.length > 0) {
            for (String referencePath : this.referencePaths) {
                String[] refPaths;
                for (String refPath : refPaths = referencePath.split(";")) {
                    String realrefPath;
                    if (refPath.startsWith(".")) {
                        String cwd = this.currentWorkspacePath != null ? this.currentWorkspacePath.toString() : System.getProperty("user.dir");
                        realrefPath = cwd + File.separator + refPath;
                    } else if (refPath.startsWith("~")) {
                        String userHome = System.getProperty("user.home");
                        realrefPath = userHome + refPath.substring(1);
                    } else {
                        realrefPath = refPath;
                    }
                    if (refPathList == null) {
                        refPathList = new ArrayList<String>();
                    }
                    refPathList.add(realrefPath);
                }
            }
        }
        if (!path.exists()) {
            this.progressLog.info("Specify location of the working directory.");
            return -1;
        }
        if (this.projectPath == null) {
            this.projectPath = path.getParent();
        } else {
            try {
                this.projectPath = new File(this.projectPath).getCanonicalPath();
            }
            catch (Exception e) {
                this.log.debug(e.getMessage());
                this.progressLog.info("Cannot resolve the project directory.");
                return -1;
            }
        }
        if (this.outputPath == null) {
            try {
                this.outputPath = path.isDirectory() ? path.getPath() : path.getParent();
            }
            catch (Exception e) {
                this.log.debug(e.getMessage());
                this.progressLog.info("Cannot resolve the output directory.");
                return -1;
            }
        }
        if (this.outputPath.startsWith(".")) {
            if (this.projectPath != null) {
                this.outputPath = this.currentWorkspacePath + File.separator + this.outputPath;
            }
            try {
                this.outputPath = new File(this.outputPath).getCanonicalPath();
            }
            catch (IOException e) {
                this.log.debug(e.getMessage());
                this.progressLog.info("Cannot resolve the output directory.");
                return -1;
            }
        }
        if (this.type.equals("wgt")) {
            result = this.doPackageForWgt(path, this.projectPath, this.outputPath, refPathList, this.sign);
        } else if (this.type.equals("tpk")) {
            result = this.doPackageForTpk(path, this.projectPath, this.outputPath, refPathList, this.sign);
        } else if (this.type.equals("rpk")) {
            this.projectPath = path.toString();
            result = this.doPackageForRpk(path, this.projectPath, this.outputPath, refPathList, this.sign);
        }
        return result;
    }
}

