/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tizen.library.sdkutils.util.ContentEditUtil;
import org.tizen.library.sdkutils.util.Log;
import org.tizen.library.sdkutils.util.PathUtil;
import org.tizen.library.sdkutils.util.SDKInfoUtil;

public class ConfigUtil {
    public static ConfigUtil getInstance() {
        return ConfigUtilHolder.instance;
    }

    private ConfigUtil() {
    }

    public synchronized boolean shouldCheckUpdateable() {
        String directoryPath = SDKInfoUtil.findSDKDataPath(Log.class) + File.separator + "sdk-utils-log";
        File sdkUtilsInfoFile = new File(directoryPath + File.separator + "sdk-utils.info");
        try {
            boolean isCreated = this.createSDKUtilsInfoFile(sdkUtilsInfoFile);
            if (!isCreated) {
                String sDoNotShowAgain = ContentEditUtil.getContent(sdkUtilsInfoFile, "DoNotShowAgain");
                String sPopupDurationLimit = ContentEditUtil.getContent(sdkUtilsInfoFile, "PopupDurationLimit");
                String sLastPopupDate = ContentEditUtil.getContent(sdkUtilsInfoFile, "LastPopupDate");
                sDoNotShowAgain = sDoNotShowAgain.trim();
                sPopupDurationLimit = sPopupDurationLimit.trim();
                sLastPopupDate = sLastPopupDate.trim();
                Boolean bDoNotShowAgain = Boolean.valueOf(sDoNotShowAgain);
                if (bDoNotShowAgain.booleanValue()) {
                    Log.info("DoNotShowAgain" + sDoNotShowAgain);
                    return false;
                }
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd-HHmmss");
                Date currentDate = new Date();
                Date lastPopupDate = dateFormatter.parse(sLastPopupDate);
                Log.info("DoNotShowAgain: " + sDoNotShowAgain);
                Log.info("PopupDurationLimit: " + sPopupDurationLimit);
                Log.info("LastPopupDate: " + sLastPopupDate);
                Log.info("Current Date: " + dateFormatter.format(currentDate));
                long diff = currentDate.getTime() - lastPopupDate.getTime();
                long dayDiffs = diff / 86400000L;
                long lPopupDurationLimit = Long.valueOf(sPopupDurationLimit);
                Log.info("diff: " + diff + "\t--> diffDays: " + dayDiffs);
                if (dayDiffs < lPopupDurationLimit) {
                    return false;
                }
                if (!ContentEditUtil.replaceContent(sdkUtilsInfoFile, "LastPopupDate", dateFormatter.format(currentDate))) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            Log.catching(e);
            return false;
        }
        return true;
    }

    public boolean getDoNotShowAgain() {
        boolean result = false;
        try {
            String directoryPath = SDKInfoUtil.findSDKDataPath(Log.class) + File.separator + "sdk-utils-log";
            File sdkUtilsInfoFile = new File(directoryPath + File.separator + "sdk-utils.info");
            String sDoNotShowAgain = ContentEditUtil.getContent(sdkUtilsInfoFile, "DoNotShowAgain");
            result = Boolean.valueOf(sDoNotShowAgain);
        }
        catch (Exception e) {
            Log.catching(e);
        }
        return result;
    }

    public boolean toggleDoNotShowAgain() {
        boolean result = false;
        boolean doNotShowAgain = false;
        try {
            String directoryPath = SDKInfoUtil.findSDKDataPath(Log.class) + File.separator + "sdk-utils-log";
            File sdkUtilsInfoFile = new File(directoryPath + File.separator + "sdk-utils.info");
            String sDoNotShowAgain = ContentEditUtil.getContent(sdkUtilsInfoFile, "DoNotShowAgain");
            doNotShowAgain = Boolean.valueOf(sDoNotShowAgain);
            doNotShowAgain = !doNotShowAgain;
            result = ContentEditUtil.replaceContent(sdkUtilsInfoFile, "DoNotShowAgain", Boolean.valueOf(doNotShowAgain).toString());
        }
        catch (Exception e) {
            Log.catching(e);
        }
        return result;
    }

    public long getPopupDurationLimit() {
        long result = 0L;
        try {
            String directoryPath = SDKInfoUtil.findSDKDataPath(Log.class) + File.separator + "sdk-utils-log";
            File sdkUtilsInfoFile = new File(directoryPath + File.separator + "sdk-utils.info");
            String sCallWindow = ContentEditUtil.getContent(sdkUtilsInfoFile, "PopupDurationLimit");
            result = Long.valueOf(sCallWindow);
        }
        catch (Exception e) {
            Log.catching(e);
        }
        return result;
    }

    public boolean setPopupDurationLimit(long newValue) {
        boolean result = false;
        try {
            String directoryPath = SDKInfoUtil.findSDKDataPath(Log.class) + File.separator + "sdk-utils-log";
            File sdkUtilsInfoFile = new File(directoryPath + File.separator + "sdk-utils.info");
            result = ContentEditUtil.replaceContent(sdkUtilsInfoFile, "PopupDurationLimit", Long.valueOf(newValue).toString());
        }
        catch (Exception e) {
            Log.catching(e);
        }
        return result;
    }

    private boolean createSDKUtilsInfoFile(File sdkUtilsInfoFile) {
        boolean retVal = false;
        if (!sdkUtilsInfoFile.exists()) {
            try {
                sdkUtilsInfoFile.createNewFile();
            }
            catch (IOException e) {
                Log.catching(e);
            }
            ContentEditUtil.addContent(sdkUtilsInfoFile, "PopupDurationLimit", "1");
            ContentEditUtil.addContent(sdkUtilsInfoFile, "DoNotShowAgain", "false");
            ContentEditUtil.addContent(sdkUtilsInfoFile, "LastPopupDate", new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()));
            retVal = true;
        }
        return retVal;
    }

    public static String getVersionFromPkgInfoManifest() {
        File pkgInfo;
        String result = "0.0.1";
        String path = PathUtil.getClassPath(ConfigUtil.class);
        File retFile = null;
        for (File curFile = new File(path); curFile != null; curFile = curFile.getParentFile()) {
            File[] list;
            if (!curFile.isDirectory() || (list = curFile.listFiles()) == null) continue;
            for (File f : list) {
                if (!f.isDirectory() || !f.getName().equals("package")) continue;
                retFile = f;
                break;
            }
            if (retFile != null) break;
        }
        if (retFile != null && (pkgInfo = new File(path = retFile.getAbsolutePath() + File.separator + "pkginfo.manifest")).exists()) {
            result = ContentEditUtil.getContent(pkgInfo, "Version", ":");
            result = result.trim();
        }
        return result;
    }

    private static class ConfigUtilHolder {
        public static final ConfigUtil instance = new ConfigUtil();

        private ConfigUtilHolder() {
        }
    }
}

