/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.config.Preference;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.TemplateContext;

public class ModelProvider
implements IModelProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<String, Object> models = new HashMap<String, Object>();

    public ModelProvider() {
        this(new HashMap<String, Object>());
    }

    public ModelProvider(Map<String, Object> models) {
        this.models = models;
    }

    @Override
    public Object getModel(String key) {
        Object obj;
        if (this.models.containsKey(key)) {
            return this.models.get(key);
        }
        this.logger.debug("Model doesn't exist for {} :{}", (Object)key, this.models);
        if (this != TemplateContext.getInstance().getModelProvider() && (obj = TemplateContext.get(key)) != null) {
            return obj;
        }
        return Preference.getValue((String)key, null);
    }

    @Override
    public boolean isEmpty() {
        return this.models.isEmpty();
    }

    @Override
    public Collection<String> keys() {
        return Collections.unmodifiableCollection(this.models.keySet());
    }
}

