/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.file.FileHandlingCommand;
import org.tizen.common.core.command.policy.OptionPolicy;
import org.tizen.common.core.command.prompter.FileHandlingOption;
import org.tizen.common.core.command.prompter.Option;
import org.tizen.common.core.command.prompter.RunnableOption;
import org.tizen.common.file.FileHandler;

public class EclipseMoveHandlingCommand
extends FileHandlingCommand<Boolean> {
    private static Logger logger = LoggerFactory.getLogger(EclipseMoveHandlingCommand.class);
    private List<MoveFile> moveFileList;
    private FileHandlingOption selectedAllFlagOption;

    public EclipseMoveHandlingCommand(List<MoveFile> moveFileList) {
        this.moveFileList = moveFileList;
    }

    protected boolean isExcludedFile(IResource sourceFile, File targetFile) {
        return false;
    }

    public void setOverwriteOption(FileHandlingOption opt) {
        this.selectedAllFlagOption = opt;
    }

    protected FileHandlingOption getOverwriteOption() {
        return this.selectedAllFlagOption;
    }

    protected boolean isCopyChildren() {
        return false;
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        Option[] options;
        FileHandler handler = context.getFileHandler();
        Policy policy = context.getPolicy("exist.file.when.copy");
        if (policy == null) {
            return;
        }
        OptionPolicy optionPolicy = policy.adapt(OptionPolicy.class);
        if (optionPolicy == null) {
            return;
        }
        Option[] optionArray = options = optionPolicy.getOptions();
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (!(option instanceof FileHandlingOption)) {
                throw new IllegalArgumentException(String.format("Option %s is not a FileHandlingOption", option.getName()));
            }
            ((FileHandlingOption)option).setHandler(handler);
            ++n2;
        }
        for (MoveFile moveFile : this.moveFileList) {
            String sourcePath = moveFile.source;
            String targetPath = moveFile.target;
            IResource member = moveFile.project.findMember(sourcePath);
            if (member == null || !member.exists()) continue;
            Stack<IResource> sourceStack = new Stack<IResource>();
            Stack<File> targetStack = new Stack<File>();
            sourceStack.push(member);
            targetStack.push(new File(targetPath));
            while (!sourceStack.isEmpty()) {
                IResource sourceFile = (IResource)sourceStack.pop();
                File targetFile = (File)targetStack.pop();
                if (sourceFile.getType() == 2) {
                    IFolder folder = (IFolder)sourceFile;
                    handler.makeDirectory(targetFile.getPath());
                    if (!this.isCopyChildren()) continue;
                    IResource[] iResourceArray = folder.members();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource sourceChild = iResourceArray[n4];
                        sourceStack.push(sourceChild);
                        targetStack.push(new File(targetFile, sourceChild.getName()));
                        ++n4;
                    }
                    continue;
                }
                if (sourceFile.getType() == 1) {
                    if (this.isExcludedFile(sourceFile, targetFile)) continue;
                    if (targetFile.exists()) {
                        RunnableOption resultOption = null;
                        FileHandlingOption selectedAllFlagOption = this.getOverwriteOption();
                        resultOption = selectedAllFlagOption == null ? (RunnableOption)context.getPrompter().interact(String.valueOf(targetFile.getCanonicalPath()) + " already exists", options) : selectedAllFlagOption;
                        if (resultOption.isAllFlag()) {
                            this.setOverwriteOption((FileHandlingOption)resultOption);
                        }
                        if (!(resultOption.equals(FileHandlingOption.IGNORE) || resultOption.equals(FileHandlingOption.IGNORE_ALL) || resultOption.equals(FileHandlingOption.OVERWRITE) || resultOption.equals(FileHandlingOption.OVERWRITE_ALL))) {
                            resultOption.setArgument(sourceFile.getLocation().toFile(), targetFile);
                            resultOption.run();
                        }
                    }
                    if (targetFile.getParentFile() != null && !targetFile.getParentFile().exists()) {
                        targetFile.getParentFile().mkdirs();
                    }
                    Files.move(new File(sourceFile.getLocation().toOSString()).toPath(), new File(targetFile.getPath()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                logger.warn(String.format("%s is not a file or directory", sourceFile));
            }
            moveFile.project.refreshLocal(2, null);
        }
    }

    public static class MoveFile {
        private IProject project;
        private String source;
        private String target;

        public MoveFile(IProject project, String source, String target) {
            this.project = project;
            this.source = source;
            this.target = target;
        }
    }
}

