/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createweb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;

public class ProjectGenUtil {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String CONFIG_FILE = "tools/ide/resources/web/conf/config.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyConfigFile(String destConfigPath) {
        FileInputStream ips = null;
        FileOutputStream fos = null;
        String sdkPath = InstallPathConfig.getSDKPath();
        File ConfFile = new File(sdkPath, "tools/ide/resources/web/conf/config.xml");
        try {
            ips = new FileInputStream(ConfFile);
            fos = new FileOutputStream(destConfigPath);
            FileUtil.redirectStream((InputStream)ips, (OutputStream)fos);
        }
        catch (IOException e) {
            int n;
            try {
                this.logger.error("Error occurs while creating config.xml file", (Object)e.getMessage());
                n = -1;
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{ips, fos});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{ips, fos});
            return n;
        }
        IOUtil.tryClose((Object[])new Object[]{ips, fos});
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String extractBuiltinJarFiles(String resource) {
        String templateLibPath;
        block16: {
            URL url = this.getClass().getClassLoader().getResource(resource);
            if (url == null) {
                this.logger.error("not found jar file");
                return null;
            }
            String urlPath = url.getPath();
            try {
                urlPath = URLDecoder.decode(urlPath, "utf-8");
                urlPath = new File(urlPath).getPath();
                templateLibPath = urlPath + File.separator;
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("not decode url path", (Object)e.getMessage());
                return null;
            }
            if (urlPath.contains("!")) {
                File destDirFile;
                JarFile jar;
                FileOutputStream fos;
                InputStream is;
                String destDirPath;
                String jarPath;
                block15: {
                    String urlPathTemp = urlPath.replaceAll("file:", "");
                    jarPath = urlPathTemp.substring(0, urlPathTemp.lastIndexOf(33));
                    destDirPath = jarPath + "_dir";
                    templateLibPath = destDirPath + File.separator + resource + File.separator;
                    is = null;
                    fos = null;
                    jar = null;
                    destDirFile = new File(destDirPath);
                    if (!destDirFile.isDirectory()) break block15;
                    String string = templateLibPath;
                    IOUtil.tryClose((Object[])new Object[]{fos, is, jar});
                    return string;
                }
                try {
                    if (!destDirFile.mkdir()) {
                        this.logger.error("Unable to make directory");
                    }
                    jar = new JarFile(jarPath);
                    Enumeration<JarEntry> enum2 = jar.entries();
                    while (enum2.hasMoreElements()) {
                        JarEntry file = enum2.nextElement();
                        File f = new File(destDirPath + File.separator + file.getName());
                        if (file.isDirectory()) {
                            f.mkdir();
                            continue;
                        }
                        is = jar.getInputStream(file);
                        fos = new FileOutputStream(f);
                        while (is.available() > 0) {
                            fos.write(is.read());
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    this.logger.error(e.getMessage());
                    IOUtil.tryClose((Object[])new Object[]{fos, is, jar});
                    break block16;
                }
                catch (IOException e2) {
                    this.logger.error(e2.getMessage());
                    {
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{fos, is, jar});
                            throw throwable;
                        }
                    }
                    IOUtil.tryClose((Object[])new Object[]{fos, is, jar});
                }
                IOUtil.tryClose((Object[])new Object[]{fos, is, jar});
            }
        }
        return templateLibPath;
    }
}

