/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.target;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.sign.util.XMLUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.target.InstallPermit;
import org.tizen.ncli.util.TargetUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import security.ProfileParser;

public class InstallPermitCLICommand
extends AbstractSubCommand<InstallPermit> {
    private static final String DEVICE_PROFILE_NAME = "device-profile.xml";
    private static final String ROOT_ATTR_ACTIVE = "active";
    private static final String PROFILE_ELEMENT = "profile";
    private static final String PROFILE_ATTR_NAME = "name";
    public static final String PROFILEITEM_ELEMENT = "profileitem";
    public static final String PROFILEITEM_ATTR_KEY = "key";
    private static final String DELIMETER_REGEXP = "\\.";
    private static final String VERSION_3 = "3.0";
    private static final String VERSION_1 = "1.0";
    private IDevice target = null;
    public PlatformCapability platformCapabilityChecker = null;

    @Override
    protected InstallPermit call() {
        InstallPermit result = new InstallPermit();
        if (this.target == null) {
            this.progressLog.info(TizenCLIMessages.CANNOT_GET_TARGET);
            return null;
        }
        this.pushToDeviceProfile();
        return result;
    }

    public void setTarget(String targetSerialId) {
        this.target = TargetUtil.getDefault().getTarget(targetSerialId);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetSerialId));
        if (this.target == null) {
            throw new UnexpectedException(2, "[target]: null");
        }
    }

    public void setTargetByName(String targetName) {
        this.target = TargetUtil.getDefault().getTargetByName(targetName);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetName));
        if (this.target == null) {
            throw new UnexpectedException(2, "[target]: null");
        }
    }

    public void pushToDeviceProfile() {
        String duid = "";
        try {
            PlatformCapability platformCapabilityChecker = this.target.getPlatformCapability();
            duid = this.target.getDUID();
            if (!duid.startsWith("#1.0") && !platformCapabilityChecker.getProfileName().equals("tv")) {
                this.progressLog.info(TizenCLIMessages.INVALID_TARGET_FOR_PERMIT);
                return;
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
        }
        File activeProfile = this.activeSignDeviceProfilePath();
        if (activeProfile == null || !activeProfile.exists()) {
            return;
        }
        String certPath = this.getCertTargetPath(this.target);
        if (certPath == null) {
            return;
        }
        if (!this.checkDUIDTOTargetDevice(duid, this.target, activeProfile.getAbsolutePath())) {
            return;
        }
        this.permitToInstall(activeProfile.getAbsolutePath(), certPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void permitToInstall(String fromFiles, String certPath) {
        SyncService sync = null;
        try {
            sync = this.target.getSyncService();
            SyncResult syncResult = sync.push(fromFiles, this.target.getFileEntry(certPath));
            if (syncResult.isOk()) {
                this.progressLog.info("Install Permitted");
            } else {
                this.progressLog.info("Cannot push profile to device");
                this.log.error("Cannot push profile to device");
            }
            if (sync == null) return;
        }
        catch (IOException e) {
            try {
                this.log.error("[Fail] Fail to push package.");
                if (sync == null) return;
            }
            catch (Throwable throwable) {
                if (sync == null) throw throwable;
                IOUtil.tryClose((Object[])new Object[]{sync});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{sync});
            return;
        }
        IOUtil.tryClose((Object[])new Object[]{sync});
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File activeSignDeviceProfilePath() {
        FileInputStream inputStream;
        File activeProfileFile;
        block8: {
            Node rootNode;
            String activeProfileName;
            block9: {
                activeProfileFile = null;
                activeProfileName = "";
                IPath profilesPath = SigningProfileUtil.getProfilesPath();
                File profileFile = new File(profilesPath.toString());
                inputStream = null;
                if (profileFile.exists()) {
                    inputStream = new FileInputStream(profileFile);
                }
                if (inputStream == null) break block8;
                Document document = XMLUtil.create(inputStream);
                rootNode = document.getFirstChild();
                if (rootNode instanceof Element) break block9;
                File file = null;
                IOUtil.tryClose((Object[])new Object[]{inputStream});
                return file;
            }
            try {
                Element rootElement = (Element)rootNode;
                activeProfileName = rootElement.getAttribute(ROOT_ATTR_ACTIVE);
                NodeList profileNodes = rootElement.getElementsByTagName(PROFILE_ELEMENT);
                int n = profileNodes.getLength();
                for (int i = 0; i < n; ++i) {
                    Element itemElement;
                    String distributorKeyPath;
                    Node nodeItem;
                    NodeList itemNodes;
                    Element profileElement;
                    String profileName;
                    Node profileNode = profileNodes.item(i);
                    if (!(profileNode instanceof Element) || !activeProfileName.equalsIgnoreCase(profileName = (profileElement = (Element)profileNode).getAttribute(PROFILE_ATTR_NAME)) || (itemNodes = profileElement.getElementsByTagName(PROFILEITEM_ELEMENT)) == null || !((nodeItem = itemNodes.item(1)) instanceof Element) || (distributorKeyPath = (itemElement = (Element)nodeItem).getAttribute(PROFILEITEM_ATTR_KEY)) == null) continue;
                    File distributorKeyFile = new File(distributorKeyPath);
                    activeProfileFile = new File(distributorKeyFile.getParent(), DEVICE_PROFILE_NAME);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                try {
                    this.log.error(e.getMessage());
                    this.progressLog.error(e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{inputStream});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{inputStream});
            }
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        if (activeProfileFile == null || !activeProfileFile.exists()) {
            this.log.error("Please check the active certificate profile");
            this.progressLog.error("Please check the active certificate profile");
        }
        return activeProfileFile;
    }

    public String getCertTargetPath(IDevice targetDevice) {
        String certPath = "/home/developer";
        try {
            if (InstallPermitCLICommand.isSameOrBiggerThanVersion3(targetDevice.getPlatformInfo().getPlatformVersion())) {
                certPath = targetDevice.getPlatformCapability().getSdkToolPath();
            }
        }
        catch (IllegalArgumentException e) {
            try {
                String unknownPlatformVersion = targetDevice.getPlatformCapability().getPlatformVersion();
                if (unknownPlatformVersion.equals("unknown")) {
                    this.log.error("The version of the device is unknown");
                    this.progressLog.error("The version of the device is unknown");
                    return null;
                }
            }
            catch (Exception e1) {
                this.log.error("Failed to upload a certificate.");
                this.progressLog.error("Failed to upload a certificate.");
                return null;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to upload a certificate.");
            this.progressLog.error("Failed to upload a certificate.");
            return null;
        }
        return certPath;
    }

    public static boolean isSameOrBiggerThanVersion3(String checkVersion) {
        String[] thisParts = checkVersion.split(DELIMETER_REGEXP);
        String[] thatParts = VERSION_3.split(DELIMETER_REGEXP);
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
            if (thisPart < thatPart) {
                return false;
            }
            if (thisPart <= thatPart) continue;
            return true;
        }
        return true;
    }

    public boolean checkDUIDTOTargetDevice(String DUID, IDevice targetDevice, String registrationPath) {
        try {
            if (null == DUID) {
                this.log.error("Cannot get DUID from device.");
                this.progressLog.error("Cannot get DUID from device.");
                return false;
            }
            String targetDUID = InstallPermitCLICommand.getDUIDWithoutPrefix(DUID);
            ArrayList profileDUIDs = ProfileParser.getDUID((String)registrationPath);
            ArrayList<String> certDUIDs = InstallPermitCLICommand.getDUIDListWithoutPrefix(profileDUIDs);
            if (null == certDUIDs || certDUIDs.size() == 0) {
                this.log.error("There are no DUIDs in certificate.");
                this.progressLog.error("There are no DUIDs in certificate.");
                return false;
            }
            for (String certDUID : certDUIDs) {
                if (!targetDUID.equals(certDUID)) continue;
                return true;
            }
            this.log.error("No DUID for selected device  was found in the certificate profile.\\\\n\\\\nPlease open the Certificate Manager through the link below.\\\\nAfter creating and activating a samsung certificate profile,\\\\nclose the Certificate Manager and click the Retry button.\\\\n");
            this.progressLog.error("No DUID for selected device  was found in the certificate profile.\\\\n\\\\nPlease open the Certificate Manager through the link below.\\\\nAfter creating and activating a samsung certificate profile,\\\\nclose the Certificate Manager and click the Retry button.\\\\n");
            return false;
        }
        catch (Exception e) {
            this.log.error("Failed to upload a certificate.");
            this.progressLog.error("Failed to upload a certificate.");
            return false;
        }
    }

    public static String getDUIDWithoutPrefix(String duid) {
        return !duid.contains("#") ? duid : duid.split("#")[1];
    }

    public static ArrayList<String> getDUIDListWithoutPrefix(ArrayList<String> duids) {
        ArrayList<String> list = new ArrayList<String>();
        for (String duid : duids) {
            list.add(InstallPermitCLICommand.getDUIDWithoutPrefix(duid));
        }
        return list;
    }
}

