/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands;

import java.io.File;
import java.util.List;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.ListRootstrap;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeOption;
import org.tizen.sbilib.for_cli.sbiplugin.SBIFrameworkData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapManager;

public class ListRootstrapCLICommand
extends AbstractSubCommand<ListRootstrap> {
    private final String VIEW_FORMAT = "%-40s %s";
    private final String TITLE_FORMAT = String.format("%-40s %s", "[ROOTSTRAP]", "[INFORMATION]");
    private final String VIEW_FORMAT_FRAMEWORK = "%-30s%-20s%s";
    private final String TITLE_FORMAT_FRAMEWORK = String.format("%-30s%-20s%s", "[FRAMEWORK NAME]", "[TYPE]", "[DESCRIPTION]");
    private List<String> arguments;

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    @Override
    protected ListRootstrap call() {
        String sdkPath = InstallPathConfig.getSDKPath();
        String sbiHomePath = sdkPath + File.separator + BuildNativeOption.SBI_HOME_PATH;
        List rootstrapDataList = SBIRootstrapManager.getRootstrapDataList((String)sbiHomePath);
        if (rootstrapDataList == null || rootstrapDataList.isEmpty()) {
            this.progressLog.info("There is no rootstrap.");
            return null;
        }
        ListRootstrap list = new ListRootstrap();
        if (this.arguments.isEmpty()) {
            this.progressLog.info(this.TITLE_FORMAT);
            for (SBIRootstrapData rootstrap : rootstrapDataList) {
                String projectInfo = String.format("%-40s %s", rootstrap.getId(), rootstrap.getPlatformName() + ", " + rootstrap.getArchitecture());
                this.progressLog.info(projectInfo);
            }
        } else {
            if (this.arguments.size() > 1) {
                this.progressLog.info("Specify only one rootstrap.");
                return null;
            }
            SBIRootstrapData data = null;
            for (SBIRootstrapData r : rootstrapDataList) {
                if (!r.getId().equals(this.arguments.get(0))) continue;
                data = r;
                break;
            }
            if (data == null) {
                this.progressLog.info("There is no matched rootstrap for " + this.arguments.get(0));
                return null;
            }
            this.progressLog.info("rootstrap : " + data.getId());
            this.progressLog.info(this.TITLE_FORMAT_FRAMEWORK);
            File infoXml = new File(data.getProperty("DEV_PACKAGE_CONFIG_PATH").replace("#{SBI_HOME}", sbiHomePath));
            String rootstrapId = data.getId();
            List frameworkDataList = SBIRootstrapManager.getFrameworkDataList((File)infoXml, (String)rootstrapId);
            if (frameworkDataList == null || frameworkDataList.isEmpty()) {
                this.progressLog.info("There is no framework for " + this.arguments.get(0));
                return null;
            }
            for (SBIFrameworkData framework : frameworkDataList) {
                String frameworkInfo = String.format("%-30s%-20s%s", framework.getName() == null ? "" : framework.getName(), framework.getType() == null ? "" : framework.getType(), framework.getDescription() == null ? "" : framework.getDescription());
                this.progressLog.info(frameworkInfo);
            }
        }
        return list;
    }
}

