/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.tizen.common.config.Preference;
import org.tizen.common.config.PreferenceProvider;
import org.tizen.core.gputil.PropertiesUtil;
import org.tizen.ncli.config.ConfigConstant;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.config.NCLIConfigLoader;
import org.tizen.ncli.core.config.TizenCLIConfigProvider;
import org.tizen.ncli.subcommands.AbstractSubCommand;

public class ConfigCLICommand
extends AbstractSubCommand<Configuration> {
    private boolean list = false;
    private boolean global = false;
    private String deleteKey = null;
    private Map<String, String> properties = new HashMap<String, String>();

    public void setConfig(String key, String value) {
        this.properties.put(key, value);
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public void setDeleteKey(String key) {
        this.deleteKey = key;
    }

    public void setKeyValue(Map<String, String> properties) {
        this.properties = properties;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Configuration call() {
        if (this.list) {
            return new Configuration();
        }
        if (this.deleteKey != null) {
            if (this.deleteKey(this.deleteKey)) return new Configuration();
            return null;
        }
        if (this.global) {
            this.log.trace("global config set call() - {}", this.properties);
            Set<String> keySet = this.properties.keySet();
            for (String key : keySet) {
                if (!this.isDefaultKey(key)) continue;
                this.properties.remove(key);
                this.progressLog.warn("\"{}\" is a default configurations, so cannot set as a global.", (Object)key);
            }
            Properties load = NCLIConfigLoader.loadGlobalConf();
            this.updateProperties(load);
            if (NCLIConfigLoader.writeProperties2File(NCLIConfigLoader.getGlobalConfigFile(), load)) {
                Preference.register((String)"TIZEN.CLI.GLOBAL", (PreferenceProvider)new TizenCLIConfigProvider(NCLIConfigLoader.loadGlobalConf()));
                return new Configuration();
            }
            this.progressLog.error("Failed to write global configuration file!");
            return null;
        }
        this.log.trace("local config set call() - {}", this.properties);
        Properties load = NCLIConfigLoader.loadLocalConf();
        this.updateProperties(load);
        if (NCLIConfigLoader.writeProperties2File(NCLIConfigLoader.getLocalConfigFile(), load)) {
            Preference.register((String)"TIZEN.CLI.LOCAL", (PreferenceProvider)new TizenCLIConfigProvider(NCLIConfigLoader.loadLocalConf()));
            return new Configuration();
        }
        this.progressLog.error("Failed to write configuration file!");
        return null;
    }

    private void updateProperties(Properties load) {
        Set<String> keySet = this.properties.keySet();
        for (String key : keySet) {
            String value = this.properties.get(key);
            load.setProperty(key, value);
            this.log.trace("key :{} , value :{}", (Object)key, (Object)value);
        }
    }

    private boolean deleteKey(String key) {
        File file = this.getPropertiesFile();
        Properties load = NCLIConfigLoader.loadConf(file, false);
        if (this.isDefaultKey(key)) {
            this.progressLog.warn("Cannot remove default key.");
            return false;
        }
        load.remove(key);
        try {
            PropertiesUtil.saveProperties((File)file, (Properties)load);
        }
        catch (IOException e) {
            this.progressLog.error(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private File getPropertiesFile() {
        if (this.global) {
            return NCLIConfigLoader.getGlobalConfigFile();
        }
        return NCLIConfigLoader.getLocalConfigFile();
    }

    private boolean isDefaultKey(String key) {
        return ConfigConstant.DEFAULT_CONFIGURATION_KEY_VALUE.keySet().contains(key);
    }
}

