/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.coverage;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.tizen.sdblib.util.IOUtil;

public class ReportInfo {
    private File reportFile;
    private int lineCount = 0;
    private int missedCount = 0;
    private float percent = 0.0f;

    public ReportInfo(File report) {
        this.reportFile = report;
        this.populateData(this.reportFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateData(File file) {
        BufferedReader bufferedTextIn;
        block7: {
            bufferedTextIn = null;
            try {
                bufferedTextIn = new BufferedReader(new FileReader(file));
                String content = null;
                content = bufferedTextIn.readLine();
                while (content != null) {
                    if (!content.startsWith("TOTAL ")) {
                        content = bufferedTextIn.readLine();
                        continue;
                    }
                    String[] data = (content = content.replaceAll("\\s", "")).split(":");
                    if (data.length < 5) continue;
                    this.lineCount += Integer.parseInt(data[1]);
                    this.missedCount += Integer.parseInt(data[2]);
                }
                if (this.lineCount == 0) break block7;
            }
            catch (IOException ioe) {
                block8: {
                    try {
                        ioe.printStackTrace();
                        if (this.lineCount == 0) break block8;
                    }
                    catch (Throwable throwable) {
                        if (this.lineCount != 0) {
                            this.percent = (float)((this.lineCount - this.missedCount) * 100) / (float)this.lineCount;
                        }
                        IOUtil.tryClose(bufferedTextIn);
                        throw throwable;
                    }
                    this.percent = (float)((this.lineCount - this.missedCount) * 100) / (float)this.lineCount;
                }
                IOUtil.tryClose((Closeable)bufferedTextIn);
            }
            this.percent = (float)((this.lineCount - this.missedCount) * 100) / (float)this.lineCount;
        }
        IOUtil.tryClose((Closeable)bufferedTextIn);
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getMissCount() {
        return this.missedCount;
    }

    public float getPercent() {
        return this.percent;
    }
}

