/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.Version;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.util.IOUtil;
import org.tizen.nativecommon.build.NativeDefaultSigner;
import org.tizen.nativecommon.build.NativeSigner;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.buildnative.BuildInfo;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeOption;
import org.tizen.ncli.subcommands.packages.NativeProject;
import org.tizen.ncli.subcommands.packages.PackageData;
import org.tizen.ncli.subcommands.packages.PackageNativeCLICommandData;
import org.tizen.ncli.subcommands.packages.PackageProject;
import org.tizen.ncli.util.DirectoryUtil;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapManager;
import org.tizen.sbilib.for_cli.sbiplugin.SBIToolchainData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIToolchainManager;
import org.tizen.tpklib.TPK;
import org.tizen.tpklib.core.sign.ISigner;
import org.tizen.tpklib.exception.TPKException;
import org.w3c.dom.Document;

public class PackageNativeCLICommand
extends AbstractSubCommand<PackageNativeCLICommandData> {
    private PackageNativeCLICommandData data = new PackageNativeCLICommandData();
    private Configuration config = new Configuration();
    private String profilesPath;
    private String profileName;
    private String projectPath;
    private String outputPath;
    private String extraDirPath;
    private String tpkPath = null;
    private String tepPath = null;
    private boolean isStrip = false;
    private List<String> refPaths = null;

    @Override
    protected PackageNativeCLICommandData call() {
        boolean result;
        String buildOutput;
        if (this.data == null) {
            return null;
        }
        try {
            buildOutput = this.workingDir.getCanonicalPath();
        }
        catch (IOException e1) {
            this.progressLog.error("Packaging error : Cannot find build output directory.");
            return null;
        }
        String projDir = this.data.getProjectDir();
        PackageData ssiData = PackageNativeCLICommand.getEnv(this.workingDir.toString(), projDir, this.log);
        if (ssiData == null) {
            this.progressLog.error("Packaging error : Cannot get the project information from project file.");
            return null;
        }
        String stripper = null;
        if (this.isStrip) {
            SBIToolchainData.ToolData tool;
            String sdkPath = InstallPathConfig.getSDKPath();
            String sbiHomePath = null;
            if (sdkPath == null) {
                this.log.debug("Cannot get SDKPath");
                throw new UnexpectedException(2, "Cannot get SDKPath.");
            }
            sbiHomePath = sdkPath + File.separator + BuildNativeOption.SBI_HOME_PATH;
            this.isStrip = false;
            String toolchainName = ssiData.getToolchain();
            List toolchainList = SBIToolchainManager.getToolchainDataList((String)sbiHomePath);
            SBIToolchainData toolchain = SBIToolchainManager.getToolchain((List)toolchainList, (String)toolchainName, (String)ssiData.getArchitecture());
            if (toolchain != null && (tool = toolchain.getTool("strip")) != null && (stripper = tool.pathOrg) != null && !stripper.isEmpty()) {
                if (toolchainName != null && toolchainName.startsWith("LLVM")) {
                    SBIToolchainData toolchain2;
                    SBIRootstrapData.ToolchainData defToolchainData;
                    String profileName = ssiData.getSbiProfile();
                    String profileVer = ssiData.getProfileVersion();
                    String arch = ssiData.getArchitecture();
                    List rootstapList = SBIRootstrapManager.getRootstrapDataList((String)sbiHomePath);
                    SBIRootstrapData rootstrap = SBIRootstrapManager.getRootstrap((List)rootstapList, (String)(profileName + " " + profileVer), (String)arch);
                    if (rootstrap != null && (defToolchainData = rootstrap.getDefaultToolchain("gcc")) != null && (toolchain2 = SBIToolchainManager.getToolchain((List)toolchainList, (String)(defToolchainData.name + "-" + defToolchainData.version), (String)arch)) != null) {
                        String defGccPath = toolchain2.getPath();
                        String defGccPrefix = toolchain2.getPropertyOrg("TOOLCHAIN_PREFIX");
                        stripper = stripper.replace("#{PLATFORM_DEFAULT_GCC_PATH}", defGccPath);
                        stripper = stripper.replace("#{PLATFORM_DEFAULT_GCC_PREFIX}", defGccPrefix);
                    }
                }
                if (new File(stripper = stripper.replace("#{SBI_HOME}", sbiHomePath)).exists()) {
                    this.isStrip = true;
                } else {
                    this.progressLog.info(String.format("Cannot found strip tool in '%s'.", stripper));
                }
            }
            if (!this.isStrip) {
                this.progressLog.info(String.format("Not supported strip option with current build configuration", new Object[0]));
            }
        }
        List<String> exclude = this.data.getResExclude();
        Map<String, String> include = this.data.getResInclude();
        String arch = ssiData.getArchitecture();
        if (arch != null) {
            if (arch.equals("i386")) {
                ssiData.setArchitecture("x86");
            } else if (arch.equals("armel")) {
                ssiData.setArchitecture("arm");
            }
        }
        if (result = this.doPackage(buildOutput, ssiData.getPackageName(), ssiData.getPackageVersion(), ssiData.getArchitecture(), ssiData.getArtifactName(), include, exclude, stripper, this.profileName, ssiData.getProfileVersion(), this.extraDirPath, ssiData.getResourcePackageFlag())) {
            this.data.tpkPath = this.genTpkPath(ssiData.getPackageName(), ssiData.getPackageVersion(), ssiData.getArchitecture());
            this.log.debug("Package path: {}", (Object)this.data.tpkPath);
            return this.data;
        }
        return null;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setExtraDirPath(String extraDirPath) {
        this.extraDirPath = extraDirPath;
    }

    public String getExtraDirPath() {
        return this.extraDirPath;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    public void setReferencePaths(List<String> refPaths) {
        this.refPaths = refPaths;
    }

    public List<String> getReferencePaths() {
        return this.refPaths;
    }

    private boolean setProfilesPath() {
        this.profilesPath = this.config.getValue("profiles.path");
        if (this.profilesPath == null) {
            this.profilesPath = this.config.getValue("default.profiles.path");
        }
        return this.profilesPath != null && !this.profilesPath.isEmpty();
    }

    public void setIsStrip(boolean isStrip) {
        this.isStrip = isStrip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackageData getEnv(String workingDir, String projDir, Logger log) {
        PackageData data = new PackageData();
        try {
            block17: {
                data.setWorkingDir(projDir);
                File parentFile = projDir == null || projDir.isEmpty() ? new File(workingDir).getParentFile() : new File(projDir);
                if (parentFile == null || !parentFile.exists()) {
                    log.error("Specify proper build configuration path");
                    return null;
                }
                String projectPath = parentFile.getCanonicalPath();
                log.debug("Base project directory: {}", (Object)projectPath);
                data.setProjectPath(projectPath);
                String projectFilePath = projectPath + File.separatorChar + ".project";
                data.setProjectFilePath(projectFilePath);
                String manifestPath = projectPath + File.separatorChar + "tizen-manifest.xml";
                data.setManifestFilePath(manifestPath);
                File projectDefFile = new File(projectPath, "project_def.prop");
                if (!projectDefFile.exists()) break block17;
                Properties prop = new Properties();
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(projectDefFile);
                    prop.load(inputStream);
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{inputStream});
                        throw throwable;
                    }
                    IOUtil.tryClose((Object[])new Object[]{inputStream});
                }
                IOUtil.tryClose((Object[])new Object[]{inputStream});
                String projectType = prop.getProperty("type");
                if (projectType == null) {
                    log.error("Cannot get project type");
                    throw new UnexpectedException(2, "Cannot get project type");
                }
                data.setProjType(projectType);
                String appId = prop.getProperty("APPNAME");
                data.setAppId(appId);
            }
            Document projectDoc = null;
            Document manifestDoc = null;
            try {
                projectDoc = data.getProjectFilePath() != null ? NativeProject.getDocument(data.getProjectFilePath()) : null;
                manifestDoc = data.getManifestFilePath() != null ? NativeProject.getDocument(data.getManifestFilePath()) : null;
            }
            catch (Exception e) {
                log.error("Error occured during getting project file", (Object)e.getMessage());
                return null;
            }
            BuildInfo buildInfo = PackageProject.getBuildInfo(workingDir, log);
            if (buildInfo == null) {
                log.error("Packaging error : Cannot find build information. \"build.info\" file does not exist.");
            }
            if (buildInfo != null) {
                String arch = buildInfo.getArchitecture();
                data.setArchitecture(arch);
                String profileName = buildInfo.getProfileName();
                data.setSbiProfile(profileName);
                String profileVer = buildInfo.getProfileVersion();
                data.setProfileVersion(profileVer);
                String toolchain = buildInfo.getToolchain();
                data.setToolchain(toolchain);
            }
            String packageName = NativeProject.getPackageName(manifestDoc);
            data.setPackageName(packageName);
            String packageVersion = NativeProject.getVersion(manifestDoc);
            data.setPackageVersion(packageVersion);
            String projectName = NativeProject.getProjectName(projectDoc);
            String artifactName = NativeProject.getArtifactName(manifestDoc);
            if (artifactName != null) {
                artifactName = artifactName.toLowerCase();
            } else if (projectName != null) {
                artifactName = projectName.toLowerCase();
            } else {
                log.error("cannot get artifact name.");
                return null;
            }
            if (data.getProjType().equalsIgnoreCase("sharedLib")) {
                artifactName = "lib" + artifactName + ".so";
            }
            data.setArtifactName(artifactName);
            boolean resourcePackageFlag = NativeProject.isIncludingResourcePackages(manifestDoc);
            data.setResourcePackageFlag(resourcePackageFlag);
            return data;
        }
        catch (IOException e) {
            log.error("Error occurred during setting working directory", (Object)e.getMessage());
            return null;
        }
    }

    private String genTpkPath(String packageName, String packageVersion, String architecture) {
        String pkgArch = this.getPkgArchitecture(architecture);
        this.tpkPath = pkgArch == null || pkgArch.isEmpty() ? this.outputPath + File.separatorChar + packageName + "-" + packageVersion + ".tpk" : this.outputPath + File.separatorChar + packageName + "-" + packageVersion + "-" + pkgArch + ".tpk";
        return this.tpkPath;
    }

    private String genTepPath(String packageName, String packageHash) {
        if (this.tepPath == null) {
            this.tepPath = this.outputPath + File.separatorChar + packageName + "-" + packageHash + ".tep";
        }
        return this.tepPath;
    }

    private String getPkgArchitecture(String architecture) {
        for (String arch : BuildNativeOption.ARCHGROUP_ARM) {
            if (!arch.equals(architecture)) continue;
            return BuildNativeOption.ARCHGROUP_ARM[0];
        }
        return architecture;
    }

    public void setProjectPath(String projDir) {
        this.data.setProjectDir(projDir);
    }

    public void setResExclude(List<String> resExclude) {
        this.data.setResExclude(resExclude);
    }

    public void setResInclude(Map<String, String> resInclude) {
        this.data.setResInclude(resInclude);
    }

    public boolean doPackage(String workingProjectConfigurationPath, String packageName, String packageVersion, String arch, String artifactName, Map<String, String> include, List<String> exclude, String stripper, String profileName, String profileVer, String extraDirPath, boolean resourcePackageFlag) {
        TPK tpk = TPK.getInstance();
        tpk.setOutputStream((OutputStream)System.out);
        tpk.setErrorStream((OutputStream)System.out);
        try {
            Version version;
            NativeDefaultSigner signer = null;
            boolean isSign = this.setProfilesPath();
            if ((profileName == null || profileName.isEmpty()) && isSign) {
                profileName = this.getActiveProfileName();
            }
            if (profileName != null && !profileName.isEmpty()) {
                if (!isSign) {
                    this.log.error(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
                    this.progressLog.error(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
                    return false;
                }
                signer = new NativeSigner(null);
            } else {
                this.progressLog.warn(TizenCLIMessages.SIGN_DEFAULT_PROFILE_WARN);
                signer = new NativeDefaultSigner();
            }
            boolean needEmptyDirectory = true;
            if (profileVer != null && (version = new Version(profileVer)).isSameOrBiggerThanVersion3()) {
                needEmptyDirectory = false;
            }
            tpk.packaging(this.data.getProjectDir(), workingProjectConfigurationPath, packageName, packageVersion, arch, artifactName, include, exclude, stripper, isSign, (ISigner)signer, this.profilesPath, profileName, extraDirPath, needEmptyDirectory, resourcePackageFlag);
            Path genTpkPath = Paths.get(workingProjectConfigurationPath, new String[0]);
            if (genTpkPath.toAbsolutePath().compareTo(Paths.get(this.outputPath, new String[0]).toAbsolutePath()) != 0) {
                Path genTpkFile = Paths.get(workingProjectConfigurationPath, packageName + "-" + packageVersion + "-" + arch + ".tpk");
                Path tgtTpkFile = Paths.get(this.genTpkPath(packageName, packageVersion, arch), new String[0]);
                if (arch == "") {
                    genTpkFile = Paths.get(workingProjectConfigurationPath, packageName + "-" + packageVersion + ".tpk");
                }
                if (!DirectoryUtil.createMissingDirectory(tgtTpkFile.getParent().toString())) {
                    return false;
                }
                this.log.trace("Copying %s to %s", (Object)genTpkFile.toAbsolutePath(), (Object)tgtTpkFile.toAbsolutePath());
                Files.copy(genTpkFile, tgtTpkFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (TPKException e) {
            this.log.error(e.getMessage());
            this.progressLog.error(e.getMessage());
            return false;
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            this.progressLog.error(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getActiveProfileName() {
        String string;
        SigningProfileContainer container = new SigningProfileContainer();
        InputStream in = null;
        try {
            in = new FileInputStream(this.profilesPath);
            in = new BufferedInputStream(in);
            container.readActiveProfileXML(in);
            string = container.getActiveProfileName();
        }
        catch (FileNotFoundException e) {
            try {
                this.log.error("Exception occurred.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{in});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{in});
            return null;
        }
        IOUtil.tryClose((Object[])new Object[]{in});
        return string;
    }
}

